/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.numeric;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.accessor.impl.numeric.ArrowFlightJdbcBaseIntVectorAccessor;
import org.apache.arrow.driver.jdbc.utils.AccessorTestUtils;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.vector.BaseIntVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.ValueVector;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ArrowFlightJdbcBaseIntVectorAccessorTest {
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    private BaseIntVector vector;
    private final Supplier<BaseIntVector> vectorSupplier;
    private final AccessorTestUtils.AccessorSupplier<ArrowFlightJdbcBaseIntVectorAccessor> accessorSupplier = (vector, getCurrentRow) -> {
        ArrowFlightJdbcAccessorFactory.WasNullConsumer noOpWasNullConsumer = wasNull -> {};
        if (vector instanceof UInt1Vector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((UInt1Vector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof UInt2Vector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((UInt2Vector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof UInt4Vector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((UInt4Vector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof UInt8Vector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((UInt8Vector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof TinyIntVector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((TinyIntVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof SmallIntVector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((SmallIntVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof IntVector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((IntVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof BigIntVector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((BigIntVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        throw new UnsupportedOperationException();
    };
    private final AccessorTestUtils.AccessorIterator<ArrowFlightJdbcBaseIntVectorAccessor> accessorIterator = new AccessorTestUtils.AccessorIterator<ArrowFlightJdbcBaseIntVectorAccessor>(this.collector, this.accessorSupplier);

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({() -> rootAllocatorTestRule.createIntVector(), "IntVector"}, {() -> rootAllocatorTestRule.createSmallIntVector(), "SmallIntVector"}, {() -> rootAllocatorTestRule.createTinyIntVector(), "TinyIntVector"}, {() -> rootAllocatorTestRule.createBigIntVector(), "BigIntVector"}, {() -> rootAllocatorTestRule.createUInt1Vector(), "UInt1Vector"}, {() -> rootAllocatorTestRule.createUInt2Vector(), "UInt2Vector"}, {() -> rootAllocatorTestRule.createUInt4Vector(), "UInt4Vector"}, {() -> rootAllocatorTestRule.createUInt8Vector(), "UInt8Vector"});
    }

    public ArrowFlightJdbcBaseIntVectorAccessorTest(Supplier<BaseIntVector> vectorSupplier, String vectorType) {
        this.vectorSupplier = vectorSupplier;
    }

    @Before
    public void setup() {
        this.vector = this.vectorSupplier.get();
    }

    @After
    public void tearDown() {
        this.vector.close();
    }

    @Test
    public void testShouldConvertToByteMethodFromBaseIntVector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcBaseIntVectorAccessor::getByte, (accessor, currentRow) -> CoreMatchers.equalTo((Object)((byte)accessor.getLong())));
    }

    @Test
    public void testShouldConvertToShortMethodFromBaseIntVector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcBaseIntVectorAccessor::getShort, (accessor, currentRow) -> CoreMatchers.equalTo((Object)((short)accessor.getLong())));
    }

    @Test
    public void testShouldConvertToIntegerMethodFromBaseIntVector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcBaseIntVectorAccessor::getInt, (accessor, currentRow) -> CoreMatchers.equalTo((Object)((int)accessor.getLong())));
    }

    @Test
    public void testShouldConvertToFloatMethodFromBaseIntVector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcBaseIntVectorAccessor::getFloat, (accessor, currentRow) -> CoreMatchers.equalTo((Object)Float.valueOf(accessor.getLong())));
    }

    @Test
    public void testShouldConvertToDoubleMethodFromBaseIntVector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcBaseIntVectorAccessor::getDouble, (accessor, currentRow) -> CoreMatchers.equalTo((Object)accessor.getLong()));
    }

    @Test
    public void testShouldConvertToBooleanMethodFromBaseIntVector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcBaseIntVectorAccessor::getBoolean, (accessor, currentRow) -> CoreMatchers.equalTo((Object)(accessor.getLong() != 0L ? 1 : 0)));
    }

    @Test
    public void testShouldGetObjectClass() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcBaseIntVectorAccessor::getObjectClass, CoreMatchers.equalTo(Long.class));
    }
}

