/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.complex;

import java.sql.SQLException;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.ArrowFlightJdbcStructVectorAccessor;
import org.apache.arrow.driver.jdbc.utils.AccessorTestUtils;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.holders.NullableBitHolder;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.JsonStringArrayList;
import org.apache.arrow.vector.util.JsonStringHashMap;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class ArrowFlightJdbcStructVectorAccessorTest {
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    private StructVector vector;
    private final AccessorTestUtils.AccessorSupplier<ArrowFlightJdbcStructVectorAccessor> accessorSupplier = (vector, getCurrentRow) -> new ArrowFlightJdbcStructVectorAccessor((StructVector)vector, getCurrentRow, wasNull -> {});
    private final AccessorTestUtils.AccessorIterator<ArrowFlightJdbcStructVectorAccessor> accessorIterator = new AccessorTestUtils.AccessorIterator<ArrowFlightJdbcStructVectorAccessor>(this.collector, this.accessorSupplier);

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("k1", "v1");
        FieldType type = new FieldType(true, (ArrowType)ArrowType.Struct.INSTANCE, null, metadata);
        this.vector = new StructVector("", rootAllocatorTestRule.getRootAllocator(), type, null);
        this.vector.allocateNew();
        IntVector intVector = (IntVector)this.vector.addOrGet("int", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), IntVector.class);
        Float8Vector float8Vector = (Float8Vector)this.vector.addOrGet("float8", FieldType.nullable((ArrowType)Types.MinorType.FLOAT8.getType()), Float8Vector.class);
        intVector.setSafe(0, 100);
        float8Vector.setSafe(0, 100.05);
        this.vector.setIndexDefined(0);
        intVector.setSafe(1, 200);
        float8Vector.setSafe(1, 200.1);
        this.vector.setIndexDefined(1);
        this.vector.setValueCount(2);
    }

    @After
    public void tearDown() throws Exception {
        this.vector.close();
    }

    @Test
    public void testShouldGetObjectClassReturnMapClass() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcStructVectorAccessor::getObjectClass, (accessor, currentRow) -> CoreMatchers.equalTo(Map.class));
    }

    @Test
    public void testShouldGetObjectReturnValidMap() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcStructVectorAccessor::getObject, (accessor, currentRow) -> {
            HashMap<String, Number> expected = new HashMap<String, Number>();
            expected.put("int", 100 * (currentRow + 1));
            expected.put("float8", 100.05 * (double)(currentRow + 1));
            return CoreMatchers.equalTo(expected);
        });
    }

    @Test
    public void testShouldGetObjectReturnNull() throws Exception {
        this.vector.setNull(0);
        this.vector.setNull(1);
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcStructVectorAccessor::getObject, (accessor, currentRow) -> CoreMatchers.nullValue());
    }

    @Test
    public void testShouldGetStructReturnValidStruct() throws Exception {
        this.accessorIterator.iterate((ValueVector)this.vector, (accessor, currentRow) -> {
            Struct struct = accessor.getStruct();
            assert (struct != null);
            Object[] expected = new Object[]{100 * (currentRow + 1), 100.05 * (double)(currentRow + 1)};
            this.collector.checkThat((Object)struct.getAttributes(), CoreMatchers.equalTo((Object)expected));
        });
    }

    @Test
    public void testShouldGetStructReturnNull() throws Exception {
        this.vector.setNull(0);
        this.vector.setNull(1);
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcStructVectorAccessor::getStruct, (accessor, currentRow) -> CoreMatchers.nullValue());
    }

    @Test
    public void testShouldGetObjectWorkWithNestedComplexData() throws SQLException {
        try (StructVector rootVector = StructVector.empty((String)"", (BufferAllocator)rootAllocatorTestRule.getRootAllocator());){
            StructVector structVector = rootVector.addOrGetStruct("struct");
            FieldType intFieldType = FieldType.nullable((ArrowType)Types.MinorType.INT.getType());
            IntVector intVector = (IntVector)structVector.addOrGet("int", intFieldType, IntVector.class);
            FieldType float8FieldType = FieldType.nullable((ArrowType)Types.MinorType.FLOAT8.getType());
            Float8Vector float8Vector = (Float8Vector)structVector.addOrGet("float8", float8FieldType, Float8Vector.class);
            ListVector listVector = rootVector.addOrGetList("list");
            UnionListWriter listWriter = listVector.getWriter();
            listWriter.allocate();
            UnionVector unionVector = rootVector.addOrGetUnion("union");
            intVector.setSafe(0, 100);
            intVector.setValueCount(1);
            float8Vector.setSafe(0, 100.05);
            float8Vector.setValueCount(1);
            structVector.setIndexDefined(0);
            listWriter.setPosition(0);
            listWriter.startList();
            listWriter.bigInt().writeBigInt(Long.MAX_VALUE);
            listWriter.bigInt().writeBigInt(Long.MIN_VALUE);
            listWriter.endList();
            listVector.setValueCount(1);
            unionVector.setType(0, Types.MinorType.BIT);
            NullableBitHolder holder = new NullableBitHolder();
            holder.isSet = 1;
            holder.value = 1;
            unionVector.setSafe(0, holder);
            unionVector.setValueCount(1);
            rootVector.setIndexDefined(0);
            rootVector.setValueCount(1);
            JsonStringHashMap expected = new JsonStringHashMap();
            JsonStringHashMap nestedStruct = new JsonStringHashMap();
            nestedStruct.put("int", 100);
            nestedStruct.put("float8", 100.05);
            expected.put("struct", nestedStruct);
            JsonStringArrayList nestedList = new JsonStringArrayList();
            nestedList.add((Object)Long.MAX_VALUE);
            nestedList.add((Object)Long.MIN_VALUE);
            expected.put("list", nestedList);
            expected.put("union", true);
            ArrowFlightJdbcStructVectorAccessor accessor = new ArrowFlightJdbcStructVectorAccessor(rootVector, () -> 0, wasNull -> {});
            Assert.assertEquals((Object)expected, (Object)accessor.getObject());
            Assert.assertEquals((Object)expected.toString(), (Object)accessor.getString());
        }
    }
}

