/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.complex;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.ArrowFlightJdbcMapVectorAccessor;
import org.apache.arrow.driver.jdbc.utils.AccessorTestUtils;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.impl.UnionMapWriter;
import org.apache.arrow.vector.util.JsonStringHashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class ArrowFlightJdbcMapVectorAccessorTest {
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    private MapVector vector;

    @Before
    public void setup() {
        this.vector = MapVector.empty((String)"", (BufferAllocator)rootAllocatorTestRule.getRootAllocator(), (boolean)false);
        UnionMapWriter writer = this.vector.getWriter();
        writer.allocate();
        writer.setPosition(0);
        writer.startMap();
        writer.startEntry();
        writer.key().integer().writeInt(1);
        writer.value().integer().writeInt(11);
        writer.endEntry();
        writer.startEntry();
        writer.key().integer().writeInt(2);
        writer.value().integer().writeInt(22);
        writer.endEntry();
        writer.startEntry();
        writer.key().integer().writeInt(3);
        writer.value().integer().writeInt(33);
        writer.endEntry();
        writer.endMap();
        writer.setPosition(1);
        writer.startMap();
        writer.startEntry();
        writer.key().integer().writeInt(2);
        writer.endEntry();
        writer.endMap();
        writer.setPosition(2);
        writer.startMap();
        writer.startEntry();
        writer.key().integer().writeInt(0);
        writer.value().integer().writeInt(2000);
        writer.endEntry();
        writer.startEntry();
        writer.key().integer().writeInt(1);
        writer.value().integer().writeInt(2001);
        writer.endEntry();
        writer.startEntry();
        writer.key().integer().writeInt(2);
        writer.value().integer().writeInt(2002);
        writer.endEntry();
        writer.startEntry();
        writer.key().integer().writeInt(3);
        writer.value().integer().writeInt(2003);
        writer.endEntry();
        writer.endMap();
        writer.setValueCount(3);
    }

    @After
    public void tearDown() {
        this.vector.close();
    }

    @Test
    public void testShouldGetObjectReturnValidMap() {
        AccessorTestUtils.Cursor cursor = new AccessorTestUtils.Cursor(this.vector.getValueCount());
        ArrowFlightJdbcMapVectorAccessor accessor = new ArrowFlightJdbcMapVectorAccessor(this.vector, cursor::getCurrentRow, wasNull -> {});
        JsonStringHashMap expected = new JsonStringHashMap();
        expected.put(1, 11);
        expected.put(2, 22);
        expected.put(3, 33);
        Assert.assertEquals((Object)expected, (Object)accessor.getObject());
        Assert.assertFalse((boolean)accessor.wasNull());
        cursor.next();
        expected = new JsonStringHashMap();
        expected.put(2, null);
        Assert.assertEquals((Object)expected, (Object)accessor.getObject());
        Assert.assertFalse((boolean)accessor.wasNull());
        cursor.next();
        expected = new JsonStringHashMap();
        expected.put(0, 2000);
        expected.put(1, 2001);
        expected.put(2, 2002);
        expected.put(3, 2003);
        Assert.assertEquals((Object)expected, (Object)accessor.getObject());
        Assert.assertFalse((boolean)accessor.wasNull());
    }

    @Test
    public void testShouldGetObjectReturnNull() {
        this.vector.setNull(0);
        ArrowFlightJdbcMapVectorAccessor accessor = new ArrowFlightJdbcMapVectorAccessor(this.vector, () -> 0, wasNull -> {});
        Assert.assertNull((Object)accessor.getObject());
        Assert.assertTrue((boolean)accessor.wasNull());
    }

    @Test
    public void testShouldGetArrayReturnValidArray() throws SQLException {
        Map entry;
        AccessorTestUtils.Cursor cursor = new AccessorTestUtils.Cursor(this.vector.getValueCount());
        ArrowFlightJdbcMapVectorAccessor accessor = new ArrowFlightJdbcMapVectorAccessor(this.vector, cursor::getCurrentRow, wasNull -> {});
        Array array = accessor.getArray();
        Assert.assertNotNull((Object)array);
        Assert.assertFalse((boolean)accessor.wasNull());
        try (ResultSet resultSet = array.getResultSet();){
            Assert.assertTrue((boolean)resultSet.next());
            entry = resultSet.getObject(1, Map.class);
            Assert.assertEquals((Object)1, entry.get("key"));
            Assert.assertEquals((Object)11, entry.get("value"));
            Assert.assertTrue((boolean)resultSet.next());
            entry = resultSet.getObject(1, Map.class);
            Assert.assertEquals((Object)2, entry.get("key"));
            Assert.assertEquals((Object)22, entry.get("value"));
            Assert.assertTrue((boolean)resultSet.next());
            entry = resultSet.getObject(1, Map.class);
            Assert.assertEquals((Object)3, entry.get("key"));
            Assert.assertEquals((Object)33, entry.get("value"));
            Assert.assertFalse((boolean)resultSet.next());
        }
        cursor.next();
        array = accessor.getArray();
        Assert.assertNotNull((Object)array);
        Assert.assertFalse((boolean)accessor.wasNull());
        resultSet = array.getResultSet();
        var5_5 = null;
        try {
            Assert.assertTrue((boolean)resultSet.next());
            entry = resultSet.getObject(1, Map.class);
            Assert.assertEquals((Object)2, entry.get("key"));
            Assert.assertNull(entry.get("value"));
            Assert.assertFalse((boolean)resultSet.next());
        }
        catch (Throwable entry2) {
            var5_5 = entry2;
            throw entry2;
        }
        finally {
            if (resultSet != null) {
                ArrowFlightJdbcMapVectorAccessorTest.$closeResource(var5_5, resultSet);
            }
        }
        cursor.next();
        array = accessor.getArray();
        Assert.assertNotNull((Object)array);
        Assert.assertFalse((boolean)accessor.wasNull());
        resultSet = array.getResultSet();
        var5_5 = null;
        try {
            Assert.assertTrue((boolean)resultSet.next());
            entry = resultSet.getObject(1, Map.class);
            Assert.assertEquals((Object)0, entry.get("key"));
            Assert.assertEquals((Object)2000, entry.get("value"));
            Assert.assertTrue((boolean)resultSet.next());
            entry = resultSet.getObject(1, Map.class);
            Assert.assertEquals((Object)1, entry.get("key"));
            Assert.assertEquals((Object)2001, entry.get("value"));
            Assert.assertTrue((boolean)resultSet.next());
            entry = resultSet.getObject(1, Map.class);
            Assert.assertEquals((Object)2, entry.get("key"));
            Assert.assertEquals((Object)2002, entry.get("value"));
            Assert.assertTrue((boolean)resultSet.next());
            entry = resultSet.getObject(1, Map.class);
            Assert.assertEquals((Object)3, entry.get("key"));
            Assert.assertEquals((Object)2003, entry.get("value"));
            Assert.assertFalse((boolean)resultSet.next());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (resultSet != null) {
                ArrowFlightJdbcMapVectorAccessorTest.$closeResource(var5_5, resultSet);
            }
        }
    }

    @Test
    public void testShouldGetArrayReturnNull() {
        this.vector.setNull(0);
        ((StructVector)this.vector.getDataVector()).setNull(0);
        ArrowFlightJdbcMapVectorAccessor accessor = new ArrowFlightJdbcMapVectorAccessor(this.vector, () -> 0, wasNull -> {});
        Assert.assertNull((Object)accessor.getArray());
        Assert.assertTrue((boolean)accessor.wasNull());
    }
}

