/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.complex;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.AbstractArrowFlightJdbcUnionVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.ArrowFlightJdbcDenseUnionVectorAccessor;
import org.apache.arrow.driver.jdbc.utils.AccessorTestUtils;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.holders.NullableBigIntHolder;
import org.apache.arrow.vector.holders.NullableFloat8Holder;
import org.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class ArrowFlightJdbcDenseUnionVectorAccessorTest {
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    private DenseUnionVector vector;
    private final AccessorTestUtils.AccessorSupplier<ArrowFlightJdbcDenseUnionVectorAccessor> accessorSupplier = (vector, getCurrentRow) -> new ArrowFlightJdbcDenseUnionVectorAccessor((DenseUnionVector)vector, getCurrentRow, wasNull -> {});
    private final AccessorTestUtils.AccessorIterator<ArrowFlightJdbcDenseUnionVectorAccessor> accessorIterator = new AccessorTestUtils.AccessorIterator<ArrowFlightJdbcDenseUnionVectorAccessor>(this.collector, this.accessorSupplier);

    @Before
    public void setup() throws Exception {
        this.vector = DenseUnionVector.empty((String)"", (BufferAllocator)rootAllocatorTestRule.getRootAllocator());
        this.vector.allocateNew();
        byte bigIntTypeId = this.vector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.BIGINT.getType()));
        byte float8TypeId = this.vector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.FLOAT8.getType()));
        byte timestampMilliTypeId = this.vector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.TIMESTAMPMILLI.getType()));
        NullableBigIntHolder nullableBigIntHolder = new NullableBigIntHolder();
        nullableBigIntHolder.isSet = 1;
        nullableBigIntHolder.value = Long.MAX_VALUE;
        this.vector.setTypeId(0, bigIntTypeId);
        this.vector.setSafe(0, nullableBigIntHolder);
        NullableFloat8Holder nullableFloat4Holder = new NullableFloat8Holder();
        nullableFloat4Holder.isSet = 1;
        nullableFloat4Holder.value = Math.PI;
        this.vector.setTypeId(1, float8TypeId);
        this.vector.setSafe(1, nullableFloat4Holder);
        NullableTimeStampMilliHolder nullableTimeStampMilliHolder = new NullableTimeStampMilliHolder();
        nullableTimeStampMilliHolder.isSet = 1;
        nullableTimeStampMilliHolder.value = 1625702400000L;
        this.vector.setTypeId(2, timestampMilliTypeId);
        this.vector.setSafe(2, nullableTimeStampMilliHolder);
        nullableBigIntHolder.isSet = 0;
        this.vector.setTypeId(3, bigIntTypeId);
        this.vector.setSafe(3, nullableBigIntHolder);
        this.vector.setValueCount(5);
    }

    @After
    public void tearDown() {
        this.vector.close();
    }

    @Test
    public void getObject() throws Exception {
        List<Object> result = this.accessorIterator.toList((ValueVector)this.vector);
        List<Object> expected = Arrays.asList(Long.MAX_VALUE, Math.PI, new Timestamp(1625702400000L), null, null);
        this.collector.checkThat(result, CoreMatchers.is(expected));
    }

    @Test
    public void getObjectForNull() throws Exception {
        this.vector.reset();
        this.vector.setValueCount(5);
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, AbstractArrowFlightJdbcUnionVectorAccessor::getObject, CoreMatchers.equalTo(null));
    }
}

