/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.complex;

import java.sql.Array;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.AbstractArrowFlightJdbcListVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.ArrowFlightJdbcFixedSizeListVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.ArrowFlightJdbcLargeListVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.ArrowFlightJdbcListVectorAccessor;
import org.apache.arrow.driver.jdbc.utils.AccessorTestUtils;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AbstractArrowFlightJdbcListAccessorTest {
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    private final Supplier<ValueVector> vectorSupplier;
    private ValueVector vector;
    private final AccessorTestUtils.AccessorSupplier<AbstractArrowFlightJdbcListVectorAccessor> accessorSupplier = (vector, getCurrentRow) -> {
        ArrowFlightJdbcAccessorFactory.WasNullConsumer noOpWasNullConsumer = wasNull -> {};
        if (vector instanceof ListVector) {
            return new ArrowFlightJdbcListVectorAccessor((ListVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof LargeListVector) {
            return new ArrowFlightJdbcLargeListVectorAccessor((LargeListVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof FixedSizeListVector) {
            return new ArrowFlightJdbcFixedSizeListVectorAccessor((FixedSizeListVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        return null;
    };
    final AccessorTestUtils.AccessorIterator<AbstractArrowFlightJdbcListVectorAccessor> accessorIterator = new AccessorTestUtils.AccessorIterator<AbstractArrowFlightJdbcListVectorAccessor>(this.collector, this.accessorSupplier);

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({() -> rootAllocatorTestRule.createListVector(), "ListVector"}, {() -> rootAllocatorTestRule.createLargeListVector(), "LargeListVector"}, {() -> rootAllocatorTestRule.createFixedSizeListVector(), "FixedSizeListVector"});
    }

    public AbstractArrowFlightJdbcListAccessorTest(Supplier<ValueVector> vectorSupplier, String vectorType) {
        this.vectorSupplier = vectorSupplier;
    }

    @Before
    public void setup() {
        this.vector = this.vectorSupplier.get();
    }

    @After
    public void tearDown() {
        this.vector.close();
    }

    @Test
    public void testShouldGetObjectClassReturnCorrectClass() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, AbstractArrowFlightJdbcListVectorAccessor::getObjectClass, (accessor, currentRow) -> CoreMatchers.equalTo(List.class));
    }

    @Test
    public void testShouldGetObjectReturnValidList() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcAccessor::getObject, (accessor, currentRow) -> CoreMatchers.equalTo(Arrays.asList(0, currentRow, currentRow * 2, currentRow * 3, currentRow * 4)));
    }

    @Test
    public void testShouldGetObjectReturnNull() throws Exception {
        this.vector.clear();
        this.vector.allocateNewSafe();
        this.vector.setValueCount(5);
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcAccessor::getObject, (accessor, currentRow) -> CoreMatchers.nullValue());
    }

    @Test
    public void testShouldGetArrayReturnValidArray() throws Exception {
        this.accessorIterator.iterate(this.vector, (accessor, currentRow) -> {
            Array array = accessor.getArray();
            assert (array != null);
            Object[] arrayObject = (Object[])array.getArray();
            this.collector.checkThat((Object)arrayObject, CoreMatchers.equalTo((Object)new Object[]{0, currentRow, currentRow * 2, currentRow * 3, currentRow * 4}));
        });
    }

    @Test
    public void testShouldGetArrayReturnNull() throws Exception {
        this.vector.clear();
        this.vector.allocateNewSafe();
        this.vector.setValueCount(5);
        this.accessorIterator.assertAccessorGetter(this.vector, AbstractArrowFlightJdbcListVectorAccessor::getArray, CoreMatchers.nullValue());
    }

    @Test
    public void testShouldGetArrayReturnValidArrayPassingOffsets() throws Exception {
        this.accessorIterator.iterate(this.vector, (accessor, currentRow) -> {
            Array array = accessor.getArray();
            assert (array != null);
            Object[] arrayObject = (Object[])array.getArray(1L, 3);
            this.collector.checkThat((Object)arrayObject, CoreMatchers.equalTo((Object)new Object[]{currentRow, currentRow * 2, currentRow * 3}));
        });
    }

    @Test
    public void testShouldGetArrayGetResultSetReturnValidResultSet() throws Exception {
        this.accessorIterator.iterate(this.vector, (accessor, currentRow) -> {
            Array array = accessor.getArray();
            assert (array != null);
            try (ResultSet rs = array.getResultSet();){
                int count = 0;
                while (rs.next()) {
                    int value = rs.getInt(1);
                    this.collector.checkThat((Object)value, CoreMatchers.equalTo((Object)(currentRow * count)));
                    ++count;
                }
                this.collector.checkThat((Object)count, CoreMatchers.equalTo((Object)5));
            }
        });
    }
}

