/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.calendar;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.arrow.driver.jdbc.accessor.impl.calendar.ArrowFlightJdbcTimeStampVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.text.ArrowFlightJdbcVarCharVectorAccessor;
import org.apache.arrow.driver.jdbc.utils.AccessorTestUtils;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.util.Text;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ArrowFlightJdbcTimeStampVectorAccessorTest {
    public static final String AMERICA_VANCOUVER = "America/Vancouver";
    public static final String ASIA_BANGKOK = "Asia/Bangkok";
    public static final String AMERICA_SAO_PAULO = "America/Sao_Paulo";
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    private final String timeZone;
    private TimeStampVector vector;
    private final Supplier<TimeStampVector> vectorSupplier;
    private final AccessorTestUtils.AccessorSupplier<ArrowFlightJdbcTimeStampVectorAccessor> accessorSupplier = (vector, getCurrentRow) -> new ArrowFlightJdbcTimeStampVectorAccessor((TimeStampVector)vector, getCurrentRow, wasNull -> {});
    private final AccessorTestUtils.AccessorIterator<ArrowFlightJdbcTimeStampVectorAccessor> accessorIterator = new AccessorTestUtils.AccessorIterator<ArrowFlightJdbcTimeStampVectorAccessor>(this.collector, this.accessorSupplier);

    @Parameterized.Parameters(name="{1} - TimeZone: {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({() -> rootAllocatorTestRule.createTimeStampNanoVector(), "TimeStampNanoVector", null}, {() -> rootAllocatorTestRule.createTimeStampNanoTZVector("UTC"), "TimeStampNanoTZVector", "UTC"}, {() -> rootAllocatorTestRule.createTimeStampNanoTZVector(AMERICA_VANCOUVER), "TimeStampNanoTZVector", AMERICA_VANCOUVER}, {() -> rootAllocatorTestRule.createTimeStampNanoTZVector(ASIA_BANGKOK), "TimeStampNanoTZVector", ASIA_BANGKOK}, {() -> rootAllocatorTestRule.createTimeStampMicroVector(), "TimeStampMicroVector", null}, {() -> rootAllocatorTestRule.createTimeStampMicroTZVector("UTC"), "TimeStampMicroTZVector", "UTC"}, {() -> rootAllocatorTestRule.createTimeStampMicroTZVector(AMERICA_VANCOUVER), "TimeStampMicroTZVector", AMERICA_VANCOUVER}, {() -> rootAllocatorTestRule.createTimeStampMicroTZVector(ASIA_BANGKOK), "TimeStampMicroTZVector", ASIA_BANGKOK}, {() -> rootAllocatorTestRule.createTimeStampMilliVector(), "TimeStampMilliVector", null}, {() -> rootAllocatorTestRule.createTimeStampMilliTZVector("UTC"), "TimeStampMilliTZVector", "UTC"}, {() -> rootAllocatorTestRule.createTimeStampMilliTZVector(AMERICA_VANCOUVER), "TimeStampMilliTZVector", AMERICA_VANCOUVER}, {() -> rootAllocatorTestRule.createTimeStampMilliTZVector(ASIA_BANGKOK), "TimeStampMilliTZVector", ASIA_BANGKOK}, {() -> rootAllocatorTestRule.createTimeStampSecVector(), "TimeStampSecVector", null}, {() -> rootAllocatorTestRule.createTimeStampSecTZVector("UTC"), "TimeStampSecTZVector", "UTC"}, {() -> rootAllocatorTestRule.createTimeStampSecTZVector(AMERICA_VANCOUVER), "TimeStampSecTZVector", AMERICA_VANCOUVER}, {() -> rootAllocatorTestRule.createTimeStampSecTZVector(ASIA_BANGKOK), "TimeStampSecTZVector", ASIA_BANGKOK});
    }

    public ArrowFlightJdbcTimeStampVectorAccessorTest(Supplier<TimeStampVector> vectorSupplier, String vectorType, String timeZone) {
        this.vectorSupplier = vectorSupplier;
        this.timeZone = timeZone;
    }

    @Before
    public void setup() {
        this.vector = this.vectorSupplier.get();
    }

    @After
    public void tearDown() {
        this.vector.close();
    }

    @Test
    public void testShouldGetTimestampReturnValidTimestampWithoutCalendar() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, accessor -> accessor.getTimestamp(null), (accessor, currentRow) -> CoreMatchers.is((Object)this.getTimestampForVector(currentRow)));
    }

    @Test
    public void testShouldGetTimestampReturnValidTimestampWithCalendar() throws Exception {
        TimeZone timeZone = TimeZone.getTimeZone(AMERICA_SAO_PAULO);
        Calendar calendar = Calendar.getInstance(timeZone);
        TimeZone timeZoneForVector = ArrowFlightJdbcTimeStampVectorAccessor.getTimeZoneForVector((TimeStampVector)this.vector);
        this.accessorIterator.iterate((ValueVector)this.vector, (accessor, currentRow) -> {
            Timestamp resultWithoutCalendar = accessor.getTimestamp(null);
            Timestamp result = accessor.getTimestamp(calendar);
            long offset = (long)timeZone.getOffset(resultWithoutCalendar.getTime()) - (long)timeZoneForVector.getOffset(resultWithoutCalendar.getTime());
            this.collector.checkThat((Object)(resultWithoutCalendar.getTime() - result.getTime()), CoreMatchers.is((Object)offset));
            this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)false));
        });
    }

    @Test
    public void testShouldGetTimestampReturnNull() {
        this.vector.setNull(0);
        ArrowFlightJdbcTimeStampVectorAccessor accessor = this.accessorSupplier.supply((ValueVector)this.vector, () -> 0);
        this.collector.checkThat((Object)accessor.getTimestamp(null), CoreMatchers.equalTo(null));
        this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)true));
    }

    @Test
    public void testShouldGetDateReturnValidDateWithoutCalendar() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, accessor -> accessor.getDate(null), (accessor, currentRow) -> CoreMatchers.is((Object)new Date(this.getTimestampForVector(currentRow).getTime())));
    }

    @Test
    public void testShouldGetDateReturnValidDateWithCalendar() throws Exception {
        TimeZone timeZone = TimeZone.getTimeZone(AMERICA_SAO_PAULO);
        Calendar calendar = Calendar.getInstance(timeZone);
        TimeZone timeZoneForVector = ArrowFlightJdbcTimeStampVectorAccessor.getTimeZoneForVector((TimeStampVector)this.vector);
        this.accessorIterator.iterate((ValueVector)this.vector, (accessor, currentRow) -> {
            Date resultWithoutCalendar = accessor.getDate(null);
            Date result = accessor.getDate(calendar);
            long offset = (long)timeZone.getOffset(resultWithoutCalendar.getTime()) - (long)timeZoneForVector.getOffset(resultWithoutCalendar.getTime());
            this.collector.checkThat((Object)(resultWithoutCalendar.getTime() - result.getTime()), CoreMatchers.is((Object)offset));
            this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)false));
        });
    }

    @Test
    public void testShouldGetDateReturnNull() {
        this.vector.setNull(0);
        ArrowFlightJdbcTimeStampVectorAccessor accessor = this.accessorSupplier.supply((ValueVector)this.vector, () -> 0);
        this.collector.checkThat((Object)accessor.getDate(null), CoreMatchers.equalTo(null));
        this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)true));
    }

    @Test
    public void testShouldGetTimeReturnValidTimeWithoutCalendar() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, accessor -> accessor.getTime(null), (accessor, currentRow) -> CoreMatchers.is((Object)new Time(this.getTimestampForVector(currentRow).getTime())));
    }

    @Test
    public void testShouldGetTimeReturnValidTimeWithCalendar() throws Exception {
        TimeZone timeZone = TimeZone.getTimeZone(AMERICA_SAO_PAULO);
        Calendar calendar = Calendar.getInstance(timeZone);
        TimeZone timeZoneForVector = ArrowFlightJdbcTimeStampVectorAccessor.getTimeZoneForVector((TimeStampVector)this.vector);
        this.accessorIterator.iterate((ValueVector)this.vector, (accessor, currentRow) -> {
            Time resultWithoutCalendar = accessor.getTime(null);
            Time result = accessor.getTime(calendar);
            long offset = (long)timeZone.getOffset(resultWithoutCalendar.getTime()) - (long)timeZoneForVector.getOffset(resultWithoutCalendar.getTime());
            this.collector.checkThat((Object)(resultWithoutCalendar.getTime() - result.getTime()), CoreMatchers.is((Object)offset));
            this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)false));
        });
    }

    @Test
    public void testShouldGetTimeReturnNull() {
        this.vector.setNull(0);
        ArrowFlightJdbcTimeStampVectorAccessor accessor = this.accessorSupplier.supply((ValueVector)this.vector, () -> 0);
        this.collector.checkThat((Object)accessor.getTime(null), CoreMatchers.equalTo(null));
        this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)true));
    }

    private Timestamp getTimestampForVector(int currentRow) {
        Object object = this.vector.getObject(currentRow);
        Timestamp expectedTimestamp = null;
        if (object instanceof LocalDateTime) {
            expectedTimestamp = Timestamp.valueOf((LocalDateTime)object);
        } else if (object instanceof Long) {
            TimeUnit timeUnit = ArrowFlightJdbcTimeStampVectorAccessor.getTimeUnitForVector((TimeStampVector)this.vector);
            long millis = timeUnit.toMillis((Long)object);
            long offset = TimeZone.getTimeZone(this.timeZone).getOffset(millis);
            expectedTimestamp = new Timestamp(millis + offset);
        }
        return expectedTimestamp;
    }

    @Test
    public void testShouldGetObjectClass() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcTimeStampVectorAccessor::getObjectClass, CoreMatchers.equalTo(Timestamp.class));
    }

    @Test
    public void testShouldGetStringBeConsistentWithVarCharAccessorWithoutCalendar() throws Exception {
        this.assertGetStringIsConsistentWithVarCharAccessor(null);
    }

    @Test
    public void testShouldGetStringBeConsistentWithVarCharAccessorWithCalendar() throws Exception {
        Assume.assumeTrue((this.vector instanceof TimeStampNanoVector || this.vector instanceof TimeStampMicroVector || this.vector instanceof TimeStampMilliVector || this.vector instanceof TimeStampSecVector ? 1 : 0) != 0);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(AMERICA_VANCOUVER));
        this.assertGetStringIsConsistentWithVarCharAccessor(calendar);
    }

    private void assertGetStringIsConsistentWithVarCharAccessor(Calendar calendar) throws Exception {
        try (VarCharVector varCharVector = new VarCharVector("", rootAllocatorTestRule.getRootAllocator());){
            varCharVector.allocateNew(1);
            ArrowFlightJdbcVarCharVectorAccessor varCharVectorAccessor = new ArrowFlightJdbcVarCharVectorAccessor(varCharVector, () -> 0, wasNull -> {});
            this.accessorIterator.iterate((ValueVector)this.vector, (accessor, currentRow) -> {
                String string = accessor.getString();
                varCharVector.set(0, new Text(string));
                varCharVector.setValueCount(1);
                Timestamp timestampFromVarChar = varCharVectorAccessor.getTimestamp(calendar);
                Timestamp timestamp = accessor.getTimestamp(calendar);
                this.collector.checkThat((Object)timestamp, CoreMatchers.is((Object)timestampFromVarChar));
                this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)false));
            });
        }
    }
}

