/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.calendar;

import java.time.Duration;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.accessor.impl.calendar.ArrowFlightJdbcIntervalVectorAccessor;
import org.apache.arrow.driver.jdbc.utils.AccessorTestUtils;
import org.apache.arrow.driver.jdbc.utils.IntervalStringUtils;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.vector.IntervalMonthDayNanoVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.PeriodDuration;
import org.apache.arrow.vector.ValueVector;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ArrowFlightJdbcIntervalVectorAccessorTest {
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    private final Supplier<ValueVector> vectorSupplier;
    private ValueVector vector;
    private final AccessorTestUtils.AccessorSupplier<ArrowFlightJdbcIntervalVectorAccessor> accessorSupplier = (vector, getCurrentRow) -> {
        ArrowFlightJdbcAccessorFactory.WasNullConsumer noOpWasNullConsumer = wasNull -> {};
        if (vector instanceof IntervalDayVector) {
            return new ArrowFlightJdbcIntervalVectorAccessor((IntervalDayVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof IntervalYearVector) {
            return new ArrowFlightJdbcIntervalVectorAccessor((IntervalYearVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof IntervalMonthDayNanoVector) {
            return new ArrowFlightJdbcIntervalVectorAccessor((IntervalMonthDayNanoVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        return null;
    };
    final AccessorTestUtils.AccessorIterator<ArrowFlightJdbcIntervalVectorAccessor> accessorIterator = new AccessorTestUtils.AccessorIterator<ArrowFlightJdbcIntervalVectorAccessor>(this.collector, this.accessorSupplier);

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({() -> {
            IntervalDayVector vector = new IntervalDayVector("", rootAllocatorTestRule.getRootAllocator());
            int valueCount = 10;
            vector.setValueCount(valueCount);
            for (int i = 0; i < valueCount; ++i) {
                vector.set(i, i + 1, (i + 1) * 1000);
            }
            return vector;
        }, "IntervalDayVector"}, {() -> {
            IntervalYearVector vector = new IntervalYearVector("", rootAllocatorTestRule.getRootAllocator());
            int valueCount = 10;
            vector.setValueCount(valueCount);
            for (int i = 0; i < valueCount; ++i) {
                vector.set(i, i + 1);
            }
            return vector;
        }, "IntervalYearVector"}, {() -> {
            IntervalMonthDayNanoVector vector = new IntervalMonthDayNanoVector("", rootAllocatorTestRule.getRootAllocator());
            int valueCount = 10;
            vector.setValueCount(valueCount);
            for (int i = 0; i < valueCount; ++i) {
                vector.set(i, i + 1, (i + 1) * 10, (long)((i + 1) * 100));
            }
            return vector;
        }, "IntervalMonthDayNanoVector"});
    }

    public ArrowFlightJdbcIntervalVectorAccessorTest(Supplier<ValueVector> vectorSupplier, String vectorType) {
        this.vectorSupplier = vectorSupplier;
    }

    @Before
    public void setup() {
        this.vector = this.vectorSupplier.get();
    }

    @After
    public void tearDown() {
        this.vector.close();
    }

    @Test
    public void testShouldGetObjectReturnValidObject() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcIntervalVectorAccessor::getObject, (accessor, currentRow) -> CoreMatchers.is((Object)this.getExpectedObject(this.vector, currentRow)));
    }

    @Test
    public void testShouldGetObjectPassingObjectClassAsParameterReturnValidObject() throws Exception {
        Class<?> objectClass = this.getExpectedObjectClassForVector(this.vector);
        this.accessorIterator.assertAccessorGetter(this.vector, accessor -> accessor.getObject(objectClass), (accessor, currentRow) -> CoreMatchers.is((Object)this.getExpectedObject(this.vector, currentRow)));
    }

    @Test
    public void testShouldGetObjectReturnNull() throws Exception {
        this.setAllNullOnVector(this.vector);
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcIntervalVectorAccessor::getObject, (accessor, currentRow) -> CoreMatchers.equalTo(null));
    }

    private String getStringOnVector(ValueVector vector, int index) {
        Object object = this.getExpectedObject(vector, index);
        if (object == null) {
            return null;
        }
        if (vector instanceof IntervalDayVector) {
            return IntervalStringUtils.formatIntervalDay((Duration)Duration.parse(object.toString()));
        }
        if (vector instanceof IntervalYearVector) {
            return IntervalStringUtils.formatIntervalYear((Period)Period.parse(object.toString()));
        }
        if (vector instanceof IntervalMonthDayNanoVector) {
            String iso8601IntervalString = ((PeriodDuration)object).toISO8601IntervalString();
            String[] periodAndDuration = iso8601IntervalString.split("T");
            if (periodAndDuration.length == 1) {
                String periodOrDuration = periodAndDuration[0];
                try {
                    return new PeriodDuration(Period.parse(periodOrDuration), Duration.ZERO).toISO8601IntervalString();
                }
                catch (DateTimeParseException e) {
                    return new PeriodDuration(Period.ZERO, Duration.parse(periodOrDuration)).toISO8601IntervalString();
                }
            }
            Period parse = Period.parse(periodAndDuration[0]);
            Duration duration = Duration.parse("PT" + periodAndDuration[1]);
            return new PeriodDuration(parse, duration).toISO8601IntervalString();
        }
        return null;
    }

    @Test
    public void testShouldGetIntervalYear() {
        Assert.assertEquals((Object)"-002-00", (Object)IntervalStringUtils.formatIntervalYear((Period)Period.parse("P-2Y")));
        Assert.assertEquals((Object)"-001-01", (Object)IntervalStringUtils.formatIntervalYear((Period)Period.parse("P-1Y-1M")));
        Assert.assertEquals((Object)"-001-02", (Object)IntervalStringUtils.formatIntervalYear((Period)Period.parse("P-1Y-2M")));
        Assert.assertEquals((Object)"-002-03", (Object)IntervalStringUtils.formatIntervalYear((Period)Period.parse("P-2Y-3M")));
        Assert.assertEquals((Object)"-002-04", (Object)IntervalStringUtils.formatIntervalYear((Period)Period.parse("P-2Y-4M")));
        Assert.assertEquals((Object)"-011-01", (Object)IntervalStringUtils.formatIntervalYear((Period)Period.parse("P-11Y-1M")));
        Assert.assertEquals((Object)"+002-00", (Object)IntervalStringUtils.formatIntervalYear((Period)Period.parse("P+2Y")));
        Assert.assertEquals((Object)"+001-01", (Object)IntervalStringUtils.formatIntervalYear((Period)Period.parse("P+1Y1M")));
        Assert.assertEquals((Object)"+001-02", (Object)IntervalStringUtils.formatIntervalYear((Period)Period.parse("P+1Y2M")));
        Assert.assertEquals((Object)"+002-03", (Object)IntervalStringUtils.formatIntervalYear((Period)Period.parse("P+2Y3M")));
        Assert.assertEquals((Object)"+002-04", (Object)IntervalStringUtils.formatIntervalYear((Period)Period.parse("P+2Y4M")));
        Assert.assertEquals((Object)"+011-01", (Object)IntervalStringUtils.formatIntervalYear((Period)Period.parse("P+11Y1M")));
    }

    @Test
    public void testShouldGetIntervalDay() {
        Assert.assertEquals((Object)"-001 00:00:00.000", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT-24H")));
        Assert.assertEquals((Object)"+001 00:00:00.000", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT+24H")));
        Assert.assertEquals((Object)"-000 01:00:00.000", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT-1H")));
        Assert.assertEquals((Object)"-000 01:00:00.001", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.ofHours(-1L).minusMillis(1L)));
        Assert.assertEquals((Object)"-000 01:01:01.000", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT-1H-1M-1S")));
        Assert.assertEquals((Object)"-000 02:02:02.002", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT-2H-2M-02.002S")));
        Assert.assertEquals((Object)"-000 23:59:59.999", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT-23H-59M-59.999S")));
        Assert.assertEquals((Object)"-000 11:59:00.100", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.ofHours(-11L).minusMinutes(59L).minusMillis(100L)));
        Assert.assertEquals((Object)"-000 05:02:03.000", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT-5H-2M-3S")));
        Assert.assertEquals((Object)"-000 22:22:22.222", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT-22H-22M-22.222S")));
        Assert.assertEquals((Object)"+000 01:00:00.000", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT+1H")));
        Assert.assertEquals((Object)"+000 01:00:00.001", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT+1H0M00.001S")));
        Assert.assertEquals((Object)"+000 01:01:01.000", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT+1H1M1S")));
        Assert.assertEquals((Object)"+000 02:02:02.002", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT+2H2M02.002S")));
        Assert.assertEquals((Object)"+000 23:59:59.999", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT+23H59M59.999S")));
        Assert.assertEquals((Object)"+000 11:59:00.100", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT+11H59M00.100S")));
        Assert.assertEquals((Object)"+000 05:02:03.000", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT+5H2M3S")));
        Assert.assertEquals((Object)"+000 22:22:22.222", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.parse("PT+22H22M22.222S")));
    }

    @Test
    public void testIntervalDayWithJodaPeriodObject() {
        Assert.assertEquals((Object)"+1567 00:00:00.000", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.ofDays(1567L)));
        Assert.assertEquals((Object)"-1567 00:00:00.000", (Object)IntervalStringUtils.formatIntervalDay((Duration)Duration.ofDays(-1567L)));
    }

    @Test
    public void testShouldGetStringReturnCorrectString() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcIntervalVectorAccessor::getString, (accessor, currentRow) -> CoreMatchers.is((Object)this.getStringOnVector(this.vector, currentRow)));
    }

    @Test
    public void testShouldGetStringReturnNull() throws Exception {
        this.setAllNullOnVector(this.vector);
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcIntervalVectorAccessor::getString, (accessor, currentRow) -> CoreMatchers.equalTo(null));
    }

    @Test
    public void testShouldGetObjectClassReturnCorrectClass() throws Exception {
        Class<?> expectedObjectClass = this.getExpectedObjectClassForVector(this.vector);
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcIntervalVectorAccessor::getObjectClass, (accessor, currentRow) -> CoreMatchers.equalTo((Object)expectedObjectClass));
    }

    private Class<?> getExpectedObjectClassForVector(ValueVector vector) {
        if (vector instanceof IntervalDayVector) {
            return Duration.class;
        }
        if (vector instanceof IntervalYearVector) {
            return Period.class;
        }
        if (vector instanceof IntervalMonthDayNanoVector) {
            return PeriodDuration.class;
        }
        return null;
    }

    private void setAllNullOnVector(ValueVector vector) {
        block4: {
            int valueCount;
            block5: {
                block3: {
                    valueCount = vector.getValueCount();
                    if (!(vector instanceof IntervalDayVector)) break block3;
                    for (int i = 0; i < valueCount; ++i) {
                        ((IntervalDayVector)vector).setNull(i);
                    }
                    break block4;
                }
                if (!(vector instanceof IntervalYearVector)) break block5;
                for (int i = 0; i < valueCount; ++i) {
                    ((IntervalYearVector)vector).setNull(i);
                }
                break block4;
            }
            if (!(vector instanceof IntervalMonthDayNanoVector)) break block4;
            for (int i = 0; i < valueCount; ++i) {
                ((IntervalMonthDayNanoVector)vector).setNull(i);
            }
        }
    }

    private Object getExpectedObject(ValueVector vector, int currentRow) {
        if (vector instanceof IntervalDayVector) {
            return Duration.ofDays(currentRow + 1).plusMillis((long)(currentRow + 1) * 1000L);
        }
        if (vector instanceof IntervalYearVector) {
            return Period.ofMonths(currentRow + 1);
        }
        if (vector instanceof IntervalMonthDayNanoVector) {
            Period period = Period.ofMonths(currentRow + 1).plusDays((long)(currentRow + 1) * 10L);
            Duration duration = Duration.ofNanos((long)(currentRow + 1) * 100L);
            return new PeriodDuration(period, duration);
        }
        return null;
    }
}

