/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.calendar;

import java.time.Duration;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.calendar.ArrowFlightJdbcDurationVectorAccessor;
import org.apache.arrow.driver.jdbc.utils.AccessorTestUtils;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class ArrowFlightJdbcDurationVectorAccessorTest {
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    private DurationVector vector;
    private final AccessorTestUtils.AccessorSupplier<ArrowFlightJdbcDurationVectorAccessor> accessorSupplier = (vector, getCurrentRow) -> new ArrowFlightJdbcDurationVectorAccessor((DurationVector)vector, getCurrentRow, wasNull -> {});
    private final AccessorTestUtils.AccessorIterator<ArrowFlightJdbcDurationVectorAccessor> accessorIterator = new AccessorTestUtils.AccessorIterator<ArrowFlightJdbcDurationVectorAccessor>(this.collector, this.accessorSupplier);

    @Before
    public void setup() {
        FieldType fieldType = new FieldType(true, (ArrowType)new ArrowType.Duration(TimeUnit.MILLISECOND), null);
        this.vector = new DurationVector("", fieldType, rootAllocatorTestRule.getRootAllocator());
        int valueCount = 10;
        this.vector.setValueCount(valueCount);
        for (int i = 0; i < valueCount; ++i) {
            this.vector.set(i, java.util.concurrent.TimeUnit.DAYS.toMillis(i + 1));
        }
    }

    @After
    public void tearDown() {
        this.vector.close();
    }

    @Test
    public void getObject() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcDurationVectorAccessor::getObject, (accessor, currentRow) -> CoreMatchers.is((Object)Duration.ofDays(currentRow + 1)));
    }

    @Test
    public void getObjectForNull() throws Exception {
        int valueCount = this.vector.getValueCount();
        for (int i = 0; i < valueCount; ++i) {
            this.vector.setNull(i);
        }
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcDurationVectorAccessor::getObject, (accessor, currentRow) -> CoreMatchers.equalTo(null));
    }

    @Test
    public void getString() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcAccessor::getString, (accessor, currentRow) -> CoreMatchers.is((Object)Duration.ofDays(currentRow + 1).toString()));
    }

    @Test
    public void getStringForNull() throws Exception {
        int valueCount = this.vector.getValueCount();
        for (int i = 0; i < valueCount; ++i) {
            this.vector.setNull(i);
        }
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcAccessor::getString, (accessor, currentRow) -> CoreMatchers.equalTo(null));
    }

    @Test
    public void testShouldGetObjectClass() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcAccessor::getObjectClass, (accessor, currentRow) -> CoreMatchers.equalTo(Duration.class));
    }
}

