/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.calendar;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.arrow.driver.jdbc.accessor.impl.calendar.ArrowFlightJdbcDateVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.text.ArrowFlightJdbcVarCharVectorAccessor;
import org.apache.arrow.driver.jdbc.utils.AccessorTestUtils;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.util.Text;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ArrowFlightJdbcDateVectorAccessorTest {
    public static final String AMERICA_VANCOUVER = "America/Vancouver";
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    private BaseFixedWidthVector vector;
    private final Supplier<BaseFixedWidthVector> vectorSupplier;
    private final AccessorTestUtils.AccessorSupplier<ArrowFlightJdbcDateVectorAccessor> accessorSupplier = (vector, getCurrentRow) -> {
        if (vector instanceof DateDayVector) {
            return new ArrowFlightJdbcDateVectorAccessor((DateDayVector)vector, getCurrentRow, wasNull -> {});
        }
        if (vector instanceof DateMilliVector) {
            return new ArrowFlightJdbcDateVectorAccessor((DateMilliVector)vector, getCurrentRow, wasNull -> {});
        }
        return null;
    };
    private final AccessorTestUtils.AccessorIterator<ArrowFlightJdbcDateVectorAccessor> accessorIterator = new AccessorTestUtils.AccessorIterator<ArrowFlightJdbcDateVectorAccessor>(this.collector, this.accessorSupplier);

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({() -> rootAllocatorTestRule.createDateDayVector(), "DateDayVector"}, {() -> rootAllocatorTestRule.createDateMilliVector(), "DateMilliVector"});
    }

    public ArrowFlightJdbcDateVectorAccessorTest(Supplier<BaseFixedWidthVector> vectorSupplier, String vectorType) {
        this.vectorSupplier = vectorSupplier;
    }

    @Before
    public void setup() {
        this.vector = this.vectorSupplier.get();
    }

    @After
    public void tearDown() {
        this.vector.close();
    }

    @Test
    public void testShouldGetTimestampReturnValidTimestampWithoutCalendar() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, accessor -> accessor.getTimestamp(null), (accessor, currentRow) -> CoreMatchers.is((Object)this.getTimestampForVector(currentRow)));
    }

    @Test
    public void testShouldGetObjectWithDateClassReturnValidDateWithoutCalendar() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, accessor -> (Date)accessor.getObject(Date.class), (accessor, currentRow) -> CoreMatchers.is((Object)new Date(this.getTimestampForVector(currentRow).getTime())));
    }

    @Test
    public void testShouldGetTimestampReturnValidTimestampWithCalendar() throws Exception {
        TimeZone timeZone = TimeZone.getTimeZone(AMERICA_VANCOUVER);
        Calendar calendar = Calendar.getInstance(timeZone);
        this.accessorIterator.iterate((ValueVector)this.vector, (accessor, currentRow) -> {
            Timestamp resultWithoutCalendar = accessor.getTimestamp(null);
            Timestamp result = accessor.getTimestamp(calendar);
            long offset = timeZone.getOffset(resultWithoutCalendar.getTime());
            this.collector.checkThat((Object)(resultWithoutCalendar.getTime() - result.getTime()), CoreMatchers.is((Object)offset));
            this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)false));
        });
    }

    @Test
    public void testShouldGetTimestampReturnNull() {
        this.vector.setNull(0);
        ArrowFlightJdbcDateVectorAccessor accessor = this.accessorSupplier.supply((ValueVector)this.vector, () -> 0);
        this.collector.checkThat((Object)accessor.getTimestamp(null), CoreMatchers.equalTo(null));
        this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)true));
    }

    @Test
    public void testShouldGetDateReturnValidDateWithoutCalendar() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, accessor -> accessor.getDate(null), (accessor, currentRow) -> CoreMatchers.is((Object)new Date(this.getTimestampForVector(currentRow).getTime())));
    }

    @Test
    public void testShouldGetDateReturnValidDateWithCalendar() throws Exception {
        TimeZone timeZone = TimeZone.getTimeZone(AMERICA_VANCOUVER);
        Calendar calendar = Calendar.getInstance(timeZone);
        this.accessorIterator.iterate((ValueVector)this.vector, (accessor, currentRow) -> {
            Date resultWithoutCalendar = accessor.getDate(null);
            Date result = accessor.getDate(calendar);
            long offset = timeZone.getOffset(resultWithoutCalendar.getTime());
            this.collector.checkThat((Object)(resultWithoutCalendar.getTime() - result.getTime()), CoreMatchers.is((Object)offset));
            this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)false));
        });
    }

    @Test
    public void testShouldGetDateReturnNull() {
        this.vector.setNull(0);
        ArrowFlightJdbcDateVectorAccessor accessor = this.accessorSupplier.supply((ValueVector)this.vector, () -> 0);
        this.collector.checkThat((Object)accessor.getDate(null), CoreMatchers.equalTo(null));
        this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)true));
    }

    private Timestamp getTimestampForVector(int currentRow) {
        Object object = this.vector.getObject(currentRow);
        Timestamp expectedTimestamp = null;
        if (object instanceof LocalDateTime) {
            expectedTimestamp = Timestamp.valueOf((LocalDateTime)object);
        } else if (object instanceof Number) {
            long value = ((Number)object).longValue();
            TimeUnit timeUnit = ArrowFlightJdbcDateVectorAccessor.getTimeUnitForVector((ValueVector)this.vector);
            long millis = timeUnit.toMillis(value);
            expectedTimestamp = new Timestamp(millis);
        }
        return expectedTimestamp;
    }

    @Test
    public void testShouldGetObjectClass() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcDateVectorAccessor::getObjectClass, CoreMatchers.equalTo(Date.class));
    }

    @Test
    public void testShouldGetStringBeConsistentWithVarCharAccessorWithoutCalendar() throws Exception {
        this.assertGetStringIsConsistentWithVarCharAccessor(null);
    }

    @Test
    public void testShouldGetStringBeConsistentWithVarCharAccessorWithCalendar() throws Exception {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(AMERICA_VANCOUVER));
        this.assertGetStringIsConsistentWithVarCharAccessor(calendar);
    }

    @Test
    public void testValidateGetStringTimeZoneConsistency() throws Exception {
        this.accessorIterator.iterate((ValueVector)this.vector, (accessor, currentRow) -> {
            TimeZone defaultTz = TimeZone.getDefault();
            try {
                String string = accessor.getString();
                Date date = accessor.getDate(null);
                TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
                this.collector.checkThat((Object)date.toString(), CoreMatchers.is((Object)string));
                TimeZone.setDefault(TimeZone.getTimeZone(AMERICA_VANCOUVER));
                this.collector.checkThat((Object)date.toString(), CoreMatchers.not((Object)string));
                this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)false));
            }
            finally {
                TimeZone.setDefault(defaultTz);
            }
        });
    }

    private void assertGetStringIsConsistentWithVarCharAccessor(Calendar calendar) throws Exception {
        try (VarCharVector varCharVector = new VarCharVector("", rootAllocatorTestRule.getRootAllocator());){
            varCharVector.allocateNew(1);
            ArrowFlightJdbcVarCharVectorAccessor varCharVectorAccessor = new ArrowFlightJdbcVarCharVectorAccessor(varCharVector, () -> 0, wasNull -> {});
            this.accessorIterator.iterate((ValueVector)this.vector, (accessor, currentRow) -> {
                String string = accessor.getString();
                varCharVector.set(0, new Text(string));
                varCharVector.setValueCount(1);
                Date dateFromVarChar = varCharVectorAccessor.getDate(calendar);
                Date date = accessor.getDate(calendar);
                this.collector.checkThat((Object)date, CoreMatchers.is((Object)dateFromVarChar));
                this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)false));
            });
        }
    }
}

