/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.binary;

import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.accessor.impl.binary.ArrowFlightJdbcBinaryVectorAccessor;
import org.apache.arrow.driver.jdbc.utils.AccessorTestUtils;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ArrowFlightJdbcBinaryVectorAccessorTest {
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    private ValueVector vector;
    private final Supplier<ValueVector> vectorSupplier;
    private final AccessorTestUtils.AccessorSupplier<ArrowFlightJdbcBinaryVectorAccessor> accessorSupplier = (vector, getCurrentRow) -> {
        ArrowFlightJdbcAccessorFactory.WasNullConsumer noOpWasNullConsumer = wasNull -> {};
        if (vector instanceof VarBinaryVector) {
            return new ArrowFlightJdbcBinaryVectorAccessor((VarBinaryVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof LargeVarBinaryVector) {
            return new ArrowFlightJdbcBinaryVectorAccessor((LargeVarBinaryVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof FixedSizeBinaryVector) {
            return new ArrowFlightJdbcBinaryVectorAccessor((FixedSizeBinaryVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        return null;
    };
    private final AccessorTestUtils.AccessorIterator<ArrowFlightJdbcBinaryVectorAccessor> accessorIterator = new AccessorTestUtils.AccessorIterator<ArrowFlightJdbcBinaryVectorAccessor>(this.collector, this.accessorSupplier);

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({() -> rootAllocatorTestRule.createVarBinaryVector(), "VarBinaryVector"}, {() -> rootAllocatorTestRule.createLargeVarBinaryVector(), "LargeVarBinaryVector"}, {() -> rootAllocatorTestRule.createFixedSizeBinaryVector(), "FixedSizeBinaryVector"});
    }

    public ArrowFlightJdbcBinaryVectorAccessorTest(Supplier<ValueVector> vectorSupplier, String vectorType) {
        this.vectorSupplier = vectorSupplier;
    }

    @Before
    public void setup() {
        this.vector = this.vectorSupplier.get();
    }

    @After
    public void tearDown() {
        this.vector.close();
    }

    @Test
    public void testShouldGetStringReturnExpectedString() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcBinaryVectorAccessor::getString, accessor -> CoreMatchers.is((Object)new String(accessor.getBytes(), StandardCharsets.UTF_8)));
    }

    @Test
    public void testShouldGetStringReturnNull() throws Exception {
        this.vector.reset();
        this.vector.setValueCount(5);
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcBinaryVectorAccessor::getString, CoreMatchers.nullValue());
    }

    @Test
    public void testShouldGetBytesReturnExpectedByteArray() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcBinaryVectorAccessor::getBytes, (accessor, currentRow) -> {
            if (this.vector instanceof VarBinaryVector) {
                return CoreMatchers.is((Object)((VarBinaryVector)this.vector).get(currentRow));
            }
            if (this.vector instanceof LargeVarBinaryVector) {
                return CoreMatchers.is((Object)((LargeVarBinaryVector)this.vector).get(currentRow));
            }
            if (this.vector instanceof FixedSizeBinaryVector) {
                return CoreMatchers.is((Object)((FixedSizeBinaryVector)this.vector).get(currentRow));
            }
            return null;
        });
    }

    @Test
    public void testShouldGetBytesReturnNull() throws Exception {
        this.vector.reset();
        this.vector.setValueCount(5);
        ArrowFlightJdbcBinaryVectorAccessor accessor = this.accessorSupplier.supply(this.vector, () -> 0);
        this.collector.checkThat((Object)accessor.getBytes(), CoreMatchers.equalTo(null));
        this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)true));
    }

    @Test
    public void testShouldGetObjectReturnAsGetBytes() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcBinaryVectorAccessor::getObject, accessor -> CoreMatchers.is((Object)accessor.getBytes()));
    }

    @Test
    public void testShouldGetObjectReturnNull() {
        this.vector.reset();
        this.vector.setValueCount(5);
        ArrowFlightJdbcBinaryVectorAccessor accessor = this.accessorSupplier.supply(this.vector, () -> 0);
        this.collector.checkThat(accessor.getObject(), CoreMatchers.equalTo(null));
        this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)true));
    }

    @Test
    public void testShouldGetUnicodeStreamReturnCorrectInputStream() throws Exception {
        this.accessorIterator.iterate(this.vector, (accessor, currentRow) -> {
            InputStream inputStream = accessor.getUnicodeStream();
            String actualString = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)false));
            this.collector.checkThat((Object)actualString, CoreMatchers.is((Object)accessor.getString()));
        });
    }

    @Test
    public void testShouldGetUnicodeStreamReturnNull() throws Exception {
        this.vector.reset();
        this.vector.setValueCount(5);
        ArrowFlightJdbcBinaryVectorAccessor accessor = this.accessorSupplier.supply(this.vector, () -> 0);
        this.collector.checkThat((Object)accessor.getUnicodeStream(), CoreMatchers.equalTo(null));
        this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)true));
    }

    @Test
    public void testShouldGetAsciiStreamReturnCorrectInputStream() throws Exception {
        this.accessorIterator.iterate(this.vector, (accessor, currentRow) -> {
            InputStream inputStream = accessor.getAsciiStream();
            String actualString = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.US_ASCII);
            this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)false));
            this.collector.checkThat((Object)actualString, CoreMatchers.is((Object)accessor.getString()));
        });
    }

    @Test
    public void testShouldGetAsciiStreamReturnNull() throws Exception {
        this.vector.reset();
        this.vector.setValueCount(5);
        ArrowFlightJdbcBinaryVectorAccessor accessor = this.accessorSupplier.supply(this.vector, () -> 0);
        this.collector.checkThat((Object)accessor.getAsciiStream(), CoreMatchers.equalTo(null));
        this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)true));
    }

    @Test
    public void testShouldGetBinaryStreamReturnCurrentInputStream() throws Exception {
        this.accessorIterator.iterate(this.vector, (accessor, currentRow) -> {
            InputStream inputStream = accessor.getBinaryStream();
            String actualString = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)false));
            this.collector.checkThat((Object)actualString, CoreMatchers.is((Object)accessor.getString()));
        });
    }

    @Test
    public void testShouldGetBinaryStreamReturnNull() throws Exception {
        this.vector.reset();
        this.vector.setValueCount(5);
        ArrowFlightJdbcBinaryVectorAccessor accessor = this.accessorSupplier.supply(this.vector, () -> 0);
        this.collector.checkThat((Object)accessor.getBinaryStream(), CoreMatchers.equalTo(null));
        this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)true));
    }

    @Test
    public void testShouldGetCharacterStreamReturnCorrectReader() throws Exception {
        this.accessorIterator.iterate(this.vector, (accessor, currentRow) -> {
            Reader characterStream = accessor.getCharacterStream();
            String actualString = IOUtils.toString((Reader)characterStream);
            this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)false));
            this.collector.checkThat((Object)actualString, CoreMatchers.is((Object)accessor.getString()));
        });
    }

    @Test
    public void testShouldGetCharacterStreamReturnNull() throws Exception {
        this.vector.reset();
        this.vector.setValueCount(5);
        ArrowFlightJdbcBinaryVectorAccessor accessor = this.accessorSupplier.supply(this.vector, () -> 0);
        this.collector.checkThat((Object)accessor.getCharacterStream(), CoreMatchers.equalTo(null));
        this.collector.checkThat((Object)accessor.wasNull(), CoreMatchers.is((Object)true));
    }
}

