/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ArrowFlightJdbcAccessorTest {
    @Mock
    MockedArrowFlightJdbcAccessor accessor;

    @Test
    public void testShouldGetObjectWithByteClassReturnGetByte() throws SQLException {
        byte expected = 127;
        Mockito.when((Object)this.accessor.getByte()).thenReturn((Object)expected);
        Mockito.when((Object)((Byte)this.accessor.getObject(Byte.class))).thenCallRealMethod();
        Assert.assertEquals((Object)this.accessor.getObject(Byte.class), (Object)expected);
        ((MockedArrowFlightJdbcAccessor)((Object)Mockito.verify((Object)((Object)this.accessor)))).getByte();
    }

    @Test
    public void testShouldGetObjectWithShortClassReturnGetShort() throws SQLException {
        short expected = Short.MAX_VALUE;
        Mockito.when((Object)this.accessor.getShort()).thenReturn((Object)expected);
        Mockito.when((Object)((Short)this.accessor.getObject(Short.class))).thenCallRealMethod();
        Assert.assertEquals((Object)this.accessor.getObject(Short.class), (Object)expected);
        ((MockedArrowFlightJdbcAccessor)((Object)Mockito.verify((Object)((Object)this.accessor)))).getShort();
    }

    @Test
    public void testShouldGetObjectWithIntegerClassReturnGetInt() throws SQLException {
        int expected = Integer.MAX_VALUE;
        Mockito.when((Object)this.accessor.getInt()).thenReturn((Object)expected);
        Mockito.when((Object)((Integer)this.accessor.getObject(Integer.class))).thenCallRealMethod();
        Assert.assertEquals((Object)this.accessor.getObject(Integer.class), (Object)expected);
        ((MockedArrowFlightJdbcAccessor)((Object)Mockito.verify((Object)((Object)this.accessor)))).getInt();
    }

    @Test
    public void testShouldGetObjectWithLongClassReturnGetLong() throws SQLException {
        long expected = Long.MAX_VALUE;
        Mockito.when((Object)this.accessor.getLong()).thenReturn((Object)expected);
        Mockito.when((Object)((Long)this.accessor.getObject(Long.class))).thenCallRealMethod();
        Assert.assertEquals((Object)this.accessor.getObject(Long.class), (Object)expected);
        ((MockedArrowFlightJdbcAccessor)((Object)Mockito.verify((Object)((Object)this.accessor)))).getLong();
    }

    @Test
    public void testShouldGetObjectWithFloatClassReturnGetFloat() throws SQLException {
        float expected = Float.MAX_VALUE;
        Mockito.when((Object)Float.valueOf(this.accessor.getFloat())).thenReturn((Object)Float.valueOf(expected));
        Mockito.when((Object)((Float)this.accessor.getObject(Float.class))).thenCallRealMethod();
        Assert.assertEquals((Object)this.accessor.getObject(Float.class), (Object)Float.valueOf(expected));
        ((MockedArrowFlightJdbcAccessor)((Object)Mockito.verify((Object)((Object)this.accessor)))).getFloat();
    }

    @Test
    public void testShouldGetObjectWithDoubleClassReturnGetDouble() throws SQLException {
        double expected = Double.MAX_VALUE;
        Mockito.when((Object)this.accessor.getDouble()).thenReturn((Object)expected);
        Mockito.when((Object)((Double)this.accessor.getObject(Double.class))).thenCallRealMethod();
        Assert.assertEquals((Object)this.accessor.getObject(Double.class), (Object)expected);
        ((MockedArrowFlightJdbcAccessor)((Object)Mockito.verify((Object)((Object)this.accessor)))).getDouble();
    }

    @Test
    public void testShouldGetObjectWithBooleanClassReturnGetBoolean() throws SQLException {
        Mockito.when((Object)this.accessor.getBoolean()).thenReturn((Object)true);
        Mockito.when((Object)((Boolean)this.accessor.getObject(Boolean.class))).thenCallRealMethod();
        Assert.assertEquals((Object)true, (Object)this.accessor.getObject(Boolean.class));
        ((MockedArrowFlightJdbcAccessor)((Object)Mockito.verify((Object)((Object)this.accessor)))).getBoolean();
    }

    @Test
    public void testShouldGetObjectWithBigDecimalClassReturnGetBigDecimal() throws SQLException {
        BigDecimal expected = BigDecimal.TEN;
        Mockito.when((Object)this.accessor.getBigDecimal()).thenReturn((Object)expected);
        Mockito.when((Object)((BigDecimal)this.accessor.getObject(BigDecimal.class))).thenCallRealMethod();
        Assert.assertEquals((Object)expected, (Object)this.accessor.getObject(BigDecimal.class));
        ((MockedArrowFlightJdbcAccessor)((Object)Mockito.verify((Object)((Object)this.accessor)))).getBigDecimal();
    }

    @Test
    public void testShouldGetObjectWithStringClassReturnGetString() throws SQLException {
        String expected = "STRING_VALUE";
        Mockito.when((Object)this.accessor.getString()).thenReturn((Object)expected);
        Mockito.when((Object)((String)this.accessor.getObject(String.class))).thenCallRealMethod();
        Assert.assertEquals((Object)expected, (Object)this.accessor.getObject(String.class));
        ((MockedArrowFlightJdbcAccessor)((Object)Mockito.verify((Object)((Object)this.accessor)))).getString();
    }

    @Test
    public void testShouldGetObjectWithByteArrayClassReturnGetBytes() throws SQLException {
        byte[] expected = "STRING_VALUE".getBytes(StandardCharsets.UTF_8);
        Mockito.when((Object)this.accessor.getBytes()).thenReturn((Object)expected);
        Mockito.when((Object)((byte[])this.accessor.getObject(byte[].class))).thenCallRealMethod();
        Assert.assertArrayEquals((byte[])((byte[])this.accessor.getObject(byte[].class)), (byte[])expected);
        ((MockedArrowFlightJdbcAccessor)((Object)Mockito.verify((Object)((Object)this.accessor)))).getBytes();
    }

    @Test
    public void testShouldGetObjectWithObjectClassReturnGetObject() throws SQLException {
        Object expected = new Object();
        Mockito.when((Object)this.accessor.getObject()).thenReturn(expected);
        Mockito.when((Object)this.accessor.getObject(Object.class)).thenCallRealMethod();
        Assert.assertEquals((Object)expected, (Object)this.accessor.getObject(Object.class));
        ((MockedArrowFlightJdbcAccessor)((Object)Mockito.verify((Object)((Object)this.accessor)))).getObject();
    }

    @Test
    public void testShouldGetObjectWithAccessorsObjectClassReturnGetObject() throws SQLException {
        Class<Long> objectClass = Long.class;
        Mockito.when((Object)((Long)this.accessor.getObject(objectClass))).thenCallRealMethod();
        this.accessor.getObject(objectClass);
        ((MockedArrowFlightJdbcAccessor)((Object)Mockito.verify((Object)((Object)this.accessor)))).getObject(objectClass);
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetBoolean() throws SQLException {
        Mockito.when((Object)this.accessor.getBoolean()).thenCallRealMethod();
        this.accessor.getBoolean();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetByte() throws SQLException {
        Mockito.when((Object)this.accessor.getByte()).thenCallRealMethod();
        this.accessor.getByte();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetShort() throws SQLException {
        Mockito.when((Object)this.accessor.getShort()).thenCallRealMethod();
        this.accessor.getShort();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetInt() throws SQLException {
        Mockito.when((Object)this.accessor.getInt()).thenCallRealMethod();
        this.accessor.getInt();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetLong() throws SQLException {
        Mockito.when((Object)this.accessor.getLong()).thenCallRealMethod();
        this.accessor.getLong();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetFloat() throws SQLException {
        Mockito.when((Object)Float.valueOf(this.accessor.getFloat())).thenCallRealMethod();
        this.accessor.getFloat();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetDouble() throws SQLException {
        Mockito.when((Object)this.accessor.getDouble()).thenCallRealMethod();
        this.accessor.getDouble();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetBigDecimal() throws SQLException {
        Mockito.when((Object)this.accessor.getBigDecimal()).thenCallRealMethod();
        this.accessor.getBigDecimal();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetBytes() throws SQLException {
        Mockito.when((Object)this.accessor.getBytes()).thenCallRealMethod();
        this.accessor.getBytes();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetAsciiStream() throws SQLException {
        Mockito.when((Object)this.accessor.getAsciiStream()).thenCallRealMethod();
        this.accessor.getAsciiStream();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetUnicodeStream() throws SQLException {
        Mockito.when((Object)this.accessor.getUnicodeStream()).thenCallRealMethod();
        this.accessor.getUnicodeStream();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetBinaryStream() throws SQLException {
        Mockito.when((Object)this.accessor.getBinaryStream()).thenCallRealMethod();
        this.accessor.getBinaryStream();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetObject() throws SQLException {
        Mockito.when((Object)this.accessor.getObject()).thenCallRealMethod();
        this.accessor.getObject();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetObjectMap() throws SQLException {
        HashMap map = new HashMap();
        Mockito.when((Object)this.accessor.getObject(map)).thenCallRealMethod();
        this.accessor.getObject(map);
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetCharacterStream() throws SQLException {
        Mockito.when((Object)this.accessor.getCharacterStream()).thenCallRealMethod();
        this.accessor.getCharacterStream();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetRef() throws SQLException {
        Mockito.when((Object)this.accessor.getRef()).thenCallRealMethod();
        this.accessor.getRef();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetBlob() throws SQLException {
        Mockito.when((Object)this.accessor.getBlob()).thenCallRealMethod();
        this.accessor.getBlob();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetClob() throws SQLException {
        Mockito.when((Object)this.accessor.getClob()).thenCallRealMethod();
        this.accessor.getClob();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetArray() throws SQLException {
        Mockito.when((Object)this.accessor.getArray()).thenCallRealMethod();
        this.accessor.getArray();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetStruct() throws SQLException {
        Mockito.when((Object)this.accessor.getStruct()).thenCallRealMethod();
        this.accessor.getStruct();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetURL() throws SQLException {
        Mockito.when((Object)this.accessor.getURL()).thenCallRealMethod();
        this.accessor.getURL();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetNClob() throws SQLException {
        Mockito.when((Object)this.accessor.getNClob()).thenCallRealMethod();
        this.accessor.getNClob();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetSQLXML() throws SQLException {
        Mockito.when((Object)this.accessor.getSQLXML()).thenCallRealMethod();
        this.accessor.getSQLXML();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetNString() throws SQLException {
        Mockito.when((Object)this.accessor.getNString()).thenCallRealMethod();
        this.accessor.getNString();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetNCharacterStream() throws SQLException {
        Mockito.when((Object)this.accessor.getNCharacterStream()).thenCallRealMethod();
        this.accessor.getNCharacterStream();
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetDate() throws SQLException {
        Mockito.when((Object)this.accessor.getDate(null)).thenCallRealMethod();
        this.accessor.getDate(null);
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetTime() throws SQLException {
        Mockito.when((Object)this.accessor.getTime(null)).thenCallRealMethod();
        this.accessor.getTime(null);
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetTimestamp() throws SQLException {
        Mockito.when((Object)this.accessor.getTimestamp(null)).thenCallRealMethod();
        this.accessor.getTimestamp(null);
    }

    @Test(expected=SQLException.class)
    public void testShouldFailToGetBigDecimalWithValue() throws SQLException {
        Mockito.when((Object)this.accessor.getBigDecimal(0)).thenCallRealMethod();
        this.accessor.getBigDecimal(0);
    }

    static class MockedArrowFlightJdbcAccessor
    extends ArrowFlightJdbcAccessor {
        protected MockedArrowFlightJdbcAccessor() {
            super(() -> 0, wasNull -> {});
        }

        public Class<?> getObjectClass() {
            return Long.class;
        }
    }
}

