/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor;

import java.util.function.IntSupplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.accessor.impl.binary.ArrowFlightJdbcBinaryVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.calendar.ArrowFlightJdbcDateVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.calendar.ArrowFlightJdbcDurationVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.calendar.ArrowFlightJdbcIntervalVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.calendar.ArrowFlightJdbcTimeStampVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.calendar.ArrowFlightJdbcTimeVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.ArrowFlightJdbcDenseUnionVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.ArrowFlightJdbcFixedSizeListVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.ArrowFlightJdbcLargeListVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.ArrowFlightJdbcListVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.ArrowFlightJdbcMapVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.ArrowFlightJdbcStructVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.ArrowFlightJdbcUnionVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.numeric.ArrowFlightJdbcBaseIntVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.numeric.ArrowFlightJdbcBitVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.numeric.ArrowFlightJdbcDecimalVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.numeric.ArrowFlightJdbcFloat4VectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.numeric.ArrowFlightJdbcFloat8VectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.text.ArrowFlightJdbcVarCharVectorAccessor;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.vector.IntervalMonthDayNanoVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class ArrowFlightJdbcAccessorFactoryTest {
    public static final IntSupplier GET_CURRENT_ROW = () -> 0;
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();

    @Test
    public void createAccessorForUInt1Vector() {
        try (UInt1Vector valueVector = rootAllocatorTestRule.createUInt1Vector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcBaseIntVectorAccessor));
        }
    }

    @Test
    public void createAccessorForUInt2Vector() {
        try (UInt2Vector valueVector = rootAllocatorTestRule.createUInt2Vector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcBaseIntVectorAccessor));
        }
    }

    @Test
    public void createAccessorForUInt4Vector() {
        try (UInt4Vector valueVector = rootAllocatorTestRule.createUInt4Vector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcBaseIntVectorAccessor));
        }
    }

    @Test
    public void createAccessorForUInt8Vector() {
        try (UInt8Vector valueVector = rootAllocatorTestRule.createUInt8Vector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcBaseIntVectorAccessor));
        }
    }

    @Test
    public void createAccessorForTinyIntVector() {
        try (TinyIntVector valueVector = rootAllocatorTestRule.createTinyIntVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcBaseIntVectorAccessor));
        }
    }

    @Test
    public void createAccessorForSmallIntVector() {
        try (SmallIntVector valueVector = rootAllocatorTestRule.createSmallIntVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcBaseIntVectorAccessor));
        }
    }

    @Test
    public void createAccessorForIntVector() {
        try (IntVector valueVector = rootAllocatorTestRule.createIntVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcBaseIntVectorAccessor));
        }
    }

    @Test
    public void createAccessorForBigIntVector() {
        try (BigIntVector valueVector = rootAllocatorTestRule.createBigIntVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcBaseIntVectorAccessor));
        }
    }

    @Test
    public void createAccessorForFloat4Vector() {
        try (Float4Vector valueVector = rootAllocatorTestRule.createFloat4Vector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcFloat4VectorAccessor));
        }
    }

    @Test
    public void createAccessorForFloat8Vector() {
        try (Float8Vector valueVector = rootAllocatorTestRule.createFloat8Vector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcFloat8VectorAccessor));
        }
    }

    @Test
    public void createAccessorForBitVector() {
        try (BitVector valueVector = rootAllocatorTestRule.createBitVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcBitVectorAccessor));
        }
    }

    @Test
    public void createAccessorForDecimalVector() {
        try (DecimalVector valueVector = rootAllocatorTestRule.createDecimalVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcDecimalVectorAccessor));
        }
    }

    @Test
    public void createAccessorForDecimal256Vector() {
        try (Decimal256Vector valueVector = rootAllocatorTestRule.createDecimal256Vector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcDecimalVectorAccessor));
        }
    }

    @Test
    public void createAccessorForVarBinaryVector() {
        try (VarBinaryVector valueVector = rootAllocatorTestRule.createVarBinaryVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcBinaryVectorAccessor));
        }
    }

    @Test
    public void createAccessorForLargeVarBinaryVector() {
        try (LargeVarBinaryVector valueVector = rootAllocatorTestRule.createLargeVarBinaryVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcBinaryVectorAccessor));
        }
    }

    @Test
    public void createAccessorForFixedSizeBinaryVector() {
        try (FixedSizeBinaryVector valueVector = rootAllocatorTestRule.createFixedSizeBinaryVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcBinaryVectorAccessor));
        }
    }

    @Test
    public void createAccessorForTimeStampVector() {
        try (TimeStampMilliVector valueVector = rootAllocatorTestRule.createTimeStampMilliVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcTimeStampVectorAccessor));
        }
    }

    @Test
    public void createAccessorForTimeNanoVector() {
        try (TimeNanoVector valueVector = rootAllocatorTestRule.createTimeNanoVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcTimeVectorAccessor));
        }
    }

    @Test
    public void createAccessorForTimeMicroVector() {
        try (TimeMicroVector valueVector = rootAllocatorTestRule.createTimeMicroVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcTimeVectorAccessor));
        }
    }

    @Test
    public void createAccessorForTimeMilliVector() {
        try (TimeMilliVector valueVector = rootAllocatorTestRule.createTimeMilliVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcTimeVectorAccessor));
        }
    }

    @Test
    public void createAccessorForTimeSecVector() {
        try (TimeSecVector valueVector = rootAllocatorTestRule.createTimeSecVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcTimeVectorAccessor));
        }
    }

    @Test
    public void createAccessorForDateDayVector() {
        try (DateDayVector valueVector = rootAllocatorTestRule.createDateDayVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcDateVectorAccessor));
        }
    }

    @Test
    public void createAccessorForDateMilliVector() {
        try (DateMilliVector valueVector = rootAllocatorTestRule.createDateMilliVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcDateVectorAccessor));
        }
    }

    @Test
    public void createAccessorForVarCharVector() {
        try (VarCharVector valueVector = new VarCharVector("", rootAllocatorTestRule.getRootAllocator());){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcVarCharVectorAccessor));
        }
    }

    @Test
    public void createAccessorForLargeVarCharVector() {
        try (LargeVarCharVector valueVector = new LargeVarCharVector("", rootAllocatorTestRule.getRootAllocator());){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcVarCharVectorAccessor));
        }
    }

    @Test
    public void createAccessorForDurationVector() {
        try (DurationVector valueVector = new DurationVector("", new FieldType(true, (ArrowType)new ArrowType.Duration(TimeUnit.MILLISECOND), null), rootAllocatorTestRule.getRootAllocator());){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcDurationVectorAccessor));
        }
    }

    @Test
    public void createAccessorForIntervalDayVector() {
        try (IntervalDayVector valueVector = new IntervalDayVector("", rootAllocatorTestRule.getRootAllocator());){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcIntervalVectorAccessor));
        }
    }

    @Test
    public void createAccessorForIntervalYearVector() {
        try (IntervalYearVector valueVector = new IntervalYearVector("", rootAllocatorTestRule.getRootAllocator());){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcIntervalVectorAccessor));
        }
    }

    @Test
    public void createAccessorForIntervalMonthDayNanoVector() {
        try (IntervalMonthDayNanoVector valueVector = new IntervalMonthDayNanoVector("", rootAllocatorTestRule.getRootAllocator());){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcIntervalVectorAccessor));
        }
    }

    @Test
    public void createAccessorForUnionVector() {
        try (UnionVector valueVector = new UnionVector("", rootAllocatorTestRule.getRootAllocator(), null, null);){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcUnionVectorAccessor));
        }
    }

    @Test
    public void createAccessorForDenseUnionVector() {
        try (DenseUnionVector valueVector = new DenseUnionVector("", rootAllocatorTestRule.getRootAllocator(), null, null);){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcDenseUnionVectorAccessor));
        }
    }

    @Test
    public void createAccessorForStructVector() {
        try (StructVector valueVector = StructVector.empty((String)"", (BufferAllocator)rootAllocatorTestRule.getRootAllocator());){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcStructVectorAccessor));
        }
    }

    @Test
    public void createAccessorForListVector() {
        try (ListVector valueVector = rootAllocatorTestRule.createListVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcListVectorAccessor));
        }
    }

    @Test
    public void createAccessorForLargeListVector() {
        try (LargeListVector valueVector = rootAllocatorTestRule.createLargeListVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcLargeListVectorAccessor));
        }
    }

    @Test
    public void createAccessorForFixedSizeListVector() {
        try (FixedSizeListVector valueVector = rootAllocatorTestRule.createFixedSizeListVector();){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcFixedSizeListVectorAccessor));
        }
    }

    @Test
    public void createAccessorForMapVector() {
        try (MapVector valueVector = MapVector.empty((String)"", (BufferAllocator)rootAllocatorTestRule.getRootAllocator(), (boolean)true);){
            ArrowFlightJdbcAccessor accessor = ArrowFlightJdbcAccessorFactory.createAccessor((ValueVector)valueVector, (IntSupplier)GET_CURRENT_ROW, wasNull -> {});
            Assert.assertTrue((boolean)(accessor instanceof ArrowFlightJdbcMapVectorAccessor));
        }
    }
}

