/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.arrow.driver.jdbc.FlightServerTestRule;
import org.apache.arrow.driver.jdbc.authentication.TokenAuthentication;
import org.apache.arrow.driver.jdbc.utils.MockFlightSqlProducer;
import org.apache.arrow.util.AutoCloseables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class TokenAuthenticationTest {
    private static final MockFlightSqlProducer FLIGHT_SQL_PRODUCER = new MockFlightSqlProducer();
    @ClassRule
    public static FlightServerTestRule FLIGHT_SERVER_TEST_RULE = new FlightServerTestRule.Builder().authentication(new TokenAuthentication.Builder().token("1234").build()).producer(FLIGHT_SQL_PRODUCER).build();

    @AfterClass
    public static void tearDownAfterClass() {
        AutoCloseables.closeNoChecked((AutoCloseable)((Object)FLIGHT_SQL_PRODUCER));
    }

    @Test(expected=SQLException.class)
    public void connectUsingTokenAuthenticationShouldFail() throws SQLException {
        try (Connection ignored = FLIGHT_SERVER_TEST_RULE.getConnection(false, "invalid");){
            Assert.fail();
        }
    }

    @Test
    public void connectUsingTokenAuthenticationShouldSuccess() throws SQLException {
        try (Connection connection = FLIGHT_SERVER_TEST_RULE.getConnection(false, "1234");){
            Assert.assertFalse((boolean)connection.isClosed());
        }
    }
}

