/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.arrow.driver.jdbc.FlightServerTestRule;
import org.apache.arrow.driver.jdbc.utils.CoreMockedSqlProducers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class ResultSetMetadataTest {
    private static ResultSetMetaData metadata;
    private static Connection connection;
    @Rule
    public ErrorCollector collector = new ErrorCollector();
    @ClassRule
    public static final FlightServerTestRule SERVER_TEST_RULE;

    @BeforeClass
    public static void setup() throws SQLException {
        connection = SERVER_TEST_RULE.getConnection(false);
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT * FROM METADATA");){
            metadata = resultSet.getMetaData();
        }
    }

    @AfterClass
    public static void teardown() throws SQLException {
        connection.close();
    }

    @Test
    public void testShouldGetResultSetMetadata() {
        this.collector.checkThat((Object)metadata, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testShouldGetColumnCount() throws SQLException {
        int columnCount = metadata.getColumnCount();
        assert (columnCount == 3);
    }

    @Test
    public void testShouldGetColumnTypesName() throws SQLException {
        String firstColumn = metadata.getColumnTypeName(1);
        String secondColumn = metadata.getColumnTypeName(2);
        String thirdColumn = metadata.getColumnTypeName(3);
        this.collector.checkThat((Object)firstColumn, CoreMatchers.equalTo((Object)"BIGINT"));
        this.collector.checkThat((Object)secondColumn, CoreMatchers.equalTo((Object)"VARCHAR"));
        this.collector.checkThat((Object)thirdColumn, CoreMatchers.equalTo((Object)"FLOAT"));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testShouldGetColumnTypesNameFromOutOfBoundIndex() throws SQLException {
        metadata.getColumnTypeName(4);
        Assert.fail();
    }

    @Test
    public void testShouldGetColumnNames() throws SQLException {
        String firstColumn = metadata.getColumnName(1);
        String secondColumn = metadata.getColumnName(2);
        String thirdColumn = metadata.getColumnName(3);
        this.collector.checkThat((Object)firstColumn, CoreMatchers.equalTo((Object)"integer0"));
        this.collector.checkThat((Object)secondColumn, CoreMatchers.equalTo((Object)"string1"));
        this.collector.checkThat((Object)thirdColumn, CoreMatchers.equalTo((Object)"float2"));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testShouldGetColumnNameFromOutOfBoundIndex() throws SQLException {
        metadata.getColumnName(4);
        Assert.fail();
    }

    @Test
    public void testShouldGetColumnType() throws SQLException {
        int firstColumn = metadata.getColumnType(1);
        int secondColumn = metadata.getColumnType(2);
        int thirdColumn = metadata.getColumnType(3);
        this.collector.checkThat((Object)firstColumn, CoreMatchers.equalTo((Object)-5));
        this.collector.checkThat((Object)secondColumn, CoreMatchers.equalTo((Object)12));
        this.collector.checkThat((Object)thirdColumn, CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void testShouldGetPrecision() throws SQLException {
        this.collector.checkThat((Object)metadata.getPrecision(1), CoreMatchers.equalTo((Object)10));
        this.collector.checkThat((Object)metadata.getPrecision(2), CoreMatchers.equalTo((Object)65535));
        this.collector.checkThat((Object)metadata.getPrecision(3), CoreMatchers.equalTo((Object)15));
    }

    @Test
    public void testShouldGetScale() throws SQLException {
        this.collector.checkThat((Object)metadata.getScale(1), CoreMatchers.equalTo((Object)0));
        this.collector.checkThat((Object)metadata.getScale(2), CoreMatchers.equalTo((Object)0));
        this.collector.checkThat((Object)metadata.getScale(3), CoreMatchers.equalTo((Object)20));
    }

    @Test
    public void testShouldGetCatalogName() throws SQLException {
        this.collector.checkThat((Object)metadata.getCatalogName(1), CoreMatchers.equalTo((Object)"CATALOG_NAME_1"));
        this.collector.checkThat((Object)metadata.getCatalogName(2), CoreMatchers.equalTo((Object)"CATALOG_NAME_2"));
        this.collector.checkThat((Object)metadata.getCatalogName(3), CoreMatchers.equalTo((Object)"CATALOG_NAME_3"));
    }

    @Test
    public void testShouldGetSchemaName() throws SQLException {
        this.collector.checkThat((Object)metadata.getSchemaName(1), CoreMatchers.equalTo((Object)"SCHEMA_NAME_1"));
        this.collector.checkThat((Object)metadata.getSchemaName(2), CoreMatchers.equalTo((Object)"SCHEMA_NAME_2"));
        this.collector.checkThat((Object)metadata.getSchemaName(3), CoreMatchers.equalTo((Object)"SCHEMA_NAME_3"));
    }

    @Test
    public void testShouldGetTableName() throws SQLException {
        this.collector.checkThat((Object)metadata.getTableName(1), CoreMatchers.equalTo((Object)"TABLE_NAME_1"));
        this.collector.checkThat((Object)metadata.getTableName(2), CoreMatchers.equalTo((Object)"TABLE_NAME_2"));
        this.collector.checkThat((Object)metadata.getTableName(3), CoreMatchers.equalTo((Object)"TABLE_NAME_3"));
    }

    @Test
    public void testShouldIsAutoIncrement() throws SQLException {
        this.collector.checkThat((Object)metadata.isAutoIncrement(1), CoreMatchers.equalTo((Object)true));
        this.collector.checkThat((Object)metadata.isAutoIncrement(2), CoreMatchers.equalTo((Object)false));
        this.collector.checkThat((Object)metadata.isAutoIncrement(3), CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testShouldIsCaseSensitive() throws SQLException {
        this.collector.checkThat((Object)metadata.isCaseSensitive(1), CoreMatchers.equalTo((Object)false));
        this.collector.checkThat((Object)metadata.isCaseSensitive(2), CoreMatchers.equalTo((Object)true));
        this.collector.checkThat((Object)metadata.isCaseSensitive(3), CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testShouldIsReadonly() throws SQLException {
        this.collector.checkThat((Object)metadata.isReadOnly(1), CoreMatchers.equalTo((Object)true));
        this.collector.checkThat((Object)metadata.isReadOnly(2), CoreMatchers.equalTo((Object)false));
        this.collector.checkThat((Object)metadata.isReadOnly(3), CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testShouldIsSearchable() throws SQLException {
        this.collector.checkThat((Object)metadata.isSearchable(1), CoreMatchers.equalTo((Object)true));
        this.collector.checkThat((Object)metadata.isSearchable(2), CoreMatchers.equalTo((Object)true));
        this.collector.checkThat((Object)metadata.isSearchable(3), CoreMatchers.equalTo((Object)true));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testShouldGetColumnTypesFromOutOfBoundIndex() throws SQLException {
        metadata.getColumnType(4);
        Assert.fail();
    }

    static {
        SERVER_TEST_RULE = FlightServerTestRule.createStandardTestRule(CoreMockedSqlProducers.getLegacyProducer());
    }
}

