/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.arrow.driver.jdbc.ArrowFlightConnection;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcDataSource;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcDriver;
import org.apache.arrow.driver.jdbc.FlightServerTestRule;
import org.apache.arrow.driver.jdbc.authentication.UserPasswordAuthentication;
import org.apache.arrow.driver.jdbc.client.ArrowFlightSqlClientHandler;
import org.apache.arrow.driver.jdbc.utils.ArrowFlightConnectionConfigImpl;
import org.apache.arrow.driver.jdbc.utils.FlightSqlTestCertificates;
import org.apache.arrow.driver.jdbc.utils.MockFlightSqlProducer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.util.Preconditions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class ConnectionTlsTest {
    @ClassRule
    public static final FlightServerTestRule FLIGHT_SERVER_TEST_RULE;
    private static final MockFlightSqlProducer PRODUCER;
    private static final String userTest = "user1";
    private static final String passTest = "pass1";
    private String trustStorePath;
    private String noCertificateKeyStorePath;
    private final String trustStorePass = "flight";
    private BufferAllocator allocator;

    @Before
    public void setUp() throws Exception {
        this.trustStorePath = Paths.get(((URL)Preconditions.checkNotNull((Object)this.getClass().getResource("/keys/keyStore.jks"))).toURI()).toString();
        this.noCertificateKeyStorePath = Paths.get(((URL)Preconditions.checkNotNull((Object)this.getClass().getResource("/keys/noCertificate.jks"))).toURI()).toString();
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void tearDown() throws Exception {
        this.allocator.getChildAllocators().forEach(BufferAllocator::close);
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.allocator});
    }

    @Test
    public void testGetEncryptedClientAuthenticatedWithDisableCertVerification() throws Exception {
        try (ArrowFlightSqlClientHandler client = new ArrowFlightSqlClientHandler.Builder().withHost(FLIGHT_SERVER_TEST_RULE.getHost()).withPort(FLIGHT_SERVER_TEST_RULE.getPort()).withUsername(userTest).withPassword(passTest).withDisableCertificateVerification(true).withBufferAllocator(this.allocator).withEncryption(true).build();){
            Assert.assertNotNull((Object)client);
        }
    }

    @Test
    public void testGetEncryptedClientAuthenticated() throws Exception {
        try (ArrowFlightSqlClientHandler client = new ArrowFlightSqlClientHandler.Builder().withHost(FLIGHT_SERVER_TEST_RULE.getHost()).withPort(FLIGHT_SERVER_TEST_RULE.getPort()).withSystemTrustStore(false).withUsername(userTest).withPassword(passTest).withTrustStorePath(this.trustStorePath).withTrustStorePassword("flight").withBufferAllocator(this.allocator).withEncryption(true).build();){
            Assert.assertNotNull((Object)client);
        }
    }

    @Test(expected=SQLException.class)
    public void testGetEncryptedClientWithNoCertificateOnKeyStore() throws Exception {
        String noCertificateKeyStorePassword = "flight1";
        try (ArrowFlightSqlClientHandler ignored = new ArrowFlightSqlClientHandler.Builder().withHost(FLIGHT_SERVER_TEST_RULE.getHost()).withTrustStorePath(this.noCertificateKeyStorePath).withTrustStorePassword("flight1").withSystemTrustStore(false).withBufferAllocator(this.allocator).withEncryption(true).build();){
            Assert.fail();
        }
    }

    @Test
    public void testGetNonAuthenticatedEncryptedClientNoAuth() throws Exception {
        try (ArrowFlightSqlClientHandler client = new ArrowFlightSqlClientHandler.Builder().withHost(FLIGHT_SERVER_TEST_RULE.getHost()).withSystemTrustStore(false).withTrustStorePath(this.trustStorePath).withTrustStorePassword("flight").withBufferAllocator(this.allocator).withEncryption(true).build();){
            Assert.assertNotNull((Object)client);
        }
    }

    @Test(expected=SQLException.class)
    public void testGetEncryptedClientWithKeyStoreBadPasswordAndNoAuth() throws Exception {
        String keyStoreBadPassword = "badPassword";
        try (ArrowFlightSqlClientHandler ignored = new ArrowFlightSqlClientHandler.Builder().withHost(FLIGHT_SERVER_TEST_RULE.getHost()).withSystemTrustStore(false).withTrustStorePath(this.trustStorePath).withTrustStorePassword(keyStoreBadPassword).withBufferAllocator(this.allocator).withEncryption(true).build();){
            Assert.fail();
        }
    }

    @Test
    public void testGetEncryptedConnectionWithValidCredentialsAndKeyStore() throws Exception {
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName(), "localhost");
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName(), (Object)FLIGHT_SERVER_TEST_RULE.getPort());
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE.camelName(), this.trustStorePath);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_SYSTEM_TRUST_STORE.camelName(), (Object)false);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE_PASSWORD.camelName(), "flight");
        ArrowFlightJdbcDataSource dataSource = ArrowFlightJdbcDataSource.createNewDataSource((Properties)properties);
        try (ArrowFlightConnection connection = dataSource.getConnection();){
            Assert.assertTrue((boolean)connection.isValid(300));
        }
    }

    @Test(expected=SQLException.class)
    public void testGetAuthenticatedEncryptedConnectionWithKeyStoreBadPassword() throws Exception {
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName(), FLIGHT_SERVER_TEST_RULE.getHost());
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName(), (Object)FLIGHT_SERVER_TEST_RULE.getPort());
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), (Object)true);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE.camelName(), this.trustStorePath);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE_PASSWORD.camelName(), "badpassword");
        ArrowFlightJdbcDataSource dataSource = ArrowFlightJdbcDataSource.createNewDataSource((Properties)properties);
        try (ArrowFlightConnection ignored = dataSource.getConnection();){
            Assert.fail();
        }
    }

    @Test
    public void testGetNonAuthenticatedEncryptedConnection() throws Exception {
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName(), FLIGHT_SERVER_TEST_RULE.getHost());
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName(), (Object)FLIGHT_SERVER_TEST_RULE.getPort());
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), (Object)true);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_SYSTEM_TRUST_STORE.camelName(), (Object)false);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE.camelName(), this.trustStorePath);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE_PASSWORD.camelName(), "flight");
        ArrowFlightJdbcDataSource dataSource = ArrowFlightJdbcDataSource.createNewDataSource((Properties)properties);
        try (ArrowFlightConnection connection = dataSource.getConnection();){
            Assert.assertTrue((boolean)connection.isValid(300));
        }
    }

    @Test
    public void testTLSConnectionPropertyTrueCorrectCastUrlWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s?user=%s&password=%s&useEncryption=true&useSystemTrustStore=false&%s=%s&%s=%s", FLIGHT_SERVER_TEST_RULE.getPort(), userTest, passTest, ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE.camelName(), URLEncoder.encode(this.trustStorePath, "UTF-8"), ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE_PASSWORD.camelName(), URLEncoder.encode("flight", "UTF-8")));){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testTLSConnectionPropertyTrueCorrectCastUrlAndPropertiesUsingSetPropertyWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE.camelName(), this.trustStorePath);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE_PASSWORD.camelName(), "flight");
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), "true");
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_SYSTEM_TRUST_STORE.camelName(), "false");
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort()), properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testTLSConnectionPropertyTrueCorrectCastUrlAndPropertiesUsingPutWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), (Object)true);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_SYSTEM_TRUST_STORE.camelName(), (Object)false);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE.camelName(), this.trustStorePath);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE_PASSWORD.camelName(), "flight");
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort()), properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testTLSConnectionPropertyTrueIntegerCorrectCastUrlWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s?user=%s&password=%s&useEncryption=1&useSystemTrustStore=0&%s=%s&%s=%s", FLIGHT_SERVER_TEST_RULE.getPort(), userTest, passTest, ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE.camelName(), URLEncoder.encode(this.trustStorePath, "UTF-8"), ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE_PASSWORD.camelName(), URLEncoder.encode("flight", "UTF-8")));){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testTLSConnectionPropertyTrueIntegerCorrectCastUrlAndPropertiesUsingSetPropertyWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE.camelName(), this.trustStorePath);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE_PASSWORD.camelName(), "flight");
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), "1");
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_SYSTEM_TRUST_STORE.camelName(), "0");
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort()), properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testTLSConnectionPropertyTrueIntegerCorrectCastUrlAndPropertiesUsingPutWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), (Object)1);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_SYSTEM_TRUST_STORE.camelName(), (Object)0);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE.camelName(), this.trustStorePath);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TRUST_STORE_PASSWORD.camelName(), "flight");
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort()), properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    static {
        PRODUCER = new MockFlightSqlProducer();
        FlightSqlTestCertificates.CertKeyPair certKey = FlightSqlTestCertificates.exampleTlsCerts().get(0);
        UserPasswordAuthentication authentication = new UserPasswordAuthentication.Builder().user(userTest, passTest).build();
        FLIGHT_SERVER_TEST_RULE = new FlightServerTestRule.Builder().authentication(authentication).useEncryption(certKey.cert, certKey.key).producer(PRODUCER).build();
    }
}

