/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcDriver;
import org.apache.arrow.driver.jdbc.FlightServerTestRule;
import org.apache.arrow.driver.jdbc.authentication.UserPasswordAuthentication;
import org.apache.arrow.driver.jdbc.client.ArrowFlightSqlClientHandler;
import org.apache.arrow.driver.jdbc.utils.ArrowFlightConnectionConfigImpl;
import org.apache.arrow.driver.jdbc.utils.MockFlightSqlProducer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class ConnectionTest {
    @ClassRule
    public static final FlightServerTestRule FLIGHT_SERVER_TEST_RULE;
    private static final MockFlightSqlProducer PRODUCER;
    private static final String userTest = "user1";
    private static final String passTest = "pass1";
    private BufferAllocator allocator;

    @Before
    public void setUp() throws Exception {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void tearDown() throws Exception {
        this.allocator.getChildAllocators().forEach(BufferAllocator::close);
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.allocator});
    }

    @Test
    public void testUnencryptedConnectionShouldOpenSuccessfullyWhenProvidedValidCredentials() throws Exception {
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName(), "localhost");
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName(), (Object)FLIGHT_SERVER_TEST_RULE.getPort());
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.put("useEncryption", (Object)false);
        try (Connection connection = DriverManager.getConnection("jdbc:arrow-flight-sql://" + FLIGHT_SERVER_TEST_RULE.getHost() + ":" + FLIGHT_SERVER_TEST_RULE.getPort(), properties);){
            Assert.assertTrue((boolean)connection.isValid(300));
        }
    }

    @Test
    public void testTokenOverridesUsernameAndPasswordAuth() {
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName(), "localhost");
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName(), (Object)FLIGHT_SERVER_TEST_RULE.getPort());
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TOKEN.camelName(), "token");
        properties.put("useEncryption", (Object)false);
        SQLException e = (SQLException)Assert.assertThrows(SQLException.class, () -> {
            Connection conn = DriverManager.getConnection("jdbc:arrow-flight-sql://" + FLIGHT_SERVER_TEST_RULE.getHost() + ":" + FLIGHT_SERVER_TEST_RULE.getPort(), properties);
            Throwable throwable = null;
            try {
                Assert.fail();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (conn != null) {
                    ConnectionTest.$closeResource(throwable, conn);
                }
            }
        });
        Assert.assertTrue((boolean)e.getMessage().contains("UNAUTHENTICATED"));
    }

    @Test(expected=SQLException.class)
    public void testUnencryptedConnectionWithEmptyHost() throws Exception {
        Properties properties = new Properties();
        properties.put("user", userTest);
        properties.put("password", passTest);
        String invalidUrl = "jdbc:arrow-flight-sql://";
        try (Connection conn = DriverManager.getConnection("jdbc:arrow-flight-sql://", properties);){
            Assert.fail((String)"Expected SQLException.");
        }
    }

    @Test
    public void testGetBasicClientAuthenticatedShouldOpenConnection() throws Exception {
        try (ArrowFlightSqlClientHandler client = new ArrowFlightSqlClientHandler.Builder().withHost(FLIGHT_SERVER_TEST_RULE.getHost()).withPort(FLIGHT_SERVER_TEST_RULE.getPort()).withEncryption(false).withUsername(userTest).withPassword(passTest).withBufferAllocator(this.allocator).build();){
            Assert.assertNotNull((Object)client);
        }
    }

    @Test(expected=SQLException.class)
    public void testUnencryptedConnectionProvidingInvalidPort() throws Exception {
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName(), "localhost");
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), (Object)false);
        String invalidUrl = "jdbc:arrow-flight-sql://" + FLIGHT_SERVER_TEST_RULE.getHost() + ":" + 65537;
        try (Connection conn = DriverManager.getConnection(invalidUrl, properties);){
            Assert.fail((String)"Expected SQLException");
        }
    }

    @Test
    public void testGetBasicClientNoAuthShouldOpenConnection() throws Exception {
        try (ArrowFlightSqlClientHandler client = new ArrowFlightSqlClientHandler.Builder().withHost(FLIGHT_SERVER_TEST_RULE.getHost()).withBufferAllocator(this.allocator).withEncryption(false).build();){
            Assert.assertNotNull((Object)client);
        }
    }

    @Test
    public void testUnencryptedConnectionShouldOpenSuccessfullyWithoutAuthentication() throws Exception {
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName(), "localhost");
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName(), (Object)FLIGHT_SERVER_TEST_RULE.getPort());
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), (Object)false);
        try (Connection connection = DriverManager.getConnection("jdbc:arrow-flight-sql://localhost:32010", properties);){
            Assert.assertTrue((boolean)connection.isValid(300));
        }
    }

    @Test(expected=SQLException.class)
    public void testUnencryptedConnectionShouldThrowExceptionWhenProvidedWithInvalidCredentials() throws Exception {
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName(), "localhost");
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), "invalidUser");
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName(), (Object)FLIGHT_SERVER_TEST_RULE.getPort());
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), (Object)false);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), "invalidPassword");
        try (Connection ignored = DriverManager.getConnection("jdbc:arrow-flight-sql://localhost:32010", properties);){
            Assert.fail();
        }
    }

    @Test
    public void testTLSConnectionPropertyFalseCorrectCastUrlWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s?user=%s&password=%s&useEncryption=false", FLIGHT_SERVER_TEST_RULE.getPort(), userTest, passTest));){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testTLSConnectionPropertyFalseCorrectCastUrlAndPropertiesUsingSetPropertyWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), "false");
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort()), properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testTLSConnectionPropertyFalseCorrectCastUrlAndPropertiesUsingPutWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), (Object)false);
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort()), properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testTLSConnectionPropertyFalseIntegerCorrectCastUrlWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s?user=%s&password=%s&useEncryption=0", FLIGHT_SERVER_TEST_RULE.getPort(), userTest, passTest));){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testTLSConnectionPropertyFalseIntegerCorrectCastUrlAndPropertiesUsingSetPropertyWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), "0");
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort()), properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testTLSConnectionPropertyFalseIntegerCorrectCastUrlAndPropertiesUsingPutWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), (Object)0);
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort()), properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testThreadPoolSizeConnectionPropertyCorrectCastUrlWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s?user=%s&password=%s&threadPoolSize=1&useEncryption=%s", FLIGHT_SERVER_TEST_RULE.getPort(), userTest, passTest, false));){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testThreadPoolSizeConnectionPropertyCorrectCastUrlAndPropertiesUsingSetPropertyWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.THREAD_POOL_SIZE.camelName(), "1");
        properties.put("useEncryption", (Object)false);
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort()), properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testThreadPoolSizeConnectionPropertyCorrectCastUrlAndPropertiesUsingPutWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.THREAD_POOL_SIZE.camelName(), (Object)1);
        properties.put("useEncryption", (Object)false);
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort()), properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testPasswordConnectionPropertyIntegerCorrectCastUrlWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s?user=%s&password=%s&useEncryption=%s", FLIGHT_SERVER_TEST_RULE.getPort(), userTest, passTest, false));){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testPasswordConnectionPropertyIntegerCorrectCastUrlAndPropertiesUsingSetPropertyWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.put("useEncryption", (Object)false);
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort()), properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testPasswordConnectionPropertyIntegerCorrectCastUrlAndPropertiesUsingPutWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.put("useEncryption", (Object)false);
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort()), properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    static {
        PRODUCER = new MockFlightSqlProducer();
        UserPasswordAuthentication authentication = new UserPasswordAuthentication.Builder().user(userTest, passTest).build();
        FLIGHT_SERVER_TEST_RULE = new FlightServerTestRule.Builder().authentication(authentication).producer(PRODUCER).build();
    }
}

