/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.io.File;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.arrow.driver.jdbc.ArrowFlightConnection;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcDataSource;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcDriver;
import org.apache.arrow.driver.jdbc.FlightServerTestRule;
import org.apache.arrow.driver.jdbc.authentication.UserPasswordAuthentication;
import org.apache.arrow.driver.jdbc.client.ArrowFlightSqlClientHandler;
import org.apache.arrow.driver.jdbc.utils.ArrowFlightConnectionConfigImpl;
import org.apache.arrow.driver.jdbc.utils.FlightSqlTestCertificates;
import org.apache.arrow.driver.jdbc.utils.MockFlightSqlProducer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class ConnectionMutualTlsTest {
    @ClassRule
    public static final FlightServerTestRule FLIGHT_SERVER_TEST_RULE;
    private static final String tlsRootCertsPath;
    private static final String clientMTlsCertPath;
    private static final String badClientMTlsCertPath;
    private static final String clientMTlsKeyPath;
    private static final String badClientMTlsKeyPath;
    private static final MockFlightSqlProducer PRODUCER;
    private static final String userTest = "user1";
    private static final String passTest = "pass1";
    private BufferAllocator allocator;

    @Before
    public void setUp() throws Exception {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void tearDown() throws Exception {
        this.allocator.getChildAllocators().forEach(BufferAllocator::close);
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.allocator});
    }

    @Test
    public void testGetEncryptedClientAuthenticated() throws Exception {
        try (ArrowFlightSqlClientHandler client = new ArrowFlightSqlClientHandler.Builder().withHost(FLIGHT_SERVER_TEST_RULE.getHost()).withPort(FLIGHT_SERVER_TEST_RULE.getPort()).withUsername(userTest).withPassword(passTest).withTlsRootCertificates(tlsRootCertsPath).withClientCertificate(clientMTlsCertPath).withClientKey(clientMTlsKeyPath).withBufferAllocator(this.allocator).withEncryption(true).build();){
            Assert.assertNotNull((Object)client);
        }
    }

    @Test
    public void testGetEncryptedClientWithBadMTlsCertPath() {
        Assert.assertThrows(SQLException.class, () -> {
            ArrowFlightSqlClientHandler handler = new ArrowFlightSqlClientHandler.Builder().withHost(FLIGHT_SERVER_TEST_RULE.getHost()).withPort(FLIGHT_SERVER_TEST_RULE.getPort()).withUsername(userTest).withPassword(passTest).withTlsRootCertificates(tlsRootCertsPath).withClientCertificate(badClientMTlsCertPath).withClientKey(clientMTlsKeyPath).withBufferAllocator(this.allocator).withEncryption(true).build();
            Throwable throwable = null;
            try {
                Assert.fail();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (handler != null) {
                    ConnectionMutualTlsTest.$closeResource(throwable, (AutoCloseable)handler);
                }
            }
        });
    }

    @Test
    public void testGetEncryptedClientWithBadMTlsKeyPath() {
        Assert.assertThrows(SQLException.class, () -> {
            ArrowFlightSqlClientHandler handler = new ArrowFlightSqlClientHandler.Builder().withHost(FLIGHT_SERVER_TEST_RULE.getHost()).withPort(FLIGHT_SERVER_TEST_RULE.getPort()).withUsername(userTest).withPassword(passTest).withTlsRootCertificates(tlsRootCertsPath).withClientCertificate(clientMTlsCertPath).withClientKey(badClientMTlsKeyPath).withBufferAllocator(this.allocator).withEncryption(true).build();
            Throwable throwable = null;
            try {
                Assert.fail();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (handler != null) {
                    ConnectionMutualTlsTest.$closeResource(throwable, (AutoCloseable)handler);
                }
            }
        });
    }

    @Test
    public void testGetNonAuthenticatedEncryptedClientNoAuth() throws Exception {
        try (ArrowFlightSqlClientHandler client = new ArrowFlightSqlClientHandler.Builder().withHost(FLIGHT_SERVER_TEST_RULE.getHost()).withTlsRootCertificates(tlsRootCertsPath).withClientCertificate(clientMTlsCertPath).withClientKey(clientMTlsKeyPath).withBufferAllocator(this.allocator).withEncryption(true).build();){
            Assert.assertNotNull((Object)client);
        }
    }

    @Test
    public void testGetEncryptedConnectionWithValidCredentialsAndTlsRootsPath() throws Exception {
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName(), "localhost");
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName(), (Object)FLIGHT_SERVER_TEST_RULE.getPort());
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TLS_ROOT_CERTS.camelName(), tlsRootCertsPath);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_CERTIFICATE.camelName(), clientMTlsCertPath);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_KEY.camelName(), clientMTlsKeyPath);
        ArrowFlightJdbcDataSource dataSource = ArrowFlightJdbcDataSource.createNewDataSource((Properties)properties);
        try (ArrowFlightConnection connection = dataSource.getConnection();){
            Assert.assertTrue((boolean)connection.isValid(300));
        }
    }

    @Test
    public void testGetNonAuthenticatedEncryptedConnection() throws Exception {
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName(), FLIGHT_SERVER_TEST_RULE.getHost());
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName(), (Object)FLIGHT_SERVER_TEST_RULE.getPort());
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), (Object)true);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TLS_ROOT_CERTS.camelName(), tlsRootCertsPath);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_CERTIFICATE.camelName(), clientMTlsCertPath);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_KEY.camelName(), clientMTlsKeyPath);
        ArrowFlightJdbcDataSource dataSource = ArrowFlightJdbcDataSource.createNewDataSource((Properties)properties);
        try (ArrowFlightConnection connection = dataSource.getConnection();){
            Assert.assertTrue((boolean)connection.isValid(300));
        }
    }

    @Test
    public void testTLSConnectionPropertyTrueCorrectCastUrlWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        String jdbcUrl = String.format("jdbc:arrow-flight-sql://localhost:%s?user=%s&password=%s&useEncryption=true&%s=%s&%s=%s&%s=%s", FLIGHT_SERVER_TEST_RULE.getPort(), userTest, passTest, ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TLS_ROOT_CERTS.camelName(), URLEncoder.encode(tlsRootCertsPath, "UTF-8"), ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_CERTIFICATE.camelName(), URLEncoder.encode(clientMTlsCertPath, "UTF-8"), ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_KEY.camelName(), URLEncoder.encode(clientMTlsKeyPath, "UTF-8"));
        try (Connection connection = DriverManager.getConnection(jdbcUrl);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testTLSConnectionPropertyTrueCorrectCastUrlAndPropertiesUsingSetPropertyWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TLS_ROOT_CERTS.camelName(), tlsRootCertsPath);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), "true");
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_CERTIFICATE.camelName(), clientMTlsCertPath);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_KEY.camelName(), clientMTlsKeyPath);
        String jdbcUrl = String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort());
        try (Connection connection = DriverManager.getConnection(jdbcUrl, properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testTLSConnectionPropertyTrueCorrectCastUrlAndPropertiesUsingPutWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), (Object)true);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TLS_ROOT_CERTS.camelName(), tlsRootCertsPath);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_CERTIFICATE.camelName(), clientMTlsCertPath);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_KEY.camelName(), clientMTlsKeyPath);
        String jdbcUrl = String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort());
        try (Connection connection = DriverManager.getConnection(jdbcUrl, properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testTLSConnectionPropertyTrueIntegerCorrectCastUrlWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        String jdbcUrl = String.format("jdbc:arrow-flight-sql://localhost:%s?user=%s&password=%s&useEncryption=1&useSystemTrustStore=0&%s=%s&%s=%s&%s=%s", FLIGHT_SERVER_TEST_RULE.getPort(), userTest, passTest, ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TLS_ROOT_CERTS.camelName(), URLEncoder.encode(tlsRootCertsPath, "UTF-8"), ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_CERTIFICATE.camelName(), URLEncoder.encode(clientMTlsCertPath, "UTF-8"), ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_KEY.camelName(), URLEncoder.encode(clientMTlsKeyPath, "UTF-8"));
        try (Connection connection = DriverManager.getConnection(jdbcUrl);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testTLSConnectionPropertyTrueIntegerCorrectCastUrlAndPropertiesUsingSetPropertyWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TLS_ROOT_CERTS.camelName(), tlsRootCertsPath);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), "1");
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_CERTIFICATE.camelName(), clientMTlsCertPath);
        properties.setProperty(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_KEY.camelName(), clientMTlsKeyPath);
        String jdbcUrl = String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort());
        try (Connection connection = DriverManager.getConnection(jdbcUrl, properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    @Test
    public void testTLSConnectionPropertyTrueIntegerCorrectCastUrlAndPropertiesUsingPutWithDriverManager() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), userTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), passTest);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), (Object)1);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TLS_ROOT_CERTS.camelName(), tlsRootCertsPath);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_CERTIFICATE.camelName(), clientMTlsCertPath);
        properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.CLIENT_KEY.camelName(), clientMTlsKeyPath);
        String jdbcUrl = String.format("jdbc:arrow-flight-sql://localhost:%s", FLIGHT_SERVER_TEST_RULE.getPort());
        try (Connection connection = DriverManager.getConnection(jdbcUrl, properties);){
            Assert.assertTrue((boolean)connection.isValid(0));
        }
    }

    static {
        PRODUCER = new MockFlightSqlProducer();
        FlightSqlTestCertificates.CertKeyPair certKey = FlightSqlTestCertificates.exampleTlsCerts().get(0);
        tlsRootCertsPath = certKey.cert.getPath();
        File serverMTlsCACert = FlightSqlTestCertificates.exampleCACert();
        FlightSqlTestCertificates.CertKeyPair clientMTlsCertKey = FlightSqlTestCertificates.exampleTlsCerts().get(1);
        clientMTlsCertPath = clientMTlsCertKey.cert.getPath();
        clientMTlsKeyPath = clientMTlsCertKey.key.getPath();
        badClientMTlsCertPath = clientMTlsCertPath + ".bad";
        badClientMTlsKeyPath = clientMTlsKeyPath + ".bad";
        UserPasswordAuthentication authentication = new UserPasswordAuthentication.Builder().user(userTest, passTest).build();
        FLIGHT_SERVER_TEST_RULE = new FlightServerTestRule.Builder().authentication(authentication).useEncryption(certKey.cert, certKey.key).useMTlsClientVerification(serverMTlsCACert).producer(PRODUCER).build();
    }
}

