/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Collections;
import org.apache.arrow.driver.jdbc.FlightServerTestRule;
import org.apache.arrow.driver.jdbc.utils.MockFlightSqlProducer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.calcite.avatica.AvaticaUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class ArrowFlightStatementExecuteUpdateTest {
    private static final String UPDATE_SAMPLE_QUERY = "UPDATE sample_table SET sample_col = sample_val WHERE sample_condition";
    private static final int UPDATE_SAMPLE_QUERY_AFFECTED_COLS = 10;
    private static final String LARGE_UPDATE_SAMPLE_QUERY = "UPDATE large_sample_table SET large_sample_col = large_sample_val WHERE large_sample_condition";
    private static final long LARGE_UPDATE_SAMPLE_QUERY_AFFECTED_COLS = 0x80000000L;
    private static final String REGULAR_QUERY_SAMPLE = "SELECT * FROM NOT_UPDATE_QUERY";
    private static final Schema REGULAR_QUERY_SCHEMA = new Schema(Collections.singletonList(Field.nullable((String)"placeholder", (ArrowType)Types.MinorType.VARCHAR.getType())));
    private static final MockFlightSqlProducer PRODUCER = new MockFlightSqlProducer();
    @ClassRule
    public static final FlightServerTestRule SERVER_TEST_RULE = FlightServerTestRule.createStandardTestRule(PRODUCER);
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    public Connection connection;
    public Statement statement;

    @BeforeClass
    public static void setUpBeforeClass() {
        PRODUCER.addUpdateQuery(UPDATE_SAMPLE_QUERY, 10L);
        PRODUCER.addUpdateQuery(LARGE_UPDATE_SAMPLE_QUERY, 0x80000000L);
        PRODUCER.addSelectQuery(REGULAR_QUERY_SAMPLE, REGULAR_QUERY_SCHEMA, Collections.singletonList(listener -> {
            try {
                RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
                Throwable throwable = null;
                try {
                    VectorSchemaRoot root = VectorSchemaRoot.create((Schema)REGULAR_QUERY_SCHEMA, (BufferAllocator)allocator);
                    Throwable throwable2 = null;
                    try {
                        listener.start(root);
                        listener.putNext();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (root != null) {
                            ArrowFlightStatementExecuteUpdateTest.$closeResource(throwable2, (AutoCloseable)root);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    ArrowFlightStatementExecuteUpdateTest.$closeResource(throwable, (AutoCloseable)allocator);
                }
            }
            catch (Throwable throwable) {
                listener.error(throwable);
            }
            finally {
                listener.completed();
            }
        }));
    }

    @Before
    public void setUp() throws SQLException {
        this.connection = SERVER_TEST_RULE.getConnection(false);
        this.statement = this.connection.createStatement();
    }

    @After
    public void tearDown() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.statement, this.connection});
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{PRODUCER});
    }

    @Test
    public void testExecuteUpdateShouldReturnNumColsAffectedForNumRowsFittingInt() throws SQLException {
        this.collector.checkThat((Object)this.statement.executeUpdate(UPDATE_SAMPLE_QUERY), CoreMatchers.is((Object)10));
    }

    @Test
    public void testExecuteUpdateShouldReturnSaturatedNumColsAffectedIfDoesNotFitInInt() throws SQLException {
        long result = this.statement.executeUpdate(LARGE_UPDATE_SAMPLE_QUERY);
        long expectedRowCountRaw = 0x80000000L;
        this.collector.checkThat((Object)result, CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)0x80000000L)), CoreMatchers.equalTo((Object)AvaticaUtils.toSaturatedInt((long)0x80000000L))})));
    }

    @Test
    public void testExecuteLargeUpdateShouldReturnNumColsAffected() throws SQLException {
        this.collector.checkThat((Object)this.statement.executeLargeUpdate(LARGE_UPDATE_SAMPLE_QUERY), CoreMatchers.is((Object)0x80000000L));
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testExecuteUpdateUnsupportedWithDriverFlag() throws SQLException {
        this.collector.checkThat((Object)this.statement.executeUpdate(UPDATE_SAMPLE_QUERY, 1), CoreMatchers.is((Object)10));
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testExecuteUpdateUnsupportedWithArrayOfInts() throws SQLException {
        this.collector.checkThat((Object)this.statement.executeUpdate(UPDATE_SAMPLE_QUERY, new int[0]), CoreMatchers.is((Object)10));
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testExecuteUpdateUnsupportedWithArraysOfStrings() throws SQLException {
        this.collector.checkThat((Object)this.statement.executeUpdate(UPDATE_SAMPLE_QUERY, new String[0]), CoreMatchers.is((Object)10));
    }

    @Test
    public void testExecuteShouldExecuteUpdateQueryAutomatically() throws SQLException {
        this.collector.checkThat((Object)this.statement.execute(UPDATE_SAMPLE_QUERY), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)this.statement.execute(REGULAR_QUERY_SAMPLE), CoreMatchers.is((Object)true));
    }

    @Test
    public void testShouldFailToPrepareStatementForNullQuery() {
        int count = 0;
        try {
            this.collector.checkThat((Object)this.statement.execute(null), CoreMatchers.is((Object)false));
        }
        catch (SQLException e) {
            ++count;
            this.collector.checkThat((Object)e.getCause(), CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NullPointerException.class)));
        }
        this.collector.checkThat((Object)count, CoreMatchers.is((Object)1));
    }

    @Test
    public void testShouldFailToPrepareStatementForClosedStatement() throws SQLException {
        this.statement.close();
        this.collector.checkThat((Object)this.statement.isClosed(), CoreMatchers.is((Object)true));
        int count = 0;
        try {
            this.statement.execute(UPDATE_SAMPLE_QUERY);
        }
        catch (SQLException e) {
            ++count;
            this.collector.checkThat((Object)e.getMessage(), CoreMatchers.is((Object)"Statement closed"));
        }
        this.collector.checkThat((Object)count, CoreMatchers.is((Object)1));
    }

    @Test
    public void testShouldFailToPrepareStatementForBadStatement() {
        String badQuery = "BAD INVALID STATEMENT";
        int count = 0;
        try {
            this.statement.execute("BAD INVALID STATEMENT");
        }
        catch (SQLException e) {
            ++count;
            this.collector.checkThat((Object)e.getMessage(), CoreMatchers.is((Object)String.format("Error while executing SQL \"%s\": Query not found", "BAD INVALID STATEMENT")));
        }
        this.collector.checkThat((Object)count, CoreMatchers.is((Object)1));
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

