/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.arrow.driver.jdbc.FlightServerTestRule;
import org.apache.arrow.driver.jdbc.utils.MockFlightSqlProducer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.calcite.avatica.AvaticaUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class ArrowFlightStatementExecuteTest {
    private static final String SAMPLE_QUERY_CMD = "SELECT * FROM this_test";
    private static final int SAMPLE_QUERY_ROWS = 127;
    private static final String VECTOR_NAME = "Unsigned Byte";
    private static final Schema SAMPLE_QUERY_SCHEMA = new Schema(Collections.singletonList(Field.nullable((String)"Unsigned Byte", (ArrowType)Types.MinorType.UINT1.getType())));
    private static final String SAMPLE_UPDATE_QUERY = "UPDATE this_table SET this_field = that_field FROM this_test WHERE this_condition";
    private static final long SAMPLE_UPDATE_COUNT = 100L;
    private static final String SAMPLE_LARGE_UPDATE_QUERY = "UPDATE this_large_table SET this_large_field = that_large_field FROM this_large_test WHERE this_large_condition";
    private static final long SAMPLE_LARGE_UPDATE_COUNT = Long.MAX_VALUE;
    private static final MockFlightSqlProducer PRODUCER = new MockFlightSqlProducer();
    @ClassRule
    public static final FlightServerTestRule SERVER_TEST_RULE = FlightServerTestRule.createStandardTestRule(PRODUCER);
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    private Connection connection;
    private Statement statement;

    @BeforeClass
    public static void setUpBeforeClass() {
        PRODUCER.addSelectQuery(SAMPLE_QUERY_CMD, SAMPLE_QUERY_SCHEMA, Collections.singletonList(listener -> {
            try {
                RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
                Throwable throwable = null;
                try {
                    VectorSchemaRoot root = VectorSchemaRoot.create((Schema)SAMPLE_QUERY_SCHEMA, (BufferAllocator)allocator);
                    Throwable throwable2 = null;
                    try {
                        UInt1Vector vector = (UInt1Vector)root.getVector(VECTOR_NAME);
                        IntStream.range(0, 127).forEach(index -> vector.setSafe(index, index));
                        vector.setValueCount(127);
                        root.setRowCount(127);
                        listener.start(root);
                        listener.putNext();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (root != null) {
                            ArrowFlightStatementExecuteTest.$closeResource(throwable2, (AutoCloseable)root);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    ArrowFlightStatementExecuteTest.$closeResource(throwable, (AutoCloseable)allocator);
                }
            }
            catch (Throwable throwable) {
                listener.error(throwable);
            }
            finally {
                listener.completed();
            }
        }));
        PRODUCER.addUpdateQuery(SAMPLE_UPDATE_QUERY, 100L);
        PRODUCER.addUpdateQuery(SAMPLE_LARGE_UPDATE_QUERY, Long.MAX_VALUE);
    }

    @Before
    public void setUp() throws SQLException {
        this.connection = SERVER_TEST_RULE.getConnection(false);
        this.statement = this.connection.createStatement();
    }

    @After
    public void tearDown() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.statement, this.connection});
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{PRODUCER});
    }

    @Test
    public void testExecuteShouldRunSelectQuery() throws SQLException {
        this.collector.checkThat((Object)this.statement.execute(SAMPLE_QUERY_CMD), CoreMatchers.is((Object)true));
        Set numbers = IntStream.range(0, 127).boxed().map(Integer::byteValue).collect(Collectors.toCollection(HashSet::new));
        try (ResultSet resultSet = this.statement.getResultSet();){
            int columnCount = resultSet.getMetaData().getColumnCount();
            this.collector.checkThat((Object)columnCount, CoreMatchers.is((Object)1));
            int rowCount = 0;
            while (resultSet.next()) {
                this.collector.checkThat((Object)numbers.remove(resultSet.getByte(1)), CoreMatchers.is((Object)true));
                ++rowCount;
            }
            this.collector.checkThat((Object)rowCount, CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)127)));
        }
        this.collector.checkThat((Object)numbers, CoreMatchers.is(Collections.emptySet()));
        this.collector.checkThat((Object)this.statement.getUpdateCount(), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)this.statement.getLargeUpdateCount()), CoreMatchers.equalTo((Object)-1L)})));
    }

    @Test
    public void testExecuteShouldRunUpdateQueryForSmallUpdate() throws SQLException {
        this.collector.checkThat((Object)this.statement.execute(SAMPLE_UPDATE_QUERY), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)this.statement.getUpdateCount(), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)this.statement.getLargeUpdateCount()), CoreMatchers.equalTo((Object)100L)})));
        this.collector.checkThat((Object)this.statement.getResultSet(), CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testExecuteShouldRunUpdateQueryForLargeUpdate() throws SQLException {
        this.collector.checkThat((Object)this.statement.execute(SAMPLE_LARGE_UPDATE_QUERY), CoreMatchers.is((Object)false));
        long updateCountSmall = this.statement.getUpdateCount();
        long updateCountLarge = this.statement.getLargeUpdateCount();
        this.collector.checkThat((Object)updateCountLarge, CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Long.MAX_VALUE)));
        this.collector.checkThat((Object)updateCountSmall, CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)AvaticaUtils.toSaturatedInt((long)updateCountLarge)), CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)updateCountLarge))})));
        this.collector.checkThat((Object)this.statement.getResultSet(), CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testUpdateCountShouldStartOnZero() throws SQLException {
        this.collector.checkThat((Object)this.statement.getUpdateCount(), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)this.statement.getLargeUpdateCount()), CoreMatchers.equalTo((Object)0L)})));
        this.collector.checkThat((Object)this.statement.getResultSet(), CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

