/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.driver.jdbc.FlightServerTestRule;
import org.apache.arrow.driver.jdbc.utils.CoreMockedSqlProducers;
import org.apache.arrow.driver.jdbc.utils.MockFlightSqlProducer;
import org.apache.arrow.flight.sql.FlightSqlUtils;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.hamcrest.CoreMatchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.ErrorCollector;

public class ArrowFlightPreparedStatementTest {
    public static final MockFlightSqlProducer PRODUCER = CoreMockedSqlProducers.getLegacyProducer();
    @ClassRule
    public static final FlightServerTestRule FLIGHT_SERVER_TEST_RULE = FlightServerTestRule.createStandardTestRule(PRODUCER);
    private static Connection connection;
    @Rule
    public final ErrorCollector collector = new ErrorCollector();

    @BeforeClass
    public static void setup() throws SQLException {
        connection = FLIGHT_SERVER_TEST_RULE.getConnection(false);
    }

    @AfterClass
    public static void tearDown() throws SQLException {
        connection.close();
    }

    @Before
    public void before() {
        PRODUCER.clearActionTypeCounter();
    }

    @Test
    public void testSimpleQueryNoParameterBinding() throws SQLException {
        String query = "SELECT * FROM TEST";
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM TEST");
             ResultSet resultSet = preparedStatement.executeQuery();){
            CoreMockedSqlProducers.assertLegacyRegularSqlResultSet(resultSet, this.collector);
        }
    }

    @Test
    public void testQueryWithParameterBinding() throws SQLException {
        String query = "Fake query with parameters";
        Schema schema = new Schema(Collections.singletonList(Field.nullable((String)"", (ArrowType)Types.MinorType.INT.getType())));
        Schema parameterSchema = new Schema(Arrays.asList(Field.nullable((String)"", (ArrowType)ArrowType.Utf8.INSTANCE), new Field("", FieldType.nullable((ArrowType)ArrowType.List.INSTANCE), Collections.singletonList(Field.nullable((String)"", (ArrowType)Types.MinorType.INT.getType())))));
        List<List<Object>> expected = Collections.singletonList(Arrays.asList(new Text("foo"), new Integer[]{1, 2, null}));
        PRODUCER.addSelectQuery("Fake query with parameters", schema, Collections.singletonList(listener -> {
            try {
                RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
                Throwable throwable = null;
                try {
                    VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);
                    Throwable throwable2 = null;
                    try {
                        ((IntVector)root.getVector(0)).setSafe(0, 10);
                        root.setRowCount(1);
                        listener.start(root);
                        listener.putNext();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (root != null) {
                            ArrowFlightPreparedStatementTest.$closeResource(throwable2, (AutoCloseable)root);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    ArrowFlightPreparedStatementTest.$closeResource(throwable, (AutoCloseable)allocator);
                }
            }
            catch (Throwable throwable) {
                listener.error(throwable);
            }
            finally {
                listener.completed();
            }
        }));
        PRODUCER.addExpectedParameters("Fake query with parameters", parameterSchema, expected);
        try (PreparedStatement preparedStatement = connection.prepareStatement("Fake query with parameters");){
            preparedStatement.setString(1, "foo");
            preparedStatement.setArray(2, connection.createArrayOf("INTEGER", new Integer[]{1, 2, null}));
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                resultSet.next();
            }
        }
    }

    @Test
    @Ignore(value="https://github.com/apache/arrow/issues/34741: flaky test")
    public void testPreparedStatementExecutionOnce() throws SQLException {
        PreparedStatement statement = connection.prepareStatement("SELECT * FROM TEST");
        Assertions.assertEquals((int)PRODUCER.getActionTypeCounter().size(), (int)1);
        Assertions.assertEquals((Integer)PRODUCER.getActionTypeCounter().get(FlightSqlUtils.FLIGHT_SQL_CREATE_PREPARED_STATEMENT.getType()), (int)1);
        statement.close();
    }

    @Test
    public void testReturnColumnCount() throws SQLException {
        String query = "SELECT * FROM TEST";
        try (PreparedStatement psmt = connection.prepareStatement("SELECT * FROM TEST");){
            this.collector.checkThat((Object)"ID", CoreMatchers.equalTo((Object)psmt.getMetaData().getColumnName(1)));
            this.collector.checkThat((Object)"Name", CoreMatchers.equalTo((Object)psmt.getMetaData().getColumnName(2)));
            this.collector.checkThat((Object)"Age", CoreMatchers.equalTo((Object)psmt.getMetaData().getColumnName(3)));
            this.collector.checkThat((Object)"Salary", CoreMatchers.equalTo((Object)psmt.getMetaData().getColumnName(4)));
            this.collector.checkThat((Object)"Hire Date", CoreMatchers.equalTo((Object)psmt.getMetaData().getColumnName(5)));
            this.collector.checkThat((Object)"Last Sale", CoreMatchers.equalTo((Object)psmt.getMetaData().getColumnName(6)));
            this.collector.checkThat((Object)6, CoreMatchers.equalTo((Object)psmt.getMetaData().getColumnCount()));
        }
    }

    @Test
    public void testUpdateQuery() throws SQLException {
        String query = "Fake update";
        PRODUCER.addUpdateQuery(query, 42L);
        try (PreparedStatement stmt = connection.prepareStatement(query);){
            int updated = stmt.executeUpdate();
            Assertions.assertEquals((int)42, (int)updated);
        }
    }

    @Test
    public void testUpdateQueryWithParameters() throws SQLException {
        String query = "Fake update with parameters";
        PRODUCER.addUpdateQuery(query, 42L);
        PRODUCER.addExpectedParameters(query, new Schema(Collections.singletonList(Field.nullable((String)"", (ArrowType)ArrowType.Utf8.INSTANCE))), Collections.singletonList(Collections.singletonList(new Text("foo".getBytes(StandardCharsets.UTF_8)))));
        try (PreparedStatement stmt = connection.prepareStatement(query);){
            stmt.setString(1, "foo");
            int updated = stmt.executeUpdate();
            Assertions.assertEquals((int)42, (int)updated);
        }
    }

    @Test
    public void testUpdateQueryWithBatchedParameters() throws SQLException {
        String query = "Fake update with batched parameters";
        Schema parameterSchema = new Schema(Arrays.asList(Field.nullable((String)"", (ArrowType)ArrowType.Utf8.INSTANCE), new Field("", FieldType.nullable((ArrowType)ArrowType.List.INSTANCE), Collections.singletonList(Field.nullable((String)"", (ArrowType)Types.MinorType.INT.getType())))));
        List<List<Object>> expected = Arrays.asList(Arrays.asList(new Text("foo"), new Integer[]{1, 2, null}), Arrays.asList(new Text("bar"), new Integer[]{0, -1, 100000}));
        PRODUCER.addUpdateQuery(query, 42L);
        PRODUCER.addExpectedParameters(query, parameterSchema, expected);
        try (PreparedStatement stmt = connection.prepareStatement(query);){
            stmt.setString(1, "foo");
            stmt.setArray(2, connection.createArrayOf("INTEGER", new Integer[]{1, 2, null}));
            stmt.addBatch();
            stmt.setString(1, "bar");
            stmt.setArray(2, connection.createArrayOf("INTEGER", new Integer[]{0, -1, 100000}));
            stmt.addBatch();
            int[] updated = stmt.executeBatch();
            Assertions.assertEquals((int)42, (int)updated[0]);
        }
    }
}

