/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.time.LocalTime;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcTime;
import org.hamcrest.CoreMatchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class ArrowFlightJdbcTimeTest {
    @ClassRule
    public static final ErrorCollector collector = new ErrorCollector();
    final int hour = 5;
    final int minute = 6;
    final int second = 7;

    @Test
    public void testPrintingMillisNoLeadingZeroes() {
        LocalTime dateTime = LocalTime.of(5, 6, 7, (int)TimeUnit.MILLISECONDS.toNanos(999L));
        ArrowFlightJdbcTime time = new ArrowFlightJdbcTime(dateTime);
        collector.checkThat((Object)time.toString(), CoreMatchers.endsWith((String)".999"));
        collector.checkThat((Object)time.getHours(), CoreMatchers.is((Object)5));
        collector.checkThat((Object)time.getMinutes(), CoreMatchers.is((Object)6));
        collector.checkThat((Object)time.getSeconds(), CoreMatchers.is((Object)7));
    }

    @Test
    public void testPrintingMillisOneLeadingZeroes() {
        LocalTime dateTime = LocalTime.of(5, 6, 7, (int)TimeUnit.MILLISECONDS.toNanos(99L));
        ArrowFlightJdbcTime time = new ArrowFlightJdbcTime(dateTime);
        collector.checkThat((Object)time.toString(), CoreMatchers.endsWith((String)".099"));
        collector.checkThat((Object)time.getHours(), CoreMatchers.is((Object)5));
        collector.checkThat((Object)time.getMinutes(), CoreMatchers.is((Object)6));
        collector.checkThat((Object)time.getSeconds(), CoreMatchers.is((Object)7));
    }

    @Test
    public void testPrintingMillisTwoLeadingZeroes() {
        LocalTime dateTime = LocalTime.of(5, 6, 7, (int)TimeUnit.MILLISECONDS.toNanos(1L));
        ArrowFlightJdbcTime time = new ArrowFlightJdbcTime(dateTime);
        collector.checkThat((Object)time.toString(), CoreMatchers.endsWith((String)".001"));
        collector.checkThat((Object)time.getHours(), CoreMatchers.is((Object)5));
        collector.checkThat((Object)time.getMinutes(), CoreMatchers.is((Object)6));
        collector.checkThat((Object)time.getSeconds(), CoreMatchers.is((Object)7));
    }

    @Test
    public void testEquality() {
        LocalTime dateTime = LocalTime.of(5, 6, 7, (int)TimeUnit.MILLISECONDS.toNanos(1L));
        ArrowFlightJdbcTime time1 = new ArrowFlightJdbcTime(dateTime);
        ArrowFlightJdbcTime time2 = new ArrowFlightJdbcTime(dateTime);
        collector.checkThat((Object)time1, CoreMatchers.is((Object)time2));
        collector.checkThat((Object)time1.hashCode(), CoreMatchers.is((Object)time2.hashCode()));
    }
}

