/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Properties;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcConnectionPoolDataSource;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcDriver;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcFactory;
import org.apache.arrow.driver.jdbc.FlightServerTestRule;
import org.apache.arrow.driver.jdbc.authentication.UserPasswordAuthentication;
import org.apache.arrow.driver.jdbc.utils.ArrowFlightConnectionConfigImpl;
import org.apache.arrow.driver.jdbc.utils.MockFlightSqlProducer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaFactory;
import org.apache.calcite.avatica.UnregisteredDriver;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class ArrowFlightJdbcFactoryTest {
    @ClassRule
    public static final FlightServerTestRule FLIGHT_SERVER_TEST_RULE;
    private static final MockFlightSqlProducer PRODUCER;
    private BufferAllocator allocator;
    private ArrowFlightJdbcConnectionPoolDataSource dataSource;

    @Before
    public void setUp() throws Exception {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
        this.dataSource = FLIGHT_SERVER_TEST_RULE.createConnectionPoolDataSource();
    }

    @After
    public void tearDown() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.dataSource, this.allocator});
    }

    @Test
    public void testShouldBeAbleToEstablishAConnectionSuccessfully() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        Constructor constructor = ArrowFlightJdbcFactory.class.getConstructor(new Class[0]);
        constructor.setAccessible(true);
        ArrowFlightJdbcFactory factory = (ArrowFlightJdbcFactory)constructor.newInstance(new Object[0]);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)ImmutableMap.of((Object)ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName(), (Object)"localhost", (Object)ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName(), (Object)32010, (Object)ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION.camelName(), (Object)false));
        try (AvaticaConnection connection = factory.newConnection((UnregisteredDriver)driver, (AvaticaFactory)constructor.newInstance(new Object[0]), "jdbc:arrow-flight-sql://localhost:32010", properties);){
            assert (connection.isValid(300));
        }
    }

    static {
        PRODUCER = new MockFlightSqlProducer();
        UserPasswordAuthentication authentication = new UserPasswordAuthentication.Builder().user("user1", "pass1").user("user2", "pass2").build();
        FLIGHT_SERVER_TEST_RULE = new FlightServerTestRule.Builder().authentication(authentication).producer(PRODUCER).build();
    }
}

