/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcConnectionPoolDataSource;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcDriver;
import org.apache.arrow.driver.jdbc.FlightServerTestRule;
import org.apache.arrow.driver.jdbc.authentication.UserPasswordAuthentication;
import org.apache.arrow.driver.jdbc.utils.ArrowFlightConnectionConfigImpl;
import org.apache.arrow.driver.jdbc.utils.MockFlightSqlProducer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class ArrowFlightJdbcDriverTest {
    @ClassRule
    public static final FlightServerTestRule FLIGHT_SERVER_TEST_RULE;
    private static final MockFlightSqlProducer PRODUCER;
    private BufferAllocator allocator;
    private ArrowFlightJdbcConnectionPoolDataSource dataSource;

    @Before
    public void setUp() throws Exception {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
        this.dataSource = FLIGHT_SERVER_TEST_RULE.createConnectionPoolDataSource();
    }

    @After
    public void tearDown() throws Exception {
        Collection childAllocators = this.allocator.getChildAllocators();
        AutoCloseables.close((AutoCloseable[])childAllocators.toArray(new AutoCloseable[0]));
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.dataSource, this.allocator});
    }

    @Test
    public void testDriverIsRegisteredInDriverManager() throws Exception {
        Assertions.assertTrue((boolean)(DriverManager.getDriver("jdbc:arrow-flight://localhost:32010") instanceof ArrowFlightJdbcDriver));
        Assertions.assertTrue((boolean)(DriverManager.getDriver("jdbc:arrow-flight-sql://localhost:32010") instanceof ArrowFlightJdbcDriver));
    }

    @Test
    public void testShouldDeclineUrlWithUnsupportedPrefix() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        Assertions.assertNull((Object)driver.connect("jdbc:mysql://localhost:32010", this.dataSource.getProperties("flight", "flight123")));
    }

    @Test
    public void testShouldConnectWhenProvidedWithValidUrl() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        try (Connection connection = driver.connect("jdbc:arrow-flight://" + this.dataSource.getConfig().getHost() + ":" + this.dataSource.getConfig().getPort() + "?useEncryption=false", this.dataSource.getProperties(this.dataSource.getConfig().getUser(), this.dataSource.getConfig().getPassword()));){
            Assertions.assertTrue((boolean)connection.isValid(300));
        }
        connection = driver.connect("jdbc:arrow-flight-sql://" + this.dataSource.getConfig().getHost() + ":" + this.dataSource.getConfig().getPort() + "?useEncryption=false", this.dataSource.getProperties(this.dataSource.getConfig().getUser(), this.dataSource.getConfig().getPassword()));
        var3_3 = null;
        try {
            Assertions.assertTrue((boolean)connection.isValid(300));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (connection != null) {
                ArrowFlightJdbcDriverTest.$closeResource(var3_3, connection);
            }
        }
    }

    @Test
    public void testConnectWithInsensitiveCasePropertyKeys() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        try (Connection connection = driver.connect("jdbc:arrow-flight://" + this.dataSource.getConfig().getHost() + ":" + this.dataSource.getConfig().getPort() + "?UseEncryptIon=false", this.dataSource.getProperties(this.dataSource.getConfig().getUser(), this.dataSource.getConfig().getPassword()));){
            Assertions.assertTrue((boolean)connection.isValid(300));
        }
        connection = driver.connect("jdbc:arrow-flight-sql://" + this.dataSource.getConfig().getHost() + ":" + this.dataSource.getConfig().getPort() + "?UseEncryptIon=false", this.dataSource.getProperties(this.dataSource.getConfig().getUser(), this.dataSource.getConfig().getPassword()));
        var3_3 = null;
        try {
            Assertions.assertTrue((boolean)connection.isValid(300));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (connection != null) {
                ArrowFlightJdbcDriverTest.$closeResource(var3_3, connection);
            }
        }
    }

    @Test
    public void testConnectWithInsensitiveCasePropertyKeys2() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        Properties properties = this.dataSource.getProperties(this.dataSource.getConfig().getUser(), this.dataSource.getConfig().getPassword());
        properties.put("UseEncryptIon", "false");
        try (Connection connection = driver.connect("jdbc:arrow-flight://" + this.dataSource.getConfig().getHost() + ":" + this.dataSource.getConfig().getPort(), properties);){
            Assertions.assertTrue((boolean)connection.isValid(300));
        }
        connection = driver.connect("jdbc:arrow-flight-sql://" + this.dataSource.getConfig().getHost() + ":" + this.dataSource.getConfig().getPort(), properties);
        var4_4 = null;
        try {
            Assertions.assertTrue((boolean)connection.isValid(300));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (connection != null) {
                ArrowFlightJdbcDriverTest.$closeResource(var4_4, connection);
            }
        }
    }

    @Test(expected=SQLException.class)
    public void testShouldThrowExceptionWhenAttemptingToConnectToMalformedUrl() throws SQLException {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        String malformedUri = "yes:??/chainsaw.i=T333";
        driver.connect("yes:??/chainsaw.i=T333", this.dataSource.getProperties("flight", "flight123"));
    }

    @Test(expected=SQLException.class)
    public void testShouldThrowExceptionWhenAttemptingToConnectToUrlNoPrefix() throws SQLException {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        String malformedUri = "localhost:32010";
        driver.connect("localhost:32010", this.dataSource.getProperties(this.dataSource.getConfig().getUser(), this.dataSource.getConfig().getPassword()));
    }

    @Test
    public void testShouldThrowExceptionWhenAttemptingToConnectToUrlNoPort() {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> this.lambda$testShouldThrowExceptionWhenAttemptingToConnectToUrlNoPort$0((Driver)driver));
        Assertions.assertTrue((boolean)e.getMessage().contains("URL must have a port"));
        e = (SQLException)Assertions.assertThrows(SQLException.class, () -> this.lambda$testShouldThrowExceptionWhenAttemptingToConnectToUrlNoPort$1((Driver)driver));
        Assertions.assertTrue((boolean)e.getMessage().contains("URL must have a port"));
    }

    @Test
    public void testShouldThrowExceptionWhenAttemptingToConnectToUrlNoHost() {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> this.lambda$testShouldThrowExceptionWhenAttemptingToConnectToUrlNoHost$2((Driver)driver));
        Assertions.assertTrue((boolean)e.getMessage().contains("URL must have a host"));
        e = (SQLException)Assertions.assertThrows(SQLException.class, () -> this.lambda$testShouldThrowExceptionWhenAttemptingToConnectToUrlNoHost$3((Driver)driver));
        Assertions.assertTrue((boolean)e.getMessage().contains("URL must have a host"));
    }

    @Test
    public void testDriverUrlParsingMechanismShouldReturnTheDesiredArgsFromUrl() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        Map parsedArgs = (Map)driver.getUrlsArgs("jdbc:arrow-flight-sql://localhost:2222/?key1=value1&key2=value2&a=b").orElseThrow(() -> new RuntimeException("URL was rejected"));
        Assertions.assertEquals((int)5, (int)parsedArgs.size());
        Assertions.assertEquals(parsedArgs.get(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName()), (Object)"localhost");
        Assertions.assertEquals(parsedArgs.get(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName()), (Object)2222);
        Assertions.assertEquals(parsedArgs.get("key1"), (Object)"value1");
        Assertions.assertEquals(parsedArgs.get("key2"), (Object)"value2");
        Assertions.assertEquals(parsedArgs.get("a"), (Object)"b");
    }

    @Test
    public void testDriverUrlParsingMechanismShouldReturnTheDesiredArgsFromUrlWithSemicolon() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        Map parsedArgs = (Map)driver.getUrlsArgs("jdbc:arrow-flight-sql://localhost:2222/;key1=value1;key2=value2;a=b").orElseThrow(() -> new RuntimeException("URL was rejected"));
        Assertions.assertEquals((int)5, (int)parsedArgs.size());
        Assertions.assertEquals(parsedArgs.get(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName()), (Object)"localhost");
        Assertions.assertEquals(parsedArgs.get(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName()), (Object)2222);
        Assertions.assertEquals(parsedArgs.get("key1"), (Object)"value1");
        Assertions.assertEquals(parsedArgs.get("key2"), (Object)"value2");
        Assertions.assertEquals(parsedArgs.get("a"), (Object)"b");
    }

    @Test
    public void testDriverUrlParsingMechanismShouldReturnTheDesiredArgsFromUrlWithOneSemicolon() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        Map parsedArgs = (Map)driver.getUrlsArgs("jdbc:arrow-flight-sql://localhost:2222/;key1=value1").orElseThrow(() -> new RuntimeException("URL was rejected"));
        Assertions.assertEquals((int)3, (int)parsedArgs.size());
        Assertions.assertEquals(parsedArgs.get(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName()), (Object)"localhost");
        Assertions.assertEquals(parsedArgs.get(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName()), (Object)2222);
        Assertions.assertEquals(parsedArgs.get("key1"), (Object)"value1");
    }

    @Test
    public void testDriverUrlParsingMechanismShouldReturnEmptyOptionalForUnknownScheme() throws SQLException {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        Assertions.assertFalse((boolean)driver.getUrlsArgs("jdbc:malformed-url-flight://localhost:2222").isPresent());
    }

    @Test
    public void testDriverUrlParsingMechanismShouldWorkWithIPAddress() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        Map parsedArgs = (Map)driver.getUrlsArgs("jdbc:arrow-flight-sql://0.0.0.0:2222").orElseThrow(() -> new RuntimeException("URL was rejected"));
        Assertions.assertEquals((int)2, (int)parsedArgs.size());
        Assertions.assertEquals(parsedArgs.get(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName()), (Object)"0.0.0.0");
        Assertions.assertEquals(parsedArgs.get(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName()), (Object)2222);
    }

    @Test
    public void testDriverUrlParsingMechanismShouldWorkWithEmbeddedEspecialCharacter() throws Exception {
        ArrowFlightJdbcDriver driver = new ArrowFlightJdbcDriver();
        Map parsedArgs = (Map)driver.getUrlsArgs("jdbc:arrow-flight-sql://0.0.0.0:2222?test1=test1value&test2%26continue=test2value&test3=test3value").orElseThrow(() -> new RuntimeException("URL was rejected"));
        Assertions.assertEquals((int)5, (int)parsedArgs.size());
        Assertions.assertEquals(parsedArgs.get(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName()), (Object)"0.0.0.0");
        Assertions.assertEquals(parsedArgs.get(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName()), (Object)2222);
        Assertions.assertEquals(parsedArgs.get("test1"), (Object)"test1value");
        Assertions.assertEquals(parsedArgs.get("test2&continue"), (Object)"test2value");
        Assertions.assertEquals(parsedArgs.get("test3"), (Object)"test3value");
    }

    private /* synthetic */ void lambda$testShouldThrowExceptionWhenAttemptingToConnectToUrlNoHost$3(Driver driver) throws Throwable {
        Properties properties = this.dataSource.getProperties(this.dataSource.getConfig().getUser(), this.dataSource.getConfig().getPassword());
        Connection conn = driver.connect("jdbc:arrow-flight-sql://32010:localhost", properties);
        conn.close();
    }

    private /* synthetic */ void lambda$testShouldThrowExceptionWhenAttemptingToConnectToUrlNoHost$2(Driver driver) throws Throwable {
        Properties properties = this.dataSource.getProperties(this.dataSource.getConfig().getUser(), this.dataSource.getConfig().getPassword());
        Connection conn = driver.connect("jdbc:arrow-flight://32010:localhost", properties);
        conn.close();
    }

    private /* synthetic */ void lambda$testShouldThrowExceptionWhenAttemptingToConnectToUrlNoPort$1(Driver driver) throws Throwable {
        Properties properties = this.dataSource.getProperties(this.dataSource.getConfig().getUser(), this.dataSource.getConfig().getPassword());
        Connection conn = driver.connect("jdbc:arrow-flight-sql://localhost", properties);
        conn.close();
    }

    private /* synthetic */ void lambda$testShouldThrowExceptionWhenAttemptingToConnectToUrlNoPort$0(Driver driver) throws Throwable {
        Properties properties = this.dataSource.getProperties(this.dataSource.getConfig().getUser(), this.dataSource.getConfig().getPassword());
        Connection conn = driver.connect("jdbc:arrow-flight://localhost", properties);
        conn.close();
    }

    static {
        PRODUCER = new MockFlightSqlProducer();
        UserPasswordAuthentication authentication = new UserPasswordAuthentication.Builder().user("user1", "pass1").user("user2", "pass2").build();
        FLIGHT_SERVER_TEST_RULE = new FlightServerTestRule.Builder().authentication(authentication).producer(PRODUCER).build();
    }
}

