/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import com.google.common.collect.ImmutableList;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcCursor;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.calcite.avatica.util.Cursor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ArrowFlightJdbcCursorTest {
    ArrowFlightJdbcCursor cursor;
    BufferAllocator allocator;

    @After
    public void cleanUp() {
        this.allocator.close();
        this.cursor.close();
    }

    @Test
    public void testBinaryVectorNullTrue() throws SQLException {
        VectorSchemaRoot root = this.getVectorSchemaRoot("Binary", (ArrowType)new ArrowType.Binary(), null);
        ((VarBinaryVector)root.getVector("Binary")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testDateVectorNullTrue() throws SQLException {
        VectorSchemaRoot root = this.getVectorSchemaRoot("Date", (ArrowType)new ArrowType.Date(DateUnit.DAY), null);
        ((DateDayVector)root.getVector("Date")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testDurationVectorNullTrue() throws SQLException {
        VectorSchemaRoot root = this.getVectorSchemaRoot("Duration", (ArrowType)new ArrowType.Duration(TimeUnit.MILLISECOND), null);
        ((DurationVector)root.getVector("Duration")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testDateInternalNullTrue() throws SQLException {
        VectorSchemaRoot root = this.getVectorSchemaRoot("Interval", (ArrowType)new ArrowType.Interval(IntervalUnit.DAY_TIME), null);
        ((IntervalDayVector)root.getVector("Interval")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testTimeStampVectorNullTrue() throws SQLException {
        VectorSchemaRoot root = this.getVectorSchemaRoot("TimeStamp", (ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, null), null);
        ((TimeStampMilliVector)root.getVector("TimeStamp")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testTimeVectorNullTrue() throws SQLException {
        VectorSchemaRoot root = this.getVectorSchemaRoot("Time", (ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32), null);
        ((TimeMilliVector)root.getVector("Time")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testFixedSizeListVectorNullTrue() throws SQLException {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.add(new Field("Null", new FieldType(true, (ArrowType)new ArrowType.Null(), null), null));
        VectorSchemaRoot root = this.getVectorSchemaRoot("FixedSizeList", (ArrowType)new ArrowType.FixedSizeList(10), fieldList);
        ((FixedSizeListVector)root.getVector("FixedSizeList")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testLargeListVectorNullTrue() throws SQLException {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.add(new Field("Null", new FieldType(true, (ArrowType)new ArrowType.Null(), null), null));
        VectorSchemaRoot root = this.getVectorSchemaRoot("LargeList", (ArrowType)new ArrowType.LargeList(), fieldList);
        ((LargeListVector)root.getVector("LargeList")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testListVectorNullTrue() throws SQLException {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.add(new Field("Null", new FieldType(true, (ArrowType)new ArrowType.Null(), null), null));
        VectorSchemaRoot root = this.getVectorSchemaRoot("List", (ArrowType)new ArrowType.List(), fieldList);
        ((ListVector)root.getVector("List")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testMapVectorNullTrue() throws SQLException {
        ArrayList<Field> structChildren = new ArrayList<Field>();
        structChildren.add(new Field("Key", new FieldType(false, (ArrowType)new ArrowType.Utf8(), null), null));
        structChildren.add(new Field("Value", new FieldType(false, (ArrowType)new ArrowType.Utf8(), null), null));
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.add(new Field("Struct", new FieldType(false, (ArrowType)new ArrowType.Struct(), null), structChildren));
        VectorSchemaRoot root = this.getVectorSchemaRoot("Map", (ArrowType)new ArrowType.Map(false), fieldList);
        ((MapVector)root.getVector("Map")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testStructVectorNullTrue() throws SQLException {
        VectorSchemaRoot root = this.getVectorSchemaRoot("Struct", (ArrowType)new ArrowType.Struct(), null);
        ((StructVector)root.getVector("Struct")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testBaseIntVectorNullTrue() throws SQLException {
        VectorSchemaRoot root = this.getVectorSchemaRoot("BaseInt", (ArrowType)new ArrowType.Int(32, false), null);
        ((UInt4Vector)root.getVector("BaseInt")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testBitVectorNullTrue() throws SQLException {
        VectorSchemaRoot root = this.getVectorSchemaRoot("Bit", (ArrowType)new ArrowType.Bool(), null);
        ((BitVector)root.getVector("Bit")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testDecimalVectorNullTrue() throws SQLException {
        VectorSchemaRoot root = this.getVectorSchemaRoot("Decimal", (ArrowType)new ArrowType.Decimal(2, 2, 128), null);
        ((DecimalVector)root.getVector("Decimal")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testFloat4VectorNullTrue() throws SQLException {
        VectorSchemaRoot root = this.getVectorSchemaRoot("Float4", (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), null);
        ((Float4Vector)root.getVector("Float4")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testFloat8VectorNullTrue() throws SQLException {
        VectorSchemaRoot root = this.getVectorSchemaRoot("Float8", (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), null);
        ((Float8Vector)root.getVector("Float8")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testVarCharVectorNullTrue() throws SQLException {
        VectorSchemaRoot root = this.getVectorSchemaRoot("VarChar", (ArrowType)new ArrowType.Utf8(), null);
        ((VarCharVector)root.getVector("VarChar")).setNull(0);
        this.testCursorWasNull(root);
    }

    @Test
    public void testNullVectorNullTrue() throws SQLException {
        VectorSchemaRoot root = this.getVectorSchemaRoot("Null", (ArrowType)new ArrowType.Null(), null);
        this.testCursorWasNull(root);
    }

    private VectorSchemaRoot getVectorSchemaRoot(String name, ArrowType arrowType, List<Field> children) {
        Schema schema = new Schema((Iterable)ImmutableList.of((Object)new Field(name, new FieldType(true, arrowType, null), children)));
        this.allocator = new RootAllocator(Long.MAX_VALUE);
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);
        root.allocateNew();
        return root;
    }

    private void testCursorWasNull(VectorSchemaRoot root) throws SQLException {
        root.setRowCount(1);
        this.cursor = new ArrowFlightJdbcCursor(root);
        this.cursor.next();
        List accessorList = this.cursor.createAccessors(null, null, null);
        ((Cursor.Accessor)accessorList.get(0)).getObject();
        Assert.assertTrue((boolean)this.cursor.wasNull());
        root.close();
    }
}

