/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.Connection;
import javax.sql.PooledConnection;
import org.apache.arrow.driver.jdbc.ArrowFlightConnection;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcConnectionPoolDataSource;
import org.apache.arrow.driver.jdbc.FlightServerTestRule;
import org.apache.arrow.driver.jdbc.authentication.UserPasswordAuthentication;
import org.apache.arrow.driver.jdbc.utils.ConnectionWrapper;
import org.apache.arrow.driver.jdbc.utils.MockFlightSqlProducer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class ArrowFlightJdbcConnectionPoolDataSourceTest {
    @ClassRule
    public static final FlightServerTestRule FLIGHT_SERVER_TEST_RULE;
    private static final MockFlightSqlProducer PRODUCER;
    private ArrowFlightJdbcConnectionPoolDataSource dataSource;

    @Before
    public void setUp() {
        this.dataSource = FLIGHT_SERVER_TEST_RULE.createConnectionPoolDataSource(false);
    }

    @After
    public void tearDown() throws Exception {
        this.dataSource.close();
    }

    @Test
    public void testShouldInnerConnectionIsClosedReturnCorrectly() throws Exception {
        PooledConnection pooledConnection = this.dataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        Assert.assertFalse((boolean)connection.isClosed());
        connection.close();
        Assert.assertTrue((boolean)connection.isClosed());
    }

    @Test
    public void testShouldInnerConnectionShouldIgnoreDoubleClose() throws Exception {
        PooledConnection pooledConnection = this.dataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        Assert.assertFalse((boolean)connection.isClosed());
        connection.close();
        Assert.assertTrue((boolean)connection.isClosed());
    }

    @Test
    public void testShouldInnerConnectionIsClosedReturnTrueIfPooledConnectionCloses() throws Exception {
        PooledConnection pooledConnection = this.dataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        Assert.assertFalse((boolean)connection.isClosed());
        pooledConnection.close();
        Assert.assertTrue((boolean)connection.isClosed());
    }

    @Test
    public void testShouldReuseConnectionsOnPool() throws Exception {
        PooledConnection pooledConnection = this.dataSource.getPooledConnection("user1", "pass1");
        ConnectionWrapper connection = (ConnectionWrapper)pooledConnection.getConnection();
        Assert.assertFalse((boolean)connection.isClosed());
        connection.close();
        Assert.assertTrue((boolean)connection.isClosed());
        Assert.assertFalse((boolean)((ArrowFlightConnection)connection.unwrap(ArrowFlightConnection.class)).isClosed());
        PooledConnection pooledConnection2 = this.dataSource.getPooledConnection("user1", "pass1");
        ConnectionWrapper connection2 = (ConnectionWrapper)pooledConnection2.getConnection();
        Assert.assertFalse((boolean)connection2.isClosed());
        connection2.close();
        Assert.assertTrue((boolean)connection2.isClosed());
        Assert.assertFalse((boolean)((ArrowFlightConnection)connection2.unwrap(ArrowFlightConnection.class)).isClosed());
        Assert.assertSame((Object)pooledConnection, (Object)pooledConnection2);
        Assert.assertNotSame((Object)connection, (Object)connection2);
        Assert.assertSame((Object)connection.unwrap(ArrowFlightConnection.class), (Object)connection2.unwrap(ArrowFlightConnection.class));
    }

    @Test
    public void testShouldNotMixConnectionsForDifferentUsers() throws Exception {
        PooledConnection pooledConnection = this.dataSource.getPooledConnection("user1", "pass1");
        ConnectionWrapper connection = (ConnectionWrapper)pooledConnection.getConnection();
        Assert.assertFalse((boolean)connection.isClosed());
        connection.close();
        Assert.assertTrue((boolean)connection.isClosed());
        Assert.assertFalse((boolean)((ArrowFlightConnection)connection.unwrap(ArrowFlightConnection.class)).isClosed());
        PooledConnection pooledConnection2 = this.dataSource.getPooledConnection("user2", "pass2");
        ConnectionWrapper connection2 = (ConnectionWrapper)pooledConnection2.getConnection();
        Assert.assertFalse((boolean)connection2.isClosed());
        connection2.close();
        Assert.assertTrue((boolean)connection2.isClosed());
        Assert.assertFalse((boolean)((ArrowFlightConnection)connection2.unwrap(ArrowFlightConnection.class)).isClosed());
        Assert.assertNotSame((Object)pooledConnection, (Object)pooledConnection2);
        Assert.assertNotSame((Object)connection, (Object)connection2);
        Assert.assertNotSame((Object)connection.unwrap(ArrowFlightConnection.class), (Object)connection2.unwrap(ArrowFlightConnection.class));
    }

    static {
        PRODUCER = new MockFlightSqlProducer();
        UserPasswordAuthentication authentication = new UserPasswordAuthentication.Builder().user("user1", "pass1").user("user2", "pass2").build();
        FLIGHT_SERVER_TEST_RULE = new FlightServerTestRule.Builder().authentication(authentication).producer(PRODUCER).build();
    }
}

