/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcArray;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.util.JsonStringArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ArrowFlightJdbcArrayTest {
    @Rule
    public RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    IntVector dataVector;

    @Before
    public void setup() {
        this.dataVector = this.rootAllocatorTestRule.createIntVector();
    }

    @After
    public void tearDown() {
        this.dataVector.close();
    }

    @Test
    public void testShouldGetBaseTypeNameReturnCorrectTypeName() {
        ArrowFlightJdbcArray arrowFlightJdbcArray = new ArrowFlightJdbcArray((FieldVector)this.dataVector, 0L, (long)this.dataVector.getValueCount());
        Assert.assertEquals((Object)"INTEGER", (Object)arrowFlightJdbcArray.getBaseTypeName());
    }

    @Test
    public void testShouldGetBaseTypeReturnCorrectType() {
        ArrowFlightJdbcArray arrowFlightJdbcArray = new ArrowFlightJdbcArray((FieldVector)this.dataVector, 0L, (long)this.dataVector.getValueCount());
        Assert.assertEquals((long)4L, (long)arrowFlightJdbcArray.getBaseType());
    }

    @Test
    public void testShouldGetArrayReturnValidArray() throws SQLException {
        ArrowFlightJdbcArray arrowFlightJdbcArray = new ArrowFlightJdbcArray((FieldVector)this.dataVector, 0L, (long)this.dataVector.getValueCount());
        Object[] array = (Object[])arrowFlightJdbcArray.getArray();
        Object[] expected = new Object[this.dataVector.getValueCount()];
        for (int i = 0; i < expected.length; ++i) {
            expected[i] = this.dataVector.getObject(i);
        }
        Assert.assertArrayEquals((Object[])array, (Object[])expected);
    }

    @Test
    public void testShouldGetArrayReturnValidArrayWithOffsets() throws SQLException {
        ArrowFlightJdbcArray arrowFlightJdbcArray = new ArrowFlightJdbcArray((FieldVector)this.dataVector, 0L, (long)this.dataVector.getValueCount());
        Object[] array = (Object[])arrowFlightJdbcArray.getArray(1L, 5);
        Object[] expected = new Object[5];
        for (int i = 0; i < expected.length; ++i) {
            expected[i] = this.dataVector.getObject(i + 1);
        }
        Assert.assertArrayEquals((Object[])array, (Object[])expected);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testShouldGetArrayWithOffsetsThrowArrayIndexOutOfBoundsException() throws SQLException {
        ArrowFlightJdbcArray arrowFlightJdbcArray = new ArrowFlightJdbcArray((FieldVector)this.dataVector, 0L, (long)this.dataVector.getValueCount());
        arrowFlightJdbcArray.getArray(0L, this.dataVector.getValueCount() + 1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testShouldGetArrayWithMapNotBeSupported() throws SQLException {
        ArrowFlightJdbcArray arrowFlightJdbcArray = new ArrowFlightJdbcArray((FieldVector)this.dataVector, 0L, (long)this.dataVector.getValueCount());
        HashMap map = new HashMap();
        arrowFlightJdbcArray.getArray(map);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testShouldGetArrayWithOffsetsAndMapNotBeSupported() throws SQLException {
        ArrowFlightJdbcArray arrowFlightJdbcArray = new ArrowFlightJdbcArray((FieldVector)this.dataVector, 0L, (long)this.dataVector.getValueCount());
        HashMap map = new HashMap();
        arrowFlightJdbcArray.getArray(0L, 5, map);
    }

    @Test
    public void testShouldGetResultSetReturnValidResultSet() throws SQLException {
        ArrowFlightJdbcArray arrowFlightJdbcArray = new ArrowFlightJdbcArray((FieldVector)this.dataVector, 0L, (long)this.dataVector.getValueCount());
        try (ResultSet resultSet = arrowFlightJdbcArray.getResultSet();){
            int count = 0;
            while (resultSet.next()) {
                Assert.assertEquals((Object)resultSet.getInt(1), (Object)this.dataVector.getObject(count));
                ++count;
            }
        }
    }

    @Test
    public void testShouldGetResultSetReturnValidResultSetWithOffsets() throws SQLException {
        ArrowFlightJdbcArray arrowFlightJdbcArray = new ArrowFlightJdbcArray((FieldVector)this.dataVector, 0L, (long)this.dataVector.getValueCount());
        try (ResultSet resultSet = arrowFlightJdbcArray.getResultSet(3L, 5);){
            int count = 0;
            while (resultSet.next()) {
                Assert.assertEquals((Object)resultSet.getInt(1), (Object)this.dataVector.getObject(count + 3));
                ++count;
            }
            Assert.assertEquals((long)5L, (long)count);
        }
    }

    @Test
    public void testToString() throws SQLException {
        ArrowFlightJdbcArray arrowFlightJdbcArray = new ArrowFlightJdbcArray((FieldVector)this.dataVector, 0L, (long)this.dataVector.getValueCount());
        JsonStringArrayList array = new JsonStringArrayList();
        array.addAll(Arrays.asList((Object[])arrowFlightJdbcArray.getArray()));
        Assert.assertEquals((Object)array.toString(), (Object)arrowFlightJdbcArray.toString());
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testShouldGetResultSetWithMapNotBeSupported() throws SQLException {
        ArrowFlightJdbcArray arrowFlightJdbcArray = new ArrowFlightJdbcArray((FieldVector)this.dataVector, 0L, (long)this.dataVector.getValueCount());
        HashMap map = new HashMap();
        arrowFlightJdbcArray.getResultSet(map);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testShouldGetResultSetWithOffsetsAndMapNotBeSupported() throws SQLException {
        ArrowFlightJdbcArray arrowFlightJdbcArray = new ArrowFlightJdbcArray((FieldVector)this.dataVector, 0L, (long)this.dataVector.getValueCount());
        HashMap map = new HashMap();
        arrowFlightJdbcArray.getResultSet(0L, 5, map);
    }
}

