/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.arrow.driver.jdbc.ArrowDatabaseMetadata;
import org.apache.arrow.driver.jdbc.FlightServerTestRule;
import org.apache.arrow.driver.jdbc.utils.MockFlightSqlProducer;
import org.apache.arrow.driver.jdbc.utils.ResultSetTestUtils;
import org.apache.arrow.driver.jdbc.utils.ThrowableAssertionUtils;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.sql.FlightSqlProducer;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.hamcrest.CoreMatchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class ArrowDatabaseMetadataTest {
    public static final boolean EXPECTED_MAX_ROW_SIZE_INCLUDES_BLOBS = false;
    private static final MockFlightSqlProducer FLIGHT_SQL_PRODUCER;
    private static final MockFlightSqlProducer FLIGHT_SQL_PRODUCER_EMPTY_SQLINFO;
    @ClassRule
    public static final FlightServerTestRule FLIGHT_SERVER_TEST_RULE;
    @ClassRule
    public static final FlightServerTestRule FLIGHT_SERVER_EMPTY_SQLINFO_TEST_RULE;
    private static final int ROW_COUNT = 10;
    private static final List<List<Object>> EXPECTED_GET_CATALOGS_RESULTS;
    private static final List<List<Object>> EXPECTED_GET_TABLE_TYPES_RESULTS;
    private static final List<List<Object>> EXPECTED_GET_TABLES_RESULTS;
    private static final List<List<Object>> EXPECTED_GET_SCHEMAS_RESULTS;
    private static final List<List<Object>> EXPECTED_GET_EXPORTED_AND_IMPORTED_KEYS_RESULTS;
    private static final List<List<Object>> EXPECTED_CROSS_REFERENCE_RESULTS;
    private static final List<List<Object>> EXPECTED_PRIMARY_KEYS_RESULTS;
    private static final List<String> FIELDS_GET_IMPORTED_EXPORTED_KEYS;
    private static final List<String> FIELDS_GET_CROSS_REFERENCE;
    private static final String TARGET_TABLE = "TARGET_TABLE";
    private static final String TARGET_FOREIGN_TABLE = "FOREIGN_TABLE";
    private static final String EXPECTED_DATABASE_PRODUCT_NAME = "Test Server Name";
    private static final String EXPECTED_DATABASE_PRODUCT_VERSION = "v0.0.1-alpha";
    private static final String EXPECTED_IDENTIFIER_QUOTE_STRING = "\"";
    private static final boolean EXPECTED_IS_READ_ONLY = true;
    private static final String EXPECTED_SQL_KEYWORDS = "ADD, ADD CONSTRAINT, ALTER, ALTER TABLE, ANY, USER, TABLE";
    private static final String EXPECTED_NUMERIC_FUNCTIONS = "ABS(), ACOS(), ASIN(), ATAN(), CEIL(), CEILING(), COT()";
    private static final String EXPECTED_STRING_FUNCTIONS = "ASCII, CHAR, CHARINDEX, CONCAT, CONCAT_WS, FORMAT, LEFT";
    private static final String EXPECTED_SYSTEM_FUNCTIONS = "CAST, CONVERT, CHOOSE, ISNULL, IS_NUMERIC, IIF, TRY_CAST";
    private static final String EXPECTED_TIME_DATE_FUNCTIONS = "GETDATE(), DATEPART(), DATEADD(), DATEDIFF()";
    private static final String EXPECTED_SEARCH_STRING_ESCAPE = "\\";
    private static final String EXPECTED_EXTRA_NAME_CHARACTERS = "";
    private static final boolean EXPECTED_SUPPORTS_COLUMN_ALIASING = true;
    private static final boolean EXPECTED_NULL_PLUS_NULL_IS_NULL = true;
    private static final boolean EXPECTED_SQL_SUPPORTS_CONVERT = true;
    private static final boolean EXPECTED_INVALID_SQL_SUPPORTS_CONVERT = false;
    private static final boolean EXPECTED_SUPPORTS_TABLE_CORRELATION_NAMES = true;
    private static final boolean EXPECTED_SUPPORTS_DIFFERENT_TABLE_CORRELATION_NAMES = false;
    private static final boolean EXPECTED_EXPRESSIONS_IN_ORDER_BY = true;
    private static final boolean EXPECTED_SUPPORTS_ORDER_BY_UNRELATED = true;
    private static final boolean EXPECTED_SUPPORTS_GROUP_BY = true;
    private static final boolean EXPECTED_SUPPORTS_GROUP_BY_UNRELATED = true;
    private static final boolean EXPECTED_SUPPORTS_LIKE_ESCAPE_CLAUSE = true;
    private static final boolean EXPECTED_NON_NULLABLE_COLUMNS = true;
    private static final boolean EXPECTED_MINIMUM_SQL_GRAMMAR = true;
    private static final boolean EXPECTED_CORE_SQL_GRAMMAR = true;
    private static final boolean EXPECTED_EXTEND_SQL_GRAMMAR = false;
    private static final boolean EXPECTED_ANSI92_ENTRY_LEVEL_SQL = true;
    private static final boolean EXPECTED_ANSI92_INTERMEDIATE_SQL = true;
    private static final boolean EXPECTED_ANSI92_FULL_SQL = false;
    private static final String EXPECTED_SCHEMA_TERM = "schema";
    private static final String EXPECTED_PROCEDURE_TERM = "procedure";
    private static final String EXPECTED_CATALOG_TERM = "catalog";
    private static final boolean EXPECTED_SUPPORTS_INTEGRITY_ENHANCEMENT_FACILITY = true;
    private static final boolean EXPECTED_SUPPORTS_OUTER_JOINS = true;
    private static final boolean EXPECTED_SUPPORTS_FULL_OUTER_JOINS = true;
    private static final boolean EXPECTED_SUPPORTS_LIMITED_JOINS = false;
    private static final boolean EXPECTED_CATALOG_AT_START = true;
    private static final boolean EXPECTED_SCHEMAS_IN_PROCEDURE_CALLS = true;
    private static final boolean EXPECTED_SCHEMAS_IN_INDEX_DEFINITIONS = true;
    private static final boolean EXPECTED_SCHEMAS_IN_PRIVILEGE_DEFINITIONS = false;
    private static final boolean EXPECTED_CATALOGS_IN_INDEX_DEFINITIONS = true;
    private static final boolean EXPECTED_CATALOGS_IN_PRIVILEGE_DEFINITIONS = false;
    private static final boolean EXPECTED_POSITIONED_DELETE = true;
    private static final boolean EXPECTED_POSITIONED_UPDATE = false;
    private static final boolean EXPECTED_TYPE_FORWARD_ONLY = true;
    private static final boolean EXPECTED_TYPE_SCROLL_INSENSITIVE = true;
    private static final boolean EXPECTED_TYPE_SCROLL_SENSITIVE = false;
    private static final boolean EXPECTED_SELECT_FOR_UPDATE_SUPPORTED = false;
    private static final boolean EXPECTED_STORED_PROCEDURES_SUPPORTED = false;
    private static final boolean EXPECTED_SUBQUERIES_IN_COMPARISON = true;
    private static final boolean EXPECTED_SUBQUERIES_IN_EXISTS = false;
    private static final boolean EXPECTED_SUBQUERIES_IN_INS = false;
    private static final boolean EXPECTED_SUBQUERIES_IN_QUANTIFIEDS = false;
    private static final FlightSql.SqlSupportedSubqueries[] EXPECTED_SUPPORTED_SUBQUERIES;
    private static final boolean EXPECTED_CORRELATED_SUBQUERIES_SUPPORTED = true;
    private static final boolean EXPECTED_SUPPORTS_UNION = true;
    private static final boolean EXPECTED_SUPPORTS_UNION_ALL = true;
    private static final int EXPECTED_MAX_BINARY_LITERAL_LENGTH = 0;
    private static final int EXPECTED_MAX_CHAR_LITERAL_LENGTH = 0;
    private static final int EXPECTED_MAX_COLUMN_NAME_LENGTH = 1024;
    private static final int EXPECTED_MAX_COLUMNS_IN_GROUP_BY = 0;
    private static final int EXPECTED_MAX_COLUMNS_IN_INDEX = 0;
    private static final int EXPECTED_MAX_COLUMNS_IN_ORDER_BY = 0;
    private static final int EXPECTED_MAX_COLUMNS_IN_SELECT = 0;
    private static final int EXPECTED_MAX_CONNECTIONS = 0;
    private static final int EXPECTED_MAX_CURSOR_NAME_LENGTH = 1024;
    private static final int EXPECTED_MAX_INDEX_LENGTH = 0;
    private static final int EXPECTED_SCHEMA_NAME_LENGTH = 1024;
    private static final int EXPECTED_MAX_PROCEDURE_NAME_LENGTH = 0;
    private static final int EXPECTED_MAX_CATALOG_NAME_LENGTH = 1024;
    private static final int EXPECTED_MAX_ROW_SIZE = 0;
    private static final int EXPECTED_MAX_STATEMENT_LENGTH = 0;
    private static final int EXPECTED_MAX_STATEMENTS = 0;
    private static final int EXPECTED_MAX_TABLE_NAME_LENGTH = 1024;
    private static final int EXPECTED_MAX_TABLES_IN_SELECT = 0;
    private static final int EXPECTED_MAX_USERNAME_LENGTH = 1024;
    private static final int EXPECTED_DEFAULT_TRANSACTION_ISOLATION = 0;
    private static final boolean EXPECTED_TRANSACTIONS_SUPPORTED = false;
    private static final boolean EXPECTED_TRANSACTION_NONE = false;
    private static final boolean EXPECTED_TRANSACTION_READ_UNCOMMITTED = false;
    private static final boolean EXPECTED_TRANSACTION_READ_COMMITTED = true;
    private static final boolean EXPECTED_TRANSACTION_REPEATABLE_READ = false;
    private static final boolean EXPECTED_TRANSACTION_SERIALIZABLE = true;
    private static final boolean EXPECTED_DATA_DEFINITION_CAUSES_TRANSACTION_COMMIT = true;
    private static final boolean EXPECTED_DATA_DEFINITIONS_IN_TRANSACTIONS_IGNORED = false;
    private static final boolean EXPECTED_BATCH_UPDATES_SUPPORTED = true;
    private static final boolean EXPECTED_SAVEPOINTS_SUPPORTED = false;
    private static final boolean EXPECTED_NAMED_PARAMETERS_SUPPORTED = false;
    private static final boolean EXPECTED_LOCATORS_UPDATE_COPY = true;
    private static final boolean EXPECTED_STORED_FUNCTIONS_USING_CALL_SYNTAX_SUPPORTED = false;
    private static final List<List<Object>> EXPECTED_GET_COLUMNS_RESULTS;
    private static Connection connection;
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    public final ResultSetTestUtils resultSetTestUtils = new ResultSetTestUtils(this.collector);

    @BeforeClass
    public static void setUpBeforeClass() throws SQLException {
        connection = FLIGHT_SERVER_TEST_RULE.getConnection(false);
        FlightSql.CommandGetCatalogs commandGetCatalogs = FlightSql.CommandGetCatalogs.getDefaultInstance();
        Consumer<FlightProducer.ServerStreamListener> commandGetCatalogsResultProducer = listener -> {
            try {
                RootAllocator allocator = new RootAllocator();
                Throwable throwable = null;
                try {
                    VectorSchemaRoot root = VectorSchemaRoot.create((Schema)FlightSqlProducer.Schemas.GET_CATALOGS_SCHEMA, (BufferAllocator)allocator);
                    Throwable throwable2 = null;
                    try {
                        VarCharVector catalogName = (VarCharVector)root.getVector("catalog_name");
                        IntStream.range(0, 10).forEach(i -> catalogName.setSafe(i, new Text(String.format("catalog #%d", i))));
                        root.setRowCount(10);
                        listener.start(root);
                        listener.putNext();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (root != null) {
                            ArrowDatabaseMetadataTest.$closeResource(throwable2, (AutoCloseable)root);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    ArrowDatabaseMetadataTest.$closeResource(throwable, (AutoCloseable)allocator);
                }
            }
            catch (Throwable throwable) {
                listener.error(throwable);
            }
            finally {
                listener.completed();
            }
        };
        FLIGHT_SQL_PRODUCER.addCatalogQuery((Message)commandGetCatalogs, commandGetCatalogsResultProducer);
        FlightSql.CommandGetTableTypes commandGetTableTypes = FlightSql.CommandGetTableTypes.getDefaultInstance();
        Consumer<FlightProducer.ServerStreamListener> commandGetTableTypesResultProducer = listener -> {
            try {
                RootAllocator allocator = new RootAllocator();
                Throwable throwable = null;
                try {
                    VectorSchemaRoot root = VectorSchemaRoot.create((Schema)FlightSqlProducer.Schemas.GET_TABLE_TYPES_SCHEMA, (BufferAllocator)allocator);
                    Throwable throwable2 = null;
                    try {
                        VarCharVector tableType = (VarCharVector)root.getVector("table_type");
                        IntStream.range(0, 10).forEach(i -> tableType.setSafe(i, new Text(String.format("table_type #%d", i))));
                        root.setRowCount(10);
                        listener.start(root);
                        listener.putNext();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (root != null) {
                            ArrowDatabaseMetadataTest.$closeResource(throwable2, (AutoCloseable)root);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    ArrowDatabaseMetadataTest.$closeResource(throwable, (AutoCloseable)allocator);
                }
            }
            catch (Throwable throwable) {
                listener.error(throwable);
            }
            finally {
                listener.completed();
            }
        };
        FLIGHT_SQL_PRODUCER.addCatalogQuery((Message)commandGetTableTypes, commandGetTableTypesResultProducer);
        FlightSql.CommandGetTables commandGetTables = FlightSql.CommandGetTables.getDefaultInstance();
        Consumer<FlightProducer.ServerStreamListener> commandGetTablesResultProducer = listener -> {
            try {
                RootAllocator allocator = new RootAllocator();
                Throwable throwable = null;
                try {
                    VectorSchemaRoot root = VectorSchemaRoot.create((Schema)FlightSqlProducer.Schemas.GET_TABLES_SCHEMA_NO_SCHEMA, (BufferAllocator)allocator);
                    Throwable throwable2 = null;
                    try {
                        VarCharVector catalogName = (VarCharVector)root.getVector("catalog_name");
                        VarCharVector schemaName = (VarCharVector)root.getVector("db_schema_name");
                        VarCharVector tableName = (VarCharVector)root.getVector("table_name");
                        VarCharVector tableType = (VarCharVector)root.getVector("table_type");
                        IntStream.range(0, 10).peek(i -> catalogName.setSafe(i, new Text(String.format("catalog_name #%d", i)))).peek(i -> schemaName.setSafe(i, new Text(String.format("db_schema_name #%d", i)))).peek(i -> tableName.setSafe(i, new Text(String.format("table_name #%d", i)))).forEach(i -> tableType.setSafe(i, new Text(String.format("table_type #%d", i))));
                        root.setRowCount(10);
                        listener.start(root);
                        listener.putNext();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (root != null) {
                            ArrowDatabaseMetadataTest.$closeResource(throwable2, (AutoCloseable)root);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    ArrowDatabaseMetadataTest.$closeResource(throwable, (AutoCloseable)allocator);
                }
            }
            catch (Throwable throwable) {
                listener.error(throwable);
            }
            finally {
                listener.completed();
            }
        };
        FLIGHT_SQL_PRODUCER.addCatalogQuery((Message)commandGetTables, commandGetTablesResultProducer);
        FlightSql.CommandGetTables commandGetTablesWithSchema = FlightSql.CommandGetTables.newBuilder().setIncludeSchema(true).build();
        Consumer<FlightProducer.ServerStreamListener> commandGetTablesWithSchemaResultProducer = listener -> {
            try {
                RootAllocator allocator = new RootAllocator();
                Throwable throwable = null;
                try {
                    VectorSchemaRoot root = VectorSchemaRoot.create((Schema)FlightSqlProducer.Schemas.GET_TABLES_SCHEMA, (BufferAllocator)allocator);
                    Throwable throwable2 = null;
                    try {
                        byte[] filledTableSchemaBytes = ByteString.copyFrom((ByteBuffer)MockFlightSqlProducer.serializeSchema(new Schema(Arrays.asList(Field.nullable((String)"column_1", (ArrowType)ArrowType.Decimal.createDecimal((int)5, (int)2, (Integer)128)), Field.nullable((String)"column_2", (ArrowType)new ArrowType.Timestamp(TimeUnit.NANOSECOND, "UTC")), Field.notNullable((String)"column_3", (ArrowType)Types.MinorType.INT.getType()))))).toByteArray();
                        VarCharVector catalogName = (VarCharVector)root.getVector("catalog_name");
                        VarCharVector schemaName = (VarCharVector)root.getVector("db_schema_name");
                        VarCharVector tableName = (VarCharVector)root.getVector("table_name");
                        VarCharVector tableType = (VarCharVector)root.getVector("table_type");
                        VarBinaryVector tableSchema = (VarBinaryVector)root.getVector("table_schema");
                        IntStream.range(0, 10).peek(i -> catalogName.setSafe(i, new Text(String.format("catalog_name #%d", i)))).peek(i -> schemaName.setSafe(i, new Text(String.format("db_schema_name #%d", i)))).peek(i -> tableName.setSafe(i, new Text(String.format("table_name%d", i)))).peek(i -> tableType.setSafe(i, new Text(String.format("table_type #%d", i)))).forEach(i -> tableSchema.setSafe(i, filledTableSchemaBytes));
                        root.setRowCount(10);
                        listener.start(root);
                        listener.putNext();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (root != null) {
                            ArrowDatabaseMetadataTest.$closeResource(throwable2, (AutoCloseable)root);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    ArrowDatabaseMetadataTest.$closeResource(throwable, (AutoCloseable)allocator);
                }
            }
            catch (Throwable throwable) {
                listener.error(throwable);
            }
            finally {
                listener.completed();
            }
        };
        FLIGHT_SQL_PRODUCER.addCatalogQuery((Message)commandGetTablesWithSchema, commandGetTablesWithSchemaResultProducer);
        FlightSql.CommandGetDbSchemas commandGetDbSchemas = FlightSql.CommandGetDbSchemas.getDefaultInstance();
        Consumer<FlightProducer.ServerStreamListener> commandGetSchemasResultProducer = listener -> {
            try {
                RootAllocator allocator = new RootAllocator();
                Throwable throwable = null;
                try {
                    VectorSchemaRoot root = VectorSchemaRoot.create((Schema)FlightSqlProducer.Schemas.GET_SCHEMAS_SCHEMA, (BufferAllocator)allocator);
                    Throwable throwable2 = null;
                    try {
                        VarCharVector catalogName = (VarCharVector)root.getVector("catalog_name");
                        VarCharVector schemaName = (VarCharVector)root.getVector("db_schema_name");
                        IntStream.range(0, 10).peek(i -> catalogName.setSafe(i, new Text(String.format("catalog_name #%d", i)))).forEach(i -> schemaName.setSafe(i, new Text(String.format("db_schema_name #%d", i))));
                        root.setRowCount(10);
                        listener.start(root);
                        listener.putNext();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (root != null) {
                            ArrowDatabaseMetadataTest.$closeResource(throwable2, (AutoCloseable)root);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    ArrowDatabaseMetadataTest.$closeResource(throwable, (AutoCloseable)allocator);
                }
            }
            catch (Throwable throwable) {
                listener.error(throwable);
            }
            finally {
                listener.completed();
            }
        };
        FLIGHT_SQL_PRODUCER.addCatalogQuery((Message)commandGetDbSchemas, commandGetSchemasResultProducer);
        FlightSql.CommandGetExportedKeys commandGetExportedKeys = FlightSql.CommandGetExportedKeys.newBuilder().setTable(TARGET_TABLE).build();
        FlightSql.CommandGetImportedKeys commandGetImportedKeys = FlightSql.CommandGetImportedKeys.newBuilder().setTable(TARGET_TABLE).build();
        FlightSql.CommandGetCrossReference commandGetCrossReference = FlightSql.CommandGetCrossReference.newBuilder().setPkTable(TARGET_TABLE).setFkTable(TARGET_FOREIGN_TABLE).build();
        Consumer<FlightProducer.ServerStreamListener> commandGetExportedAndImportedKeysResultProducer = listener -> {
            try {
                RootAllocator allocator = new RootAllocator();
                Throwable throwable = null;
                try {
                    VectorSchemaRoot root = VectorSchemaRoot.create((Schema)FlightSqlProducer.Schemas.GET_IMPORTED_KEYS_SCHEMA, (BufferAllocator)allocator);
                    Throwable throwable2 = null;
                    try {
                        VarCharVector pkCatalogName = (VarCharVector)root.getVector("pk_catalog_name");
                        VarCharVector pkSchemaName = (VarCharVector)root.getVector("pk_db_schema_name");
                        VarCharVector pkTableName = (VarCharVector)root.getVector("pk_table_name");
                        VarCharVector pkColumnName = (VarCharVector)root.getVector("pk_column_name");
                        VarCharVector fkCatalogName = (VarCharVector)root.getVector("fk_catalog_name");
                        VarCharVector fkSchemaName = (VarCharVector)root.getVector("fk_db_schema_name");
                        VarCharVector fkTableName = (VarCharVector)root.getVector("fk_table_name");
                        VarCharVector fkColumnName = (VarCharVector)root.getVector("fk_column_name");
                        IntVector keySequence = (IntVector)root.getVector("key_sequence");
                        VarCharVector fkKeyName = (VarCharVector)root.getVector("fk_key_name");
                        VarCharVector pkKeyName = (VarCharVector)root.getVector("pk_key_name");
                        UInt1Vector updateRule = (UInt1Vector)root.getVector("update_rule");
                        UInt1Vector deleteRule = (UInt1Vector)root.getVector("delete_rule");
                        IntStream.range(0, 10).peek(i -> pkCatalogName.setSafe(i, new Text(String.format("pk_catalog_name #%d", i)))).peek(i -> pkSchemaName.setSafe(i, new Text(String.format("pk_db_schema_name #%d", i)))).peek(i -> pkTableName.setSafe(i, new Text(String.format("pk_table_name #%d", i)))).peek(i -> pkColumnName.setSafe(i, new Text(String.format("pk_column_name #%d", i)))).peek(i -> fkCatalogName.setSafe(i, new Text(String.format("fk_catalog_name #%d", i)))).peek(i -> fkSchemaName.setSafe(i, new Text(String.format("fk_db_schema_name #%d", i)))).peek(i -> fkTableName.setSafe(i, new Text(String.format("fk_table_name #%d", i)))).peek(i -> fkColumnName.setSafe(i, new Text(String.format("fk_column_name #%d", i)))).peek(i -> keySequence.setSafe(i, i)).peek(i -> fkKeyName.setSafe(i, new Text(String.format("fk_key_name #%d", i)))).peek(i -> pkKeyName.setSafe(i, new Text(String.format("pk_key_name #%d", i)))).peek(i -> updateRule.setSafe(i, i)).forEach(i -> deleteRule.setSafe(i, i));
                        root.setRowCount(10);
                        listener.start(root);
                        listener.putNext();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (root != null) {
                            ArrowDatabaseMetadataTest.$closeResource(throwable2, (AutoCloseable)root);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    ArrowDatabaseMetadataTest.$closeResource(throwable, (AutoCloseable)allocator);
                }
            }
            catch (Throwable throwable) {
                listener.error(throwable);
            }
            finally {
                listener.completed();
            }
        };
        FLIGHT_SQL_PRODUCER.addCatalogQuery((Message)commandGetExportedKeys, commandGetExportedAndImportedKeysResultProducer);
        FLIGHT_SQL_PRODUCER.addCatalogQuery((Message)commandGetImportedKeys, commandGetExportedAndImportedKeysResultProducer);
        FLIGHT_SQL_PRODUCER.addCatalogQuery((Message)commandGetCrossReference, commandGetExportedAndImportedKeysResultProducer);
        FlightSql.CommandGetPrimaryKeys commandGetPrimaryKeys = FlightSql.CommandGetPrimaryKeys.newBuilder().setTable(TARGET_TABLE).build();
        Consumer<FlightProducer.ServerStreamListener> commandGetPrimaryKeysResultProducer = listener -> {
            try {
                RootAllocator allocator = new RootAllocator();
                Throwable throwable = null;
                try {
                    VectorSchemaRoot root = VectorSchemaRoot.create((Schema)FlightSqlProducer.Schemas.GET_PRIMARY_KEYS_SCHEMA, (BufferAllocator)allocator);
                    Throwable throwable2 = null;
                    try {
                        VarCharVector catalogName = (VarCharVector)root.getVector("catalog_name");
                        VarCharVector schemaName = (VarCharVector)root.getVector("db_schema_name");
                        VarCharVector tableName = (VarCharVector)root.getVector("table_name");
                        VarCharVector columnName = (VarCharVector)root.getVector("column_name");
                        IntVector keySequence = (IntVector)root.getVector("key_sequence");
                        VarCharVector keyName = (VarCharVector)root.getVector("key_name");
                        IntStream.range(0, 10).peek(i -> catalogName.setSafe(i, new Text(String.format("catalog_name #%d", i)))).peek(i -> schemaName.setSafe(i, new Text(String.format("db_schema_name #%d", i)))).peek(i -> tableName.setSafe(i, new Text(String.format("table_name #%d", i)))).peek(i -> columnName.setSafe(i, new Text(String.format("column_name #%d", i)))).peek(i -> keySequence.setSafe(i, i)).forEach(i -> keyName.setSafe(i, new Text(String.format("key_name #%d", i))));
                        root.setRowCount(10);
                        listener.start(root);
                        listener.putNext();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (root != null) {
                            ArrowDatabaseMetadataTest.$closeResource(throwable2, (AutoCloseable)root);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    ArrowDatabaseMetadataTest.$closeResource(throwable, (AutoCloseable)allocator);
                }
            }
            catch (Throwable throwable) {
                listener.error(throwable);
            }
            finally {
                listener.completed();
            }
        };
        FLIGHT_SQL_PRODUCER.addCatalogQuery((Message)commandGetPrimaryKeys, commandGetPrimaryKeysResultProducer);
        FLIGHT_SQL_PRODUCER.getSqlInfoBuilder().withSqlOuterJoinSupportLevel(new FlightSql.SqlOuterJoinsSupportLevel[]{FlightSql.SqlOuterJoinsSupportLevel.SQL_FULL_OUTER_JOINS}).withFlightSqlServerName(EXPECTED_DATABASE_PRODUCT_NAME).withFlightSqlServerVersion(EXPECTED_DATABASE_PRODUCT_VERSION).withSqlIdentifierQuoteChar(EXPECTED_IDENTIFIER_QUOTE_STRING).withFlightSqlServerReadOnly(true).withSqlKeywords(EXPECTED_SQL_KEYWORDS.split("\\s*,\\s*")).withSqlNumericFunctions(EXPECTED_NUMERIC_FUNCTIONS.split("\\s*,\\s*")).withSqlStringFunctions(EXPECTED_STRING_FUNCTIONS.split("\\s*,\\s*")).withSqlSystemFunctions(EXPECTED_SYSTEM_FUNCTIONS.split("\\s*,\\s*")).withSqlDatetimeFunctions(EXPECTED_TIME_DATE_FUNCTIONS.split("\\s*,\\s*")).withSqlSearchStringEscape(EXPECTED_SEARCH_STRING_ESCAPE).withSqlExtraNameCharacters(EXPECTED_EXTRA_NAME_CHARACTERS).withSqlSupportsColumnAliasing(true).withSqlNullPlusNullIsNull(true).withSqlSupportsConvert((Map)ImmutableMap.of((Object)2, Arrays.asList(7, 0))).withSqlSupportsTableCorrelationNames(true).withSqlSupportsDifferentTableCorrelationNames(false).withSqlSupportsExpressionsInOrderBy(true).withSqlSupportsOrderByUnrelated(true).withSqlSupportedGroupBy(new FlightSql.SqlSupportedGroupBy[]{FlightSql.SqlSupportedGroupBy.SQL_GROUP_BY_UNRELATED}).withSqlSupportsLikeEscapeClause(true).withSqlSupportsNonNullableColumns(true).withSqlSupportedGrammar(new FlightSql.SupportedSqlGrammar[]{FlightSql.SupportedSqlGrammar.SQL_CORE_GRAMMAR, FlightSql.SupportedSqlGrammar.SQL_MINIMUM_GRAMMAR}).withSqlAnsi92SupportedLevel(new FlightSql.SupportedAnsi92SqlGrammarLevel[]{FlightSql.SupportedAnsi92SqlGrammarLevel.ANSI92_ENTRY_SQL, FlightSql.SupportedAnsi92SqlGrammarLevel.ANSI92_INTERMEDIATE_SQL}).withSqlSupportsIntegrityEnhancementFacility(true).withSqlSchemaTerm(EXPECTED_SCHEMA_TERM).withSqlCatalogTerm(EXPECTED_CATALOG_TERM).withSqlProcedureTerm(EXPECTED_PROCEDURE_TERM).withSqlCatalogAtStart(true).withSqlSchemasSupportedActions(new FlightSql.SqlSupportedElementActions[]{FlightSql.SqlSupportedElementActions.SQL_ELEMENT_IN_PROCEDURE_CALLS, FlightSql.SqlSupportedElementActions.SQL_ELEMENT_IN_INDEX_DEFINITIONS}).withSqlCatalogsSupportedActions(new FlightSql.SqlSupportedElementActions[]{FlightSql.SqlSupportedElementActions.SQL_ELEMENT_IN_INDEX_DEFINITIONS}).withSqlSupportedPositionedCommands(new FlightSql.SqlSupportedPositionedCommands[]{FlightSql.SqlSupportedPositionedCommands.SQL_POSITIONED_DELETE}).withSqlSelectForUpdateSupported(false).withSqlStoredProceduresSupported(false).withSqlSubQueriesSupported(EXPECTED_SUPPORTED_SUBQUERIES).withSqlCorrelatedSubqueriesSupported(true).withSqlSupportedUnions(new FlightSql.SqlSupportedUnions[]{FlightSql.SqlSupportedUnions.SQL_UNION_ALL}).withSqlMaxBinaryLiteralLength(0L).withSqlMaxCharLiteralLength(0L).withSqlMaxColumnNameLength(1024L).withSqlMaxColumnsInGroupBy(0L).withSqlMaxColumnsInIndex(0L).withSqlMaxColumnsInOrderBy(0L).withSqlMaxColumnsInSelect(0L).withSqlMaxConnections(0L).withSqlMaxCursorNameLength(1024L).withSqlMaxIndexLength(0L).withSqlDbSchemaNameLength(1024L).withSqlMaxProcedureNameLength(0L).withSqlMaxCatalogNameLength(1024L).withSqlMaxRowSize(0L).withSqlMaxRowSizeIncludesBlobs(false).withSqlMaxStatementLength(0L).withSqlMaxStatements(0L).withSqlMaxTableNameLength(1024L).withSqlMaxTablesInSelect(0L).withSqlMaxUsernameLength(1024L).withSqlDefaultTransactionIsolation(0L).withSqlTransactionsSupported(false).withSqlSupportedTransactionsIsolationLevels(new FlightSql.SqlTransactionIsolationLevel[]{FlightSql.SqlTransactionIsolationLevel.SQL_TRANSACTION_SERIALIZABLE, FlightSql.SqlTransactionIsolationLevel.SQL_TRANSACTION_READ_COMMITTED}).withSqlDataDefinitionCausesTransactionCommit(true).withSqlDataDefinitionsInTransactionsIgnored(false).withSqlSupportedResultSetTypes(new FlightSql.SqlSupportedResultSetType[]{FlightSql.SqlSupportedResultSetType.SQL_RESULT_SET_TYPE_FORWARD_ONLY, FlightSql.SqlSupportedResultSetType.SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE}).withSqlBatchUpdatesSupported(true).withSqlSavepointsSupported(false).withSqlNamedParametersSupported(false).withSqlLocatorsUpdateCopy(true).withSqlStoredFunctionsUsingCallSyntaxSupported(false);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{connection, FLIGHT_SQL_PRODUCER, FLIGHT_SQL_PRODUCER_EMPTY_SQLINFO});
    }

    @Test
    public void testGetCatalogsCanBeAccessedByIndices() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getCatalogs();){
            this.resultSetTestUtils.testData(resultSet, EXPECTED_GET_CATALOGS_RESULTS);
        }
    }

    @Test
    public void testGetCatalogsCanBeAccessedByNames() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getCatalogs();){
            this.resultSetTestUtils.testData(resultSet, Collections.singletonList("TABLE_CAT"), EXPECTED_GET_CATALOGS_RESULTS);
        }
    }

    @Test
    public void testTableTypesCanBeAccessedByIndices() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTableTypes();){
            this.resultSetTestUtils.testData(resultSet, EXPECTED_GET_TABLE_TYPES_RESULTS);
        }
    }

    @Test
    public void testTableTypesCanBeAccessedByNames() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTableTypes();){
            this.resultSetTestUtils.testData(resultSet, Collections.singletonList("TABLE_TYPE"), EXPECTED_GET_TABLE_TYPES_RESULTS);
        }
    }

    @Test
    public void testGetTablesCanBeAccessedByIndices() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTables(null, null, null, null);){
            this.resultSetTestUtils.testData(resultSet, EXPECTED_GET_TABLES_RESULTS);
        }
    }

    @Test
    public void testGetTablesCanBeAccessedByNames() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTables(null, null, null, null);){
            this.resultSetTestUtils.testData(resultSet, (List<String>)ImmutableList.of((Object)"TABLE_CAT", (Object)"TABLE_SCHEM", (Object)"TABLE_NAME", (Object)"TABLE_TYPE", (Object)"REMARKS", (Object)"TYPE_CAT", (Object)"TYPE_SCHEM", (Object)"TYPE_NAME", (Object)"SELF_REFERENCING_COL_NAME", (Object)"REF_GENERATION"), EXPECTED_GET_TABLES_RESULTS);
        }
    }

    @Test
    public void testGetSchemasCanBeAccessedByIndices() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getSchemas();){
            this.resultSetTestUtils.testData(resultSet, EXPECTED_GET_SCHEMAS_RESULTS);
        }
    }

    @Test
    public void testGetSchemasCanBeAccessedByNames() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getSchemas();){
            this.resultSetTestUtils.testData(resultSet, (List<String>)ImmutableList.of((Object)"TABLE_SCHEM", (Object)"TABLE_CATALOG"), EXPECTED_GET_SCHEMAS_RESULTS);
        }
    }

    @Test
    public void testGetExportedKeysCanBeAccessedByIndices() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getExportedKeys(null, null, TARGET_TABLE);){
            this.resultSetTestUtils.testData(resultSet, EXPECTED_GET_EXPORTED_AND_IMPORTED_KEYS_RESULTS);
        }
    }

    @Test
    public void testGetExportedKeysCanBeAccessedByNames() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getExportedKeys(null, null, TARGET_TABLE);){
            this.resultSetTestUtils.testData(resultSet, FIELDS_GET_IMPORTED_EXPORTED_KEYS, EXPECTED_GET_EXPORTED_AND_IMPORTED_KEYS_RESULTS);
        }
    }

    @Test
    public void testGetImportedKeysCanBeAccessedByIndices() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getImportedKeys(null, null, TARGET_TABLE);){
            this.resultSetTestUtils.testData(resultSet, EXPECTED_GET_EXPORTED_AND_IMPORTED_KEYS_RESULTS);
        }
    }

    @Test
    public void testGetImportedKeysCanBeAccessedByNames() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getImportedKeys(null, null, TARGET_TABLE);){
            this.resultSetTestUtils.testData(resultSet, FIELDS_GET_IMPORTED_EXPORTED_KEYS, EXPECTED_GET_EXPORTED_AND_IMPORTED_KEYS_RESULTS);
        }
    }

    @Test
    public void testGetCrossReferenceCanBeAccessedByIndices() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getCrossReference(null, null, TARGET_TABLE, null, null, TARGET_FOREIGN_TABLE);){
            this.resultSetTestUtils.testData(resultSet, EXPECTED_CROSS_REFERENCE_RESULTS);
        }
    }

    @Test
    public void testGetGetCrossReferenceCanBeAccessedByNames() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getCrossReference(null, null, TARGET_TABLE, null, null, TARGET_FOREIGN_TABLE);){
            this.resultSetTestUtils.testData(resultSet, FIELDS_GET_CROSS_REFERENCE, EXPECTED_CROSS_REFERENCE_RESULTS);
        }
    }

    @Test
    public void testPrimaryKeysCanBeAccessedByIndices() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(null, null, TARGET_TABLE);){
            this.resultSetTestUtils.testData(resultSet, EXPECTED_PRIMARY_KEYS_RESULTS);
        }
    }

    @Test
    public void testPrimaryKeysCanBeAccessedByNames() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(null, null, TARGET_TABLE);){
            this.resultSetTestUtils.testData(resultSet, (List<String>)ImmutableList.of((Object)"TABLE_CAT", (Object)"TABLE_SCHEM", (Object)"TABLE_NAME", (Object)"COLUMN_NAME", (Object)"KEY_SEQ", (Object)"PK_NAME"), EXPECTED_PRIMARY_KEYS_RESULTS);
        }
    }

    @Test
    public void testGetColumnsCanBeAccessedByIndices() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getColumns(null, null, null, null);){
            this.resultSetTestUtils.testData(resultSet, EXPECTED_GET_COLUMNS_RESULTS);
        }
    }

    @Test
    public void testGetColumnsCanByIndicesFilteringColumnNames() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getColumns(null, null, null, "column_1");){
            this.resultSetTestUtils.testData(resultSet, EXPECTED_GET_COLUMNS_RESULTS.stream().filter(insideList -> Objects.equals(insideList.get(3), "column_1")).collect(Collectors.toList()));
        }
    }

    @Test
    public void testGetSqlInfo() throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        this.collector.checkThat((Object)metaData.getDatabaseProductName(), CoreMatchers.is((Object)EXPECTED_DATABASE_PRODUCT_NAME));
        this.collector.checkThat((Object)metaData.getDatabaseProductVersion(), CoreMatchers.is((Object)EXPECTED_DATABASE_PRODUCT_VERSION));
        this.collector.checkThat((Object)metaData.getIdentifierQuoteString(), CoreMatchers.is((Object)EXPECTED_IDENTIFIER_QUOTE_STRING));
        this.collector.checkThat((Object)metaData.isReadOnly(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.getSQLKeywords(), CoreMatchers.is((Object)EXPECTED_SQL_KEYWORDS));
        this.collector.checkThat((Object)metaData.getNumericFunctions(), CoreMatchers.is((Object)EXPECTED_NUMERIC_FUNCTIONS));
        this.collector.checkThat((Object)metaData.getStringFunctions(), CoreMatchers.is((Object)EXPECTED_STRING_FUNCTIONS));
        this.collector.checkThat((Object)metaData.getSystemFunctions(), CoreMatchers.is((Object)EXPECTED_SYSTEM_FUNCTIONS));
        this.collector.checkThat((Object)metaData.getTimeDateFunctions(), CoreMatchers.is((Object)EXPECTED_TIME_DATE_FUNCTIONS));
        this.collector.checkThat((Object)metaData.getSearchStringEscape(), CoreMatchers.is((Object)EXPECTED_SEARCH_STRING_ESCAPE));
        this.collector.checkThat((Object)metaData.getExtraNameCharacters(), CoreMatchers.is((Object)EXPECTED_EXTRA_NAME_CHARACTERS));
        this.collector.checkThat((Object)metaData.supportsConvert(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsConvert(-7, 4), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsConvert(-7, -5), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsConvert(-5, 4), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsConvert(2000, 4), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsTableCorrelationNames(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsExpressionsInOrderBy(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsOrderByUnrelated(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsGroupBy(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsGroupByUnrelated(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsLikeEscapeClause(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsNonNullableColumns(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsMinimumSQLGrammar(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsCoreSQLGrammar(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsExtendedSQLGrammar(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsANSI92EntryLevelSQL(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsANSI92IntermediateSQL(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsANSI92FullSQL(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsOuterJoins(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsFullOuterJoins(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsLimitedOuterJoins(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.getSchemaTerm(), CoreMatchers.is((Object)EXPECTED_SCHEMA_TERM));
        this.collector.checkThat((Object)metaData.getProcedureTerm(), CoreMatchers.is((Object)EXPECTED_PROCEDURE_TERM));
        this.collector.checkThat((Object)metaData.getCatalogTerm(), CoreMatchers.is((Object)EXPECTED_CATALOG_TERM));
        this.collector.checkThat((Object)metaData.isCatalogAtStart(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsSchemasInProcedureCalls(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsSchemasInIndexDefinitions(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsCatalogsInIndexDefinitions(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsPositionedDelete(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsPositionedUpdate(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsResultSetType(1003), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsSelectForUpdate(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsStoredProcedures(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsSubqueriesInComparisons(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsSubqueriesInExists(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsSubqueriesInIns(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsSubqueriesInQuantifieds(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsCorrelatedSubqueries(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsUnion(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsUnionAll(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.getMaxBinaryLiteralLength(), CoreMatchers.is((Object)0));
        this.collector.checkThat((Object)metaData.getMaxCharLiteralLength(), CoreMatchers.is((Object)0));
        this.collector.checkThat((Object)metaData.getMaxColumnsInGroupBy(), CoreMatchers.is((Object)0));
        this.collector.checkThat((Object)metaData.getMaxColumnsInIndex(), CoreMatchers.is((Object)0));
        this.collector.checkThat((Object)metaData.getMaxColumnsInOrderBy(), CoreMatchers.is((Object)0));
        this.collector.checkThat((Object)metaData.getMaxColumnsInSelect(), CoreMatchers.is((Object)0));
        this.collector.checkThat((Object)metaData.getMaxConnections(), CoreMatchers.is((Object)0));
        this.collector.checkThat((Object)metaData.getMaxCursorNameLength(), CoreMatchers.is((Object)1024));
        this.collector.checkThat((Object)metaData.getMaxIndexLength(), CoreMatchers.is((Object)0));
        this.collector.checkThat((Object)metaData.getMaxSchemaNameLength(), CoreMatchers.is((Object)1024));
        this.collector.checkThat((Object)metaData.getMaxProcedureNameLength(), CoreMatchers.is((Object)0));
        this.collector.checkThat((Object)metaData.getMaxCatalogNameLength(), CoreMatchers.is((Object)1024));
        this.collector.checkThat((Object)metaData.getMaxRowSize(), CoreMatchers.is((Object)0));
        this.collector.checkThat((Object)metaData.doesMaxRowSizeIncludeBlobs(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.getMaxStatementLength(), CoreMatchers.is((Object)0));
        this.collector.checkThat((Object)metaData.getMaxStatements(), CoreMatchers.is((Object)0));
        this.collector.checkThat((Object)metaData.getMaxTableNameLength(), CoreMatchers.is((Object)1024));
        this.collector.checkThat((Object)metaData.getMaxTablesInSelect(), CoreMatchers.is((Object)0));
        this.collector.checkThat((Object)metaData.getMaxUserNameLength(), CoreMatchers.is((Object)1024));
        this.collector.checkThat((Object)metaData.getDefaultTransactionIsolation(), CoreMatchers.is((Object)0));
        this.collector.checkThat((Object)metaData.supportsTransactions(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsBatchUpdates(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsSavepoints(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsNamedParameters(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.locatorsUpdateCopy(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsResultSetType(1004), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsResultSetType(1005), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsSchemasInPrivilegeDefinitions(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsCatalogsInPrivilegeDefinitions(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsTransactionIsolationLevel(0), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsTransactionIsolationLevel(2), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsTransactionIsolationLevel(1), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsTransactionIsolationLevel(4), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsTransactionIsolationLevel(8), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.dataDefinitionCausesTransactionCommit(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.dataDefinitionIgnoredInTransactions(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsStoredFunctionsUsingCallSyntax(), CoreMatchers.is((Object)false));
        this.collector.checkThat((Object)metaData.supportsIntegrityEnhancementFacility(), CoreMatchers.is((Object)true));
        this.collector.checkThat((Object)metaData.supportsDifferentTableCorrelationNames(), CoreMatchers.is((Object)false));
        ThrowableAssertionUtils.simpleAssertThrowableClass(SQLException.class, () -> metaData.supportsTransactionIsolationLevel(9));
        ThrowableAssertionUtils.simpleAssertThrowableClass(SQLException.class, () -> metaData.supportsResultSetType(1));
    }

    @Test
    public void testGetColumnsCanBeAccessedByNames() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getColumns(null, null, null, null);){
            this.resultSetTestUtils.testData(resultSet, (List<String>)ImmutableList.of((Object)"TABLE_CAT", (Object)"TABLE_SCHEM", (Object)"TABLE_NAME", (Object)"COLUMN_NAME", (Object)"DATA_TYPE", (Object)"TYPE_NAME", (Object)"COLUMN_SIZE", (Object)"BUFFER_LENGTH", (Object)"DECIMAL_DIGITS", (Object)"NUM_PREC_RADIX", (Object)"NULLABLE", (Object)"REMARKS", (Object[])new String[]{"COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN"}), EXPECTED_GET_COLUMNS_RESULTS);
        }
    }

    @Test
    public void testGetProcedures() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getProcedures(null, null, null);){
            HashMap<Integer, String> expectedGetProceduresSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "PROCEDURE_CAT");
                    this.put(2, "PROCEDURE_SCHEM");
                    this.put(3, "PROCEDURE_NAME");
                    this.put(4, "FUTURE_USE1");
                    this.put(5, "FUTURE_USE2");
                    this.put(6, "FUTURE_USE3");
                    this.put(7, "REMARKS");
                    this.put(8, "PROCEDURE_TYPE");
                    this.put(9, "SPECIFIC_NAME");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetProceduresSchema);
        }
    }

    @Test
    public void testGetProcedureColumns() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getProcedureColumns(null, null, null, null);){
            HashMap<Integer, String> expectedGetProcedureColumnsSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "PROCEDURE_CAT");
                    this.put(2, "PROCEDURE_SCHEM");
                    this.put(3, "PROCEDURE_NAME");
                    this.put(4, "COLUMN_NAME");
                    this.put(5, "COLUMN_TYPE");
                    this.put(6, "DATA_TYPE");
                    this.put(7, "TYPE_NAME");
                    this.put(8, "PRECISION");
                    this.put(9, "LENGTH");
                    this.put(10, "SCALE");
                    this.put(11, "RADIX");
                    this.put(12, "NULLABLE");
                    this.put(13, "REMARKS");
                    this.put(14, "COLUMN_DEF");
                    this.put(15, "SQL_DATA_TYPE");
                    this.put(16, "SQL_DATETIME_SUB");
                    this.put(17, "CHAR_OCTET_LENGTH");
                    this.put(18, "ORDINAL_POSITION");
                    this.put(19, "IS_NULLABLE");
                    this.put(20, "SPECIFIC_NAME");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetProcedureColumnsSchema);
        }
    }

    @Test
    public void testGetColumnPrivileges() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getColumnPrivileges(null, null, null, null);){
            HashMap<Integer, String> expectedGetColumnPrivilegesSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "TABLE_CAT");
                    this.put(2, "TABLE_SCHEM");
                    this.put(3, "TABLE_NAME");
                    this.put(4, "COLUMN_NAME");
                    this.put(5, "GRANTOR");
                    this.put(6, "GRANTEE");
                    this.put(7, "PRIVILEGE");
                    this.put(8, "IS_GRANTABLE");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetColumnPrivilegesSchema);
        }
    }

    @Test
    public void testGetTablePrivileges() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTablePrivileges(null, null, null);){
            HashMap<Integer, String> expectedGetTablePrivilegesSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "TABLE_CAT");
                    this.put(2, "TABLE_SCHEM");
                    this.put(3, "TABLE_NAME");
                    this.put(4, "GRANTOR");
                    this.put(5, "GRANTEE");
                    this.put(6, "PRIVILEGE");
                    this.put(7, "IS_GRANTABLE");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetTablePrivilegesSchema);
        }
    }

    @Test
    public void testGetBestRowIdentifier() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getBestRowIdentifier(null, null, null, 0, true);){
            HashMap<Integer, String> expectedGetBestRowIdentifierSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "SCOPE");
                    this.put(2, "COLUMN_NAME");
                    this.put(3, "DATA_TYPE");
                    this.put(4, "TYPE_NAME");
                    this.put(5, "COLUMN_SIZE");
                    this.put(6, "BUFFER_LENGTH");
                    this.put(7, "DECIMAL_DIGITS");
                    this.put(8, "PSEUDO_COLUMN");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetBestRowIdentifierSchema);
        }
    }

    @Test
    public void testGetVersionColumns() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getVersionColumns(null, null, null);){
            HashMap<Integer, String> expectedGetVersionColumnsSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "SCOPE");
                    this.put(2, "COLUMN_NAME");
                    this.put(3, "DATA_TYPE");
                    this.put(4, "TYPE_NAME");
                    this.put(5, "COLUMN_SIZE");
                    this.put(6, "BUFFER_LENGTH");
                    this.put(7, "DECIMAL_DIGITS");
                    this.put(8, "PSEUDO_COLUMN");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetVersionColumnsSchema);
        }
    }

    @Test
    public void testGetTypeInfo() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTypeInfo();){
            HashMap<Integer, String> expectedGetTypeInfoSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "TYPE_NAME");
                    this.put(2, "DATA_TYPE");
                    this.put(3, "PRECISION");
                    this.put(4, "LITERAL_PREFIX");
                    this.put(5, "LITERAL_SUFFIX");
                    this.put(6, "CREATE_PARAMS");
                    this.put(7, "NULLABLE");
                    this.put(8, "CASE_SENSITIVE");
                    this.put(9, "SEARCHABLE");
                    this.put(10, "UNSIGNED_ATTRIBUTE");
                    this.put(11, "FIXED_PREC_SCALE");
                    this.put(12, "AUTO_INCREMENT");
                    this.put(13, "LOCAL_TYPE_NAME");
                    this.put(14, "MINIMUM_SCALE");
                    this.put(15, "MAXIMUM_SCALE");
                    this.put(16, "SQL_DATA_TYPE");
                    this.put(17, "SQL_DATETIME_SUB");
                    this.put(18, "NUM_PREC_RADIX");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetTypeInfoSchema);
        }
    }

    @Test
    public void testGetIndexInfo() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getIndexInfo(null, null, null, false, true);){
            HashMap<Integer, String> expectedGetIndexInfoSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "TABLE_CAT");
                    this.put(2, "TABLE_SCHEM");
                    this.put(3, "TABLE_NAME");
                    this.put(4, "NON_UNIQUE");
                    this.put(5, "INDEX_QUALIFIER");
                    this.put(6, "INDEX_NAME");
                    this.put(7, "TYPE");
                    this.put(8, "ORDINAL_POSITION");
                    this.put(9, "COLUMN_NAME");
                    this.put(10, "ASC_OR_DESC");
                    this.put(11, "CARDINALITY");
                    this.put(12, "PAGES");
                    this.put(13, "FILTER_CONDITION");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetIndexInfoSchema);
        }
    }

    @Test
    public void testGetUDTs() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getUDTs(null, null, null, null);){
            HashMap<Integer, String> expectedGetUDTsSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "TYPE_CAT");
                    this.put(2, "TYPE_SCHEM");
                    this.put(3, "TYPE_NAME");
                    this.put(4, "CLASS_NAME");
                    this.put(5, "DATA_TYPE");
                    this.put(6, "REMARKS");
                    this.put(7, "BASE_TYPE");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetUDTsSchema);
        }
    }

    @Test
    public void testGetSuperTypes() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getSuperTypes(null, null, null);){
            HashMap<Integer, String> expectedGetSuperTypesSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "TYPE_CAT");
                    this.put(2, "TYPE_SCHEM");
                    this.put(3, "TYPE_NAME");
                    this.put(4, "SUPERTYPE_CAT");
                    this.put(5, "SUPERTYPE_SCHEM");
                    this.put(6, "SUPERTYPE_NAME");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetSuperTypesSchema);
        }
    }

    @Test
    public void testGetSuperTables() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getSuperTables(null, null, null);){
            HashMap<Integer, String> expectedGetSuperTablesSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "TABLE_CAT");
                    this.put(2, "TABLE_SCHEM");
                    this.put(3, "TABLE_NAME");
                    this.put(4, "SUPERTABLE_NAME");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetSuperTablesSchema);
        }
    }

    @Test
    public void testGetAttributes() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getAttributes(null, null, null, null);){
            HashMap<Integer, String> expectedGetAttributesSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "TYPE_CAT");
                    this.put(2, "TYPE_SCHEM");
                    this.put(3, "TYPE_NAME");
                    this.put(4, "ATTR_NAME");
                    this.put(5, "DATA_TYPE");
                    this.put(6, "ATTR_TYPE_NAME");
                    this.put(7, "ATTR_SIZE");
                    this.put(8, "DECIMAL_DIGITS");
                    this.put(9, "NUM_PREC_RADIX");
                    this.put(10, "NULLABLE");
                    this.put(11, "REMARKS");
                    this.put(12, "ATTR_DEF");
                    this.put(13, "SQL_DATA_TYPE");
                    this.put(14, "SQL_DATETIME_SUB");
                    this.put(15, "CHAR_OCTET_LENGTH");
                    this.put(16, "ORDINAL_POSITION");
                    this.put(17, "IS_NULLABLE");
                    this.put(18, "SCOPE_CATALOG");
                    this.put(19, "SCOPE_SCHEMA");
                    this.put(20, "SCOPE_TABLE");
                    this.put(21, "SOURCE_DATA_TYPE");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetAttributesSchema);
        }
    }

    @Test
    public void testGetClientInfoProperties() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getClientInfoProperties();){
            HashMap<Integer, String> expectedGetClientInfoPropertiesSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "NAME");
                    this.put(2, "MAX_LEN");
                    this.put(3, "DEFAULT_VALUE");
                    this.put(4, "DESCRIPTION");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetClientInfoPropertiesSchema);
        }
    }

    @Test
    public void testGetFunctions() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getFunctions(null, null, null);){
            HashMap<Integer, String> expectedGetFunctionsSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "FUNCTION_CAT");
                    this.put(2, "FUNCTION_SCHEM");
                    this.put(3, "FUNCTION_NAME");
                    this.put(4, "REMARKS");
                    this.put(5, "FUNCTION_TYPE");
                    this.put(6, "SPECIFIC_NAME");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetFunctionsSchema);
        }
    }

    @Test
    public void testGetFunctionColumns() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getFunctionColumns(null, null, null, null);){
            HashMap<Integer, String> expectedGetFunctionColumnsSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "FUNCTION_CAT");
                    this.put(2, "FUNCTION_SCHEM");
                    this.put(3, "FUNCTION_NAME");
                    this.put(4, "COLUMN_NAME");
                    this.put(5, "COLUMN_TYPE");
                    this.put(6, "DATA_TYPE");
                    this.put(7, "TYPE_NAME");
                    this.put(8, "PRECISION");
                    this.put(9, "LENGTH");
                    this.put(10, "SCALE");
                    this.put(11, "RADIX");
                    this.put(12, "NULLABLE");
                    this.put(13, "REMARKS");
                    this.put(14, "CHAR_OCTET_LENGTH");
                    this.put(15, "ORDINAL_POSITION");
                    this.put(16, "IS_NULLABLE");
                    this.put(17, "SPECIFIC_NAME");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetFunctionColumnsSchema);
        }
    }

    @Test
    public void testGetPseudoColumns() throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getPseudoColumns(null, null, null, null);){
            HashMap<Integer, String> expectedGetPseudoColumnsSchema = new HashMap<Integer, String>(){
                {
                    this.put(1, "TABLE_CAT");
                    this.put(2, "TABLE_SCHEM");
                    this.put(3, "TABLE_NAME");
                    this.put(4, "COLUMN_NAME");
                    this.put(5, "DATA_TYPE");
                    this.put(6, "COLUMN_SIZE");
                    this.put(7, "DECIMAL_DIGITS");
                    this.put(8, "NUM_PREC_RADIX");
                    this.put(9, "COLUMN_USAGE");
                    this.put(10, "REMARKS");
                    this.put(11, "CHAR_OCTET_LENGTH");
                    this.put(12, "IS_NULLABLE");
                }
            };
            this.testEmptyResultSet(resultSet, (Map<Integer, String>)expectedGetPseudoColumnsSchema);
        }
    }

    private void testEmptyResultSet(ResultSet resultSet, Map<Integer, String> expectedResultSetSchema) throws SQLException {
        Assert.assertFalse((boolean)resultSet.next());
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (Map.Entry<Integer, String> entry : expectedResultSetSchema.entrySet()) {
            Assert.assertEquals((Object)entry.getValue(), (Object)resultSetMetaData.getColumnLabel(entry.getKey()));
        }
    }

    @Test
    public void testGetColumnSize() {
        Assert.assertEquals((Object)ArrowDatabaseMetadata.COLUMN_SIZE_BYTE, (Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.Int(8, true)));
        Assert.assertEquals((Object)ArrowDatabaseMetadata.COLUMN_SIZE_SHORT, (Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.Int(16, true)));
        Assert.assertEquals((Object)ArrowDatabaseMetadata.COLUMN_SIZE_INT, (Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.Int(32, true)));
        Assert.assertEquals((Object)ArrowDatabaseMetadata.COLUMN_SIZE_LONG, (Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.Int(64, true)));
        Assert.assertEquals((Object)65536, (Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.Utf8()));
        Assert.assertEquals((Object)65536, (Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.Binary()));
        Assert.assertEquals((Object)ArrowDatabaseMetadata.COLUMN_SIZE_TIMESTAMP_SECONDS, (Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.Timestamp(TimeUnit.SECOND, null)));
        Assert.assertEquals((Object)ArrowDatabaseMetadata.COLUMN_SIZE_TIMESTAMP_MILLISECONDS, (Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, null)));
        Assert.assertEquals((Object)ArrowDatabaseMetadata.COLUMN_SIZE_TIMESTAMP_MICROSECONDS, (Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, null)));
        Assert.assertEquals((Object)ArrowDatabaseMetadata.COLUMN_SIZE_TIMESTAMP_NANOSECONDS, (Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.Timestamp(TimeUnit.NANOSECOND, null)));
        Assert.assertEquals((Object)ArrowDatabaseMetadata.COLUMN_SIZE_TIME, (Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.Time(TimeUnit.SECOND, 32)));
        Assert.assertEquals((Object)ArrowDatabaseMetadata.COLUMN_SIZE_TIME_MILLISECONDS, (Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32)));
        Assert.assertEquals((Object)ArrowDatabaseMetadata.COLUMN_SIZE_TIME_MICROSECONDS, (Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.Time(TimeUnit.MICROSECOND, 32)));
        Assert.assertEquals((Object)ArrowDatabaseMetadata.COLUMN_SIZE_TIME_NANOSECONDS, (Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.Time(TimeUnit.NANOSECOND, 32)));
        Assert.assertEquals((Object)ArrowDatabaseMetadata.COLUMN_SIZE_DATE, (Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.Date(DateUnit.DAY)));
        Assert.assertNull((Object)ArrowDatabaseMetadata.getColumnSize((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)));
    }

    @Test
    public void testGetDecimalDigits() {
        Assert.assertEquals((Object)0, (Object)ArrowDatabaseMetadata.getDecimalDigits((ArrowType)new ArrowType.Int(8, true)));
        Assert.assertEquals((Object)0, (Object)ArrowDatabaseMetadata.getDecimalDigits((ArrowType)new ArrowType.Timestamp(TimeUnit.SECOND, null)));
        Assert.assertEquals((Object)3, (Object)ArrowDatabaseMetadata.getDecimalDigits((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, null)));
        Assert.assertEquals((Object)6, (Object)ArrowDatabaseMetadata.getDecimalDigits((ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, null)));
        Assert.assertEquals((Object)9, (Object)ArrowDatabaseMetadata.getDecimalDigits((ArrowType)new ArrowType.Timestamp(TimeUnit.NANOSECOND, null)));
        Assert.assertEquals((Object)0, (Object)ArrowDatabaseMetadata.getDecimalDigits((ArrowType)new ArrowType.Time(TimeUnit.SECOND, 32)));
        Assert.assertEquals((Object)3, (Object)ArrowDatabaseMetadata.getDecimalDigits((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32)));
        Assert.assertEquals((Object)6, (Object)ArrowDatabaseMetadata.getDecimalDigits((ArrowType)new ArrowType.Time(TimeUnit.MICROSECOND, 32)));
        Assert.assertEquals((Object)9, (Object)ArrowDatabaseMetadata.getDecimalDigits((ArrowType)new ArrowType.Time(TimeUnit.NANOSECOND, 32)));
        Assert.assertEquals((Object)0, (Object)ArrowDatabaseMetadata.getDecimalDigits((ArrowType)new ArrowType.Date(DateUnit.DAY)));
        Assert.assertNull((Object)ArrowDatabaseMetadata.getDecimalDigits((ArrowType)new ArrowType.Utf8()));
    }

    @Test
    public void testSqlToRegexLike() {
        Assert.assertEquals((Object)".*", (Object)ArrowDatabaseMetadata.sqlToRegexLike((String)"%"));
        Assert.assertEquals((Object)".", (Object)ArrowDatabaseMetadata.sqlToRegexLike((String)"_"));
        Assert.assertEquals((Object)"\\*", (Object)ArrowDatabaseMetadata.sqlToRegexLike((String)"*"));
        Assert.assertEquals((Object)"T\\*E.S.*T", (Object)ArrowDatabaseMetadata.sqlToRegexLike((String)"T*E_S%T"));
    }

    @Test
    public void testEmptySqlInfo() throws Exception {
        try (Connection testConnection = FLIGHT_SERVER_EMPTY_SQLINFO_TEST_RULE.getConnection(false);){
            DatabaseMetaData metaData = testConnection.getMetaData();
            this.collector.checkThat((Object)metaData.getSQLKeywords(), CoreMatchers.is((Object)EXPECTED_EXTRA_NAME_CHARACTERS));
            this.collector.checkThat((Object)metaData.getNumericFunctions(), CoreMatchers.is((Object)EXPECTED_EXTRA_NAME_CHARACTERS));
            this.collector.checkThat((Object)metaData.getStringFunctions(), CoreMatchers.is((Object)EXPECTED_EXTRA_NAME_CHARACTERS));
            this.collector.checkThat((Object)metaData.getSystemFunctions(), CoreMatchers.is((Object)EXPECTED_EXTRA_NAME_CHARACTERS));
            this.collector.checkThat((Object)metaData.getTimeDateFunctions(), CoreMatchers.is((Object)EXPECTED_EXTRA_NAME_CHARACTERS));
        }
    }

    private static /* synthetic */ Object[] lambda$static$6(List expectedGetColumnsDataTypes, List expectedGetColumnsTypeName, List expectedGetColumnsColumnSize, List expectedGetColumnsDecimalDigits, List expectedGetColumnsRadix, List expectedGetColumnsIsNullable, int i) {
        return new Object[]{String.format("catalog_name #%d", i / 3), String.format("db_schema_name #%d", i / 3), String.format("table_name%d", i / 3), String.format("column_%d", i % 3 + 1), expectedGetColumnsDataTypes.get(i % 3), expectedGetColumnsTypeName.get(i % 3), expectedGetColumnsColumnSize.get(i % 3), null, expectedGetColumnsDecimalDigits.get(i % 3), expectedGetColumnsRadix.get(i % 3), !Objects.equals(expectedGetColumnsIsNullable.get(i % 3), "NO") ? 1 : 0, null, null, null, null, null, i % 3 + 1, expectedGetColumnsIsNullable.get(i % 3), null, null, null, null, EXPECTED_EXTRA_NAME_CHARACTERS, EXPECTED_EXTRA_NAME_CHARACTERS};
    }

    private static /* synthetic */ Object[] lambda$static$5(int i) {
        return new Object[]{String.format("catalog_name #%d", i), String.format("db_schema_name #%d", i), String.format("table_name #%d", i), String.format("column_name #%d", i), i, String.format("key_name #%d", i)};
    }

    private static /* synthetic */ Object[] lambda$static$4(int i) {
        return new Object[]{String.format("pk_catalog_name #%d", i), String.format("pk_db_schema_name #%d", i), String.format("pk_table_name #%d", i), String.format("pk_column_name #%d", i), String.format("fk_catalog_name #%d", i), String.format("fk_db_schema_name #%d", i), String.format("fk_table_name #%d", i), String.format("fk_column_name #%d", i), i, String.format("fk_key_name #%d", i), String.format("pk_key_name #%d", i), (byte)i, (byte)i, null};
    }

    private static /* synthetic */ Object[] lambda$static$3(int i) {
        return new Object[]{String.format("db_schema_name #%d", i), String.format("catalog_name #%d", i)};
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

