/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.grpc;

import io.grpc.Metadata;
import io.grpc.Status;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightStatusCode;
import org.apache.arrow.flight.grpc.StatusUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStatusUtils {
    @Test
    public void testParseTrailers() {
        Status status = Status.CANCELLED;
        Metadata trailers = new Metadata();
        trailers.put(StatusUtils.keyOfAscii((String)":status"), (Object)"502");
        trailers.put(StatusUtils.keyOfAscii((String)"date"), (Object)"Fri, 13 Sep 2015 11:23:58 GMT");
        trailers.put(StatusUtils.keyOfAscii((String)"content-type"), (Object)"text/html");
        CallStatus callStatus = StatusUtils.fromGrpcStatusAndTrailers((Status)status, (Metadata)trailers);
        Assertions.assertEquals((Object)FlightStatusCode.CANCELLED, (Object)callStatus.code());
        Assertions.assertTrue((boolean)callStatus.metadata().containsKey(":status"));
        Assertions.assertEquals((Object)"502", (Object)callStatus.metadata().get(":status"));
        Assertions.assertTrue((boolean)callStatus.metadata().containsKey("date"));
        Assertions.assertEquals((Object)"Fri, 13 Sep 2015 11:23:58 GMT", (Object)callStatus.metadata().get("date"));
        Assertions.assertTrue((boolean)callStatus.metadata().containsKey("content-type"));
        Assertions.assertEquals((Object)"text/html", (Object)callStatus.metadata().get("content-type"));
    }

    @Test
    public void testGrpcResourceExhaustedTranslatedToFlightStatus() {
        Status status = Status.RESOURCE_EXHAUSTED;
        CallStatus callStatus = StatusUtils.fromGrpcStatus((Status)status);
        Assertions.assertEquals((Object)FlightStatusCode.RESOURCE_EXHAUSTED, (Object)callStatus.code());
        FlightStatusCode flightStatusCode = StatusUtils.fromGrpcStatusCode((Status.Code)status.getCode());
        Assertions.assertEquals((Object)FlightStatusCode.RESOURCE_EXHAUSTED, (Object)flightStatusCode);
    }

    @Test
    public void testFlightResourceExhaustedTranslatedToGrpcStatua() {
        CallStatus callStatus = CallStatus.RESOURCE_EXHAUSTED;
        Status.Code grpcStatusCode = StatusUtils.toGrpcStatusCode((FlightStatusCode)callStatus.code());
        Assertions.assertEquals((Object)Status.RESOURCE_EXHAUSTED.getCode(), (Object)grpcStatusCode);
        Status grpcStatus = StatusUtils.toGrpcStatus((CallStatus)callStatus);
        Assertions.assertEquals((Object)Status.RESOURCE_EXHAUSTED.getCode(), (Object)grpcStatus.getCode());
    }
}

