/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.client;

import java.io.IOException;
import org.apache.arrow.flight.CallHeaders;
import org.apache.arrow.flight.CallInfo;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.Criteria;
import org.apache.arrow.flight.ErrorFlightMetadata;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightClientMiddleware;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightMethod;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightServerMiddleware;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.RequestContext;
import org.apache.arrow.flight.client.ClientCookieMiddleware;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestCookieHandling {
    private static final String SET_COOKIE_HEADER = "Set-Cookie";
    private static final String COOKIE_HEADER = "Cookie";
    private BufferAllocator allocator;
    private FlightServer server;
    private FlightClient client;
    private ClientCookieMiddlewareTestFactory testFactory = new ClientCookieMiddlewareTestFactory();
    private ClientCookieMiddleware cookieMiddleware = new ClientCookieMiddleware((ClientCookieMiddleware.Factory)this.testFactory);

    @BeforeEach
    public void setup() throws Exception {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
        this.startServerAndClient();
    }

    @AfterEach
    public void cleanup() throws Exception {
        this.testFactory = new ClientCookieMiddlewareTestFactory();
        this.cookieMiddleware = this.testFactory.onCallStarted(new CallInfo(FlightMethod.DO_ACTION));
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.client, this.server, this.allocator});
        this.client = null;
        this.server = null;
        this.allocator = null;
    }

    @Test
    public void basicCookie() {
        ErrorFlightMetadata headersToSend = new ErrorFlightMetadata();
        headersToSend.insert(SET_COOKIE_HEADER, "k=v");
        this.cookieMiddleware = this.testFactory.onCallStarted(new CallInfo(FlightMethod.DO_ACTION));
        this.cookieMiddleware.onHeadersReceived((CallHeaders)headersToSend);
        Assertions.assertEquals((Object)"k=v", (Object)this.cookieMiddleware.getValidCookiesAsString());
    }

    @Test
    public void cookieStaysAfterMultipleRequests() {
        ErrorFlightMetadata headersToSend = new ErrorFlightMetadata();
        headersToSend.insert(SET_COOKIE_HEADER, "k=v");
        this.cookieMiddleware = this.testFactory.onCallStarted(new CallInfo(FlightMethod.DO_ACTION));
        this.cookieMiddleware.onHeadersReceived((CallHeaders)headersToSend);
        Assertions.assertEquals((Object)"k=v", (Object)this.cookieMiddleware.getValidCookiesAsString());
        headersToSend = new ErrorFlightMetadata();
        this.cookieMiddleware = this.testFactory.onCallStarted(new CallInfo(FlightMethod.DO_ACTION));
        this.cookieMiddleware.onHeadersReceived((CallHeaders)headersToSend);
        Assertions.assertEquals((Object)"k=v", (Object)this.cookieMiddleware.getValidCookiesAsString());
        headersToSend = new ErrorFlightMetadata();
        this.cookieMiddleware = this.testFactory.onCallStarted(new CallInfo(FlightMethod.DO_ACTION));
        this.cookieMiddleware.onHeadersReceived((CallHeaders)headersToSend);
        Assertions.assertEquals((Object)"k=v", (Object)this.cookieMiddleware.getValidCookiesAsString());
    }

    @Disabled
    @Test
    public void cookieAutoExpires() {
        ErrorFlightMetadata headersToSend = new ErrorFlightMetadata();
        headersToSend.insert(SET_COOKIE_HEADER, "k=v; Max-Age=2");
        this.cookieMiddleware = this.testFactory.onCallStarted(new CallInfo(FlightMethod.DO_ACTION));
        this.cookieMiddleware.onHeadersReceived((CallHeaders)headersToSend);
        Assertions.assertEquals((Object)"k=\"v\"", (Object)this.cookieMiddleware.getValidCookiesAsString());
        headersToSend = new ErrorFlightMetadata();
        this.cookieMiddleware = this.testFactory.onCallStarted(new CallInfo(FlightMethod.DO_ACTION));
        this.cookieMiddleware.onHeadersReceived((CallHeaders)headersToSend);
        Assertions.assertEquals((Object)"k=\"v\"", (Object)this.cookieMiddleware.getValidCookiesAsString());
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)this.cookieMiddleware.getValidCookiesAsString().isEmpty());
    }

    @Test
    public void cookieExplicitlyExpires() {
        ErrorFlightMetadata headersToSend = new ErrorFlightMetadata();
        headersToSend.insert(SET_COOKIE_HEADER, "k=v; Max-Age=2");
        this.cookieMiddleware = this.testFactory.onCallStarted(new CallInfo(FlightMethod.DO_ACTION));
        this.cookieMiddleware.onHeadersReceived((CallHeaders)headersToSend);
        Assertions.assertEquals((Object)"k=\"v\"", (Object)this.cookieMiddleware.getValidCookiesAsString());
        headersToSend = new ErrorFlightMetadata();
        headersToSend.insert(SET_COOKIE_HEADER, "k=v; Max-Age=0");
        this.cookieMiddleware = this.testFactory.onCallStarted(new CallInfo(FlightMethod.DO_ACTION));
        this.cookieMiddleware.onHeadersReceived((CallHeaders)headersToSend);
        Assertions.assertTrue((boolean)this.cookieMiddleware.getValidCookiesAsString().isEmpty());
    }

    @Disabled
    @Test
    public void cookieExplicitlyExpiresWithMaxAgeMinusOne() {
        ErrorFlightMetadata headersToSend = new ErrorFlightMetadata();
        headersToSend.insert(SET_COOKIE_HEADER, "k=v; Max-Age=2");
        this.cookieMiddleware = this.testFactory.onCallStarted(new CallInfo(FlightMethod.DO_ACTION));
        this.cookieMiddleware.onHeadersReceived((CallHeaders)headersToSend);
        Assertions.assertEquals((Object)"k=\"v\"", (Object)this.cookieMiddleware.getValidCookiesAsString());
        headersToSend = new ErrorFlightMetadata();
        headersToSend.insert(SET_COOKIE_HEADER, "k=v; Max-Age=-1");
        this.cookieMiddleware = this.testFactory.onCallStarted(new CallInfo(FlightMethod.DO_ACTION));
        this.cookieMiddleware.onHeadersReceived((CallHeaders)headersToSend);
        Assertions.assertTrue((boolean)this.cookieMiddleware.getValidCookiesAsString().isEmpty());
    }

    @Test
    public void changeCookieValue() {
        ErrorFlightMetadata headersToSend = new ErrorFlightMetadata();
        headersToSend.insert(SET_COOKIE_HEADER, "k=v");
        this.cookieMiddleware.onHeadersReceived((CallHeaders)headersToSend);
        Assertions.assertEquals((Object)"k=v", (Object)this.cookieMiddleware.getValidCookiesAsString());
        headersToSend = new ErrorFlightMetadata();
        headersToSend.insert(SET_COOKIE_HEADER, "k=v2");
        this.cookieMiddleware.onHeadersReceived((CallHeaders)headersToSend);
        Assertions.assertEquals((Object)"k=v2", (Object)this.cookieMiddleware.getValidCookiesAsString());
    }

    @Test
    public void multipleCookiesWithSetCookie() {
        ErrorFlightMetadata headersToSend = new ErrorFlightMetadata();
        headersToSend.insert(SET_COOKIE_HEADER, "firstKey=firstVal");
        headersToSend.insert(SET_COOKIE_HEADER, "secondKey=secondVal");
        this.cookieMiddleware.onHeadersReceived((CallHeaders)headersToSend);
        Assertions.assertEquals((Object)"firstKey=firstVal; secondKey=secondVal", (Object)this.cookieMiddleware.getValidCookiesAsString());
    }

    @Test
    public void cookieStaysAfterMultipleRequestsEndToEnd() {
        this.client.handshake(new CallOption[0]);
        Assertions.assertEquals((Object)"k=v", (Object)this.testFactory.clientCookieMiddleware.getValidCookiesAsString());
        this.client.handshake(new CallOption[0]);
        Assertions.assertEquals((Object)"k=v", (Object)this.testFactory.clientCookieMiddleware.getValidCookiesAsString());
        this.client.listFlights(Criteria.ALL, new CallOption[0]);
        Assertions.assertEquals((Object)"k=v", (Object)this.testFactory.clientCookieMiddleware.getValidCookiesAsString());
    }

    private void startServerAndClient() throws IOException {
        NoOpFlightProducer flightProducer = new NoOpFlightProducer(){

            public void listFlights(FlightProducer.CallContext context, Criteria criteria, FlightProducer.StreamListener<FlightInfo> listener) {
                listener.onCompleted();
            }
        };
        this.server = FlightServer.builder((BufferAllocator)this.allocator, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)flightProducer).middleware(FlightServerMiddleware.Key.of((String)"test"), (FlightServerMiddleware.Factory)new SetCookieHeaderInjector.Factory()).build().start();
        this.client = FlightClient.builder((BufferAllocator)this.allocator, (Location)this.server.getLocation()).intercept((FlightClientMiddleware.Factory)this.testFactory).build();
    }

    public static class ClientCookieMiddlewareTestFactory
    extends ClientCookieMiddleware.Factory {
        private ClientCookieMiddleware clientCookieMiddleware;

        public ClientCookieMiddleware onCallStarted(CallInfo info) {
            this.clientCookieMiddleware = new ClientCookieMiddleware((ClientCookieMiddleware.Factory)this);
            return this.clientCookieMiddleware;
        }
    }

    static class SetCookieHeaderInjector
    implements FlightServerMiddleware {
        private final Factory factory;

        public SetCookieHeaderInjector(Factory factory) {
            this.factory = factory;
        }

        public void onBeforeSendingHeaders(CallHeaders outgoingHeaders) {
            if (!this.factory.receivedCookieHeader) {
                outgoingHeaders.insert(TestCookieHandling.SET_COOKIE_HEADER, "k=v");
            }
        }

        public void onCallCompleted(CallStatus status) {
        }

        public void onCallErrored(Throwable err) {
        }

        static class Factory
        implements FlightServerMiddleware.Factory<SetCookieHeaderInjector> {
            private boolean receivedCookieHeader = false;

            Factory() {
            }

            public SetCookieHeaderInjector onCallStarted(CallInfo info, CallHeaders incomingHeaders, RequestContext context) {
                this.receivedCookieHeader = null != incomingHeaders.get(TestCookieHandling.COOKIE_HEADER);
                return new SetCookieHeaderInjector(this);
            }
        }
    }
}

