/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.client;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.arrow.flight.Action;
import org.apache.arrow.flight.CallHeaders;
import org.apache.arrow.flight.CallInfo;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.Criteria;
import org.apache.arrow.flight.FlightCallHeaders;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightMethod;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightServerMiddleware;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.HeaderCallOption;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.RequestContext;
import org.apache.arrow.flight.SyncPutListener;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CustomHeaderTest {
    FlightServer server;
    FlightClient client;
    BufferAllocator allocator;
    TestCustomHeaderMiddleware.Factory headersMiddleware;
    HeaderCallOption headers;
    Map<String, String> testHeaders = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"bar", (Object)"foo", (Object)"answer", (Object)"42");

    @BeforeEach
    public void setUp() throws Exception {
        this.allocator = new RootAllocator(Integer.MAX_VALUE);
        this.headersMiddleware = new TestCustomHeaderMiddleware.Factory();
        FlightCallHeaders callHeaders = new FlightCallHeaders();
        for (Map.Entry<String, String> entry : this.testHeaders.entrySet()) {
            callHeaders.insert(entry.getKey(), entry.getValue());
        }
        this.headers = new HeaderCallOption((CallHeaders)callHeaders);
        this.server = FlightServer.builder((BufferAllocator)this.allocator, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)new NoOpFlightProducer()).middleware(FlightServerMiddleware.Key.of((String)"customHeader"), (FlightServerMiddleware.Factory)this.headersMiddleware).build();
        this.server.start();
        this.client = FlightClient.builder((BufferAllocator)this.allocator, (Location)this.server.getLocation()).build();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.allocator.getChildAllocators().forEach(BufferAllocator::close);
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.allocator, this.server, this.client});
    }

    @Test
    public void testHandshake() {
        try {
            this.client.handshake(new CallOption[]{this.headers});
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertHeadersMatch(FlightMethod.HANDSHAKE);
    }

    @Test
    public void testGetSchema() {
        try {
            this.client.getSchema(FlightDescriptor.command((byte[])new byte[0]), new CallOption[]{this.headers});
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertHeadersMatch(FlightMethod.GET_SCHEMA);
    }

    @Test
    public void testGetFlightInfo() {
        try {
            this.client.getInfo(FlightDescriptor.command((byte[])new byte[0]), new CallOption[]{this.headers});
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertHeadersMatch(FlightMethod.GET_FLIGHT_INFO);
    }

    @Test
    public void testListActions() {
        try {
            this.client.listActions(new CallOption[]{this.headers}).iterator().next();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertHeadersMatch(FlightMethod.LIST_ACTIONS);
    }

    @Test
    public void testListFlights() {
        try {
            this.client.listFlights(new Criteria(new byte[]{1}), new CallOption[]{this.headers}).iterator().next();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertHeadersMatch(FlightMethod.LIST_FLIGHTS);
    }

    @Test
    public void testDoAction() {
        try {
            this.client.doAction(new Action("test"), new CallOption[]{this.headers}).next();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertHeadersMatch(FlightMethod.DO_ACTION);
    }

    @Test
    public void testStartPut() {
        try {
            FlightClient.ClientStreamListener listener = this.client.startPut(FlightDescriptor.command((byte[])new byte[0]), (FlightClient.PutListener)new SyncPutListener(), new CallOption[]{this.headers});
            listener.getResult();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertHeadersMatch(FlightMethod.DO_PUT);
    }

    @Test
    public void testGetStream() {
        try (FlightStream stream = this.client.getStream(new Ticket(new byte[0]), new CallOption[]{this.headers});){
            stream.next();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertHeadersMatch(FlightMethod.DO_GET);
    }

    @Test
    public void testDoExchange() {
        try (FlightClient.ExchangeReaderWriter stream = this.client.doExchange(FlightDescriptor.command((byte[])new byte[0]), new CallOption[]{this.headers});){
            stream.getReader().next();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertHeadersMatch(FlightMethod.DO_EXCHANGE);
    }

    private void assertHeadersMatch(FlightMethod method) {
        for (Map.Entry<String, String> entry : this.testHeaders.entrySet()) {
            Assertions.assertEquals((Object)entry.getValue(), (Object)this.headersMiddleware.getCustomHeader(method, entry.getKey()));
        }
    }

    static class TestCustomHeaderMiddleware
    implements FlightServerMiddleware {
        public void onBeforeSendingHeaders(CallHeaders callHeaders) {
        }

        public void onCallCompleted(CallStatus callStatus) {
        }

        public void onCallErrored(Throwable throwable) {
        }

        static class Factory
        implements FlightServerMiddleware.Factory<TestCustomHeaderMiddleware> {
            private final Map<FlightMethod, CallHeaders> receivedCallHeaders = new HashMap<FlightMethod, CallHeaders>();

            Factory() {
            }

            public TestCustomHeaderMiddleware onCallStarted(CallInfo callInfo, CallHeaders callHeaders, RequestContext requestContext) {
                this.receivedCallHeaders.put(callInfo.method(), callHeaders);
                return new TestCustomHeaderMiddleware();
            }

            public String getCustomHeader(FlightMethod method, String key) {
                CallHeaders headers = this.receivedCallHeaders.get(method);
                if (headers == null) {
                    return null;
                }
                return headers.get(key);
            }
        }
    }
}

