/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.auth2;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.Criteria;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStatusCode;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.FlightTestUtil;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.auth2.BasicCallHeaderAuthenticator;
import org.apache.arrow.flight.auth2.CallHeaderAuthenticator;
import org.apache.arrow.flight.auth2.GeneratedBearerTokenAuthenticator;
import org.apache.arrow.flight.grpc.CredentialCallOption;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestBasicAuth2 {
    private static final String USERNAME_1 = "flight1";
    private static final String USERNAME_2 = "flight2";
    private static final String NO_USERNAME = "";
    private static final String PASSWORD_1 = "woohoo1";
    private static final String PASSWORD_2 = "woohoo2";
    private static BufferAllocator allocator;
    private static FlightServer server;
    private static FlightClient client;
    private static FlightClient client2;

    @BeforeAll
    public static void setup() throws Exception {
        allocator = new RootAllocator(Long.MAX_VALUE);
        TestBasicAuth2.startServerAndClient();
    }

    private static FlightProducer getFlightProducer() {
        return new NoOpFlightProducer(){

            public void listFlights(FlightProducer.CallContext context, Criteria criteria, FlightProducer.StreamListener<FlightInfo> listener) {
                if (!context.peerIdentity().equals(TestBasicAuth2.USERNAME_1) && !context.peerIdentity().equals(TestBasicAuth2.USERNAME_2)) {
                    listener.onError((Throwable)new IllegalArgumentException("Invalid username"));
                    return;
                }
                listener.onCompleted();
            }

            public void getStream(FlightProducer.CallContext context, Ticket ticket, FlightProducer.ServerStreamListener listener) {
                if (!context.peerIdentity().equals(TestBasicAuth2.USERNAME_1) && !context.peerIdentity().equals(TestBasicAuth2.USERNAME_2)) {
                    listener.error((Throwable)new IllegalArgumentException("Invalid username"));
                    return;
                }
                Schema pojoSchema = new Schema((Iterable)ImmutableList.of((Object)Field.nullable((String)"a", (ArrowType)Types.MinorType.BIGINT.getType())));
                try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)pojoSchema, (BufferAllocator)allocator);){
                    listener.start(root);
                    root.allocateNew();
                    root.setRowCount(4095);
                    listener.putNext();
                    listener.completed();
                }
            }
        };
    }

    private static void startServerAndClient() throws IOException {
        FlightProducer flightProducer = TestBasicAuth2.getFlightProducer();
        server = FlightServer.builder((BufferAllocator)allocator, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)flightProducer).headerAuthenticator((CallHeaderAuthenticator)new GeneratedBearerTokenAuthenticator((CallHeaderAuthenticator)new BasicCallHeaderAuthenticator(TestBasicAuth2::validate))).build().start();
        client = FlightClient.builder((BufferAllocator)allocator, (Location)server.getLocation()).build();
    }

    @AfterAll
    public static void shutdown() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{client, client2, server});
        client = null;
        client2 = null;
        server = null;
        allocator.getChildAllocators().forEach(BufferAllocator::close);
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{allocator});
        allocator = null;
    }

    private void startClient2() throws IOException {
        client2 = FlightClient.builder((BufferAllocator)allocator, (Location)server.getLocation()).build();
    }

    private static CallHeaderAuthenticator.AuthResult validate(String username, String password) {
        String identity;
        if (Strings.isNullOrEmpty((String)username)) {
            throw CallStatus.UNAUTHENTICATED.withDescription("Credentials not supplied.").toRuntimeException();
        }
        if (USERNAME_1.equals(username) && PASSWORD_1.equals(password)) {
            identity = USERNAME_1;
        } else if (USERNAME_2.equals(username) && PASSWORD_2.equals(password)) {
            identity = USERNAME_2;
        } else {
            throw CallStatus.UNAUTHENTICATED.withDescription("Username or password is invalid.").toRuntimeException();
        }
        return () -> identity;
    }

    @Test
    public void validAuthWithBearerAuthServer() throws IOException {
        this.testValidAuth(client);
    }

    @Test
    public void validAuthWithMultipleClientsWithSameCredentialsWithBearerAuthServer() throws IOException {
        this.startClient2();
        this.testValidAuthWithMultipleClientsWithSameCredentials(client, client2);
    }

    @Test
    public void validAuthWithMultipleClientsWithDifferentCredentialsWithBearerAuthServer() throws IOException {
        this.startClient2();
        this.testValidAuthWithMultipleClientsWithDifferentCredentials(client, client2);
    }

    @Test
    public void asyncCall() throws Exception {
        CredentialCallOption bearerToken = (CredentialCallOption)client.authenticateBasicToken(USERNAME_1, PASSWORD_1).get();
        client.listFlights(Criteria.ALL, new CallOption[]{bearerToken});
        try (FlightStream s = client.getStream(new Ticket(new byte[1]), new CallOption[]{bearerToken});){
            while (s.next()) {
                Assertions.assertEquals((int)4095, (int)s.getRoot().getRowCount());
            }
        }
    }

    @Test
    public void invalidAuthWithBearerAuthServer() throws IOException {
        this.testInvalidAuth(client);
    }

    @Test
    public void didntAuthWithBearerAuthServer() throws IOException {
        this.didntAuth(client);
    }

    private void testValidAuth(FlightClient client) {
        CredentialCallOption bearerToken = (CredentialCallOption)client.authenticateBasicToken(USERNAME_1, PASSWORD_1).get();
        Assertions.assertTrue((boolean)ImmutableList.copyOf((Iterable)client.listFlights(Criteria.ALL, new CallOption[]{bearerToken})).isEmpty());
    }

    private void testValidAuthWithMultipleClientsWithSameCredentials(FlightClient client1, FlightClient client2) {
        CredentialCallOption bearerToken1 = (CredentialCallOption)client1.authenticateBasicToken(USERNAME_1, PASSWORD_1).get();
        CredentialCallOption bearerToken2 = (CredentialCallOption)client2.authenticateBasicToken(USERNAME_1, PASSWORD_1).get();
        Assertions.assertTrue((boolean)ImmutableList.copyOf((Iterable)client1.listFlights(Criteria.ALL, new CallOption[]{bearerToken1})).isEmpty());
        Assertions.assertTrue((boolean)ImmutableList.copyOf((Iterable)client2.listFlights(Criteria.ALL, new CallOption[]{bearerToken2})).isEmpty());
    }

    private void testValidAuthWithMultipleClientsWithDifferentCredentials(FlightClient client1, FlightClient client2) {
        CredentialCallOption bearerToken1 = (CredentialCallOption)client1.authenticateBasicToken(USERNAME_1, PASSWORD_1).get();
        CredentialCallOption bearerToken2 = (CredentialCallOption)client2.authenticateBasicToken(USERNAME_2, PASSWORD_2).get();
        Assertions.assertTrue((boolean)ImmutableList.copyOf((Iterable)client1.listFlights(Criteria.ALL, new CallOption[]{bearerToken1})).isEmpty());
        Assertions.assertTrue((boolean)ImmutableList.copyOf((Iterable)client2.listFlights(Criteria.ALL, new CallOption[]{bearerToken2})).isEmpty());
    }

    private void testInvalidAuth(FlightClient client) {
        FlightTestUtil.assertCode(FlightStatusCode.UNAUTHENTICATED, () -> client.authenticateBasicToken(USERNAME_1, "WRONG"));
        FlightTestUtil.assertCode(FlightStatusCode.UNAUTHENTICATED, () -> client.authenticateBasicToken(NO_USERNAME, PASSWORD_1));
        FlightTestUtil.assertCode(FlightStatusCode.UNAUTHENTICATED, () -> client.listFlights(Criteria.ALL, new CallOption[0]).forEach(action -> Assertions.fail()));
    }

    private void didntAuth(FlightClient client) {
        FlightTestUtil.assertCode(FlightStatusCode.UNAUTHENTICATED, () -> client.listFlights(Criteria.ALL, new CallOption[0]).forEach(action -> Assertions.fail()));
    }
}

