/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.auth;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.Criteria;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStatusCode;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.FlightTestUtil;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.auth.BasicServerAuthHandler;
import org.apache.arrow.flight.auth.ServerAuthHandler;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestBasicAuth {
    private static final String USERNAME = "flight";
    private static final String PASSWORD = "woohoo";
    private static final byte[] VALID_TOKEN = "my_token".getBytes(StandardCharsets.UTF_8);
    private FlightClient client;
    private static FlightServer server;
    private static BufferAllocator allocator;

    @Test
    public void validAuth() {
        this.client.authenticateBasic(USERNAME, PASSWORD);
        Assertions.assertEquals((int)0, (int)ImmutableList.copyOf((Iterable)this.client.listFlights(Criteria.ALL, new CallOption[0])).size());
    }

    @Test
    public void asyncCall() throws Exception {
        this.client.authenticateBasic(USERNAME, PASSWORD);
        this.client.listFlights(Criteria.ALL, new CallOption[0]);
        try (FlightStream s = this.client.getStream(new Ticket(new byte[1]), new CallOption[0]);){
            while (s.next()) {
                Assertions.assertEquals((int)4095, (int)s.getRoot().getRowCount());
            }
        }
    }

    @Test
    public void invalidAuth() {
        FlightTestUtil.assertCode(FlightStatusCode.UNAUTHENTICATED, () -> this.client.authenticateBasic(USERNAME, "WRONG"));
        FlightTestUtil.assertCode(FlightStatusCode.UNAUTHENTICATED, () -> this.client.listFlights(Criteria.ALL, new CallOption[0]).forEach(action -> Assertions.fail()));
    }

    @Test
    public void didntAuth() {
        FlightTestUtil.assertCode(FlightStatusCode.UNAUTHENTICATED, () -> this.client.listFlights(Criteria.ALL, new CallOption[0]).forEach(action -> Assertions.fail()));
    }

    @BeforeEach
    public void testSetup() throws IOException {
        this.client = FlightClient.builder((BufferAllocator)allocator, (Location)server.getLocation()).build();
    }

    @BeforeAll
    public static void setup() throws IOException {
        allocator = new RootAllocator(Long.MAX_VALUE);
        BasicServerAuthHandler.BasicAuthValidator validator = new BasicServerAuthHandler.BasicAuthValidator(){

            public Optional<String> isValid(byte[] token) {
                if (Arrays.equals(token, VALID_TOKEN)) {
                    return Optional.of(TestBasicAuth.USERNAME);
                }
                return Optional.empty();
            }

            public byte[] getToken(String username, String password) {
                if (TestBasicAuth.USERNAME.equals(username) && TestBasicAuth.PASSWORD.equals(password)) {
                    return VALID_TOKEN;
                }
                throw new IllegalArgumentException("invalid credentials");
            }
        };
        server = FlightServer.builder((BufferAllocator)allocator, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)new NoOpFlightProducer(){

            public void listFlights(FlightProducer.CallContext context, Criteria criteria, FlightProducer.StreamListener<FlightInfo> listener) {
                if (!context.peerIdentity().equals(TestBasicAuth.USERNAME)) {
                    listener.onError((Throwable)new IllegalArgumentException("Invalid username"));
                    return;
                }
                listener.onCompleted();
            }

            public void getStream(FlightProducer.CallContext context, Ticket ticket, FlightProducer.ServerStreamListener listener) {
                if (!context.peerIdentity().equals(TestBasicAuth.USERNAME)) {
                    listener.error((Throwable)new IllegalArgumentException("Invalid username"));
                    return;
                }
                Schema pojoSchema = new Schema((Iterable)ImmutableList.of((Object)Field.nullable((String)"a", (ArrowType)Types.MinorType.BIGINT.getType())));
                try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)pojoSchema, (BufferAllocator)allocator);){
                    listener.start(root);
                    root.allocateNew();
                    root.setRowCount(4095);
                    listener.putNext();
                    listener.completed();
                }
            }
        }).authHandler((ServerAuthHandler)new BasicServerAuthHandler(validator)).build().start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.client});
    }

    @AfterAll
    public static void shutdown() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{server});
        allocator.getChildAllocators().forEach(BufferAllocator::close);
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{allocator});
    }
}

