/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.protobuf.services.HealthStatusManager;
import java.io.File;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightBindingService;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.FlightTestUtil;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.TestBasicOperation;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.auth.ServerAuthHandler;
import org.apache.arrow.flight.impl.FlightServiceGrpc;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class TestServerOptions {
    @Test
    public void builderConsumer() throws Exception {
        AtomicBoolean consumerCalled = new AtomicBoolean();
        Consumer<NettyServerBuilder> consumer = builder -> consumerCalled.set(true);
        try (RootAllocator a = new RootAllocator(Long.MAX_VALUE);
             TestBasicOperation.Producer producer = new TestBasicOperation.Producer((BufferAllocator)a);
             FlightServer s = FlightServer.builder((BufferAllocator)a, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)producer).transportHint("grpc.builderConsumer", consumer).build().start();){
            Assertions.assertTrue((boolean)consumerCalled.get());
        }
    }

    @Test
    public void defaultExecutorClosed() throws Exception {
        ExecutorService executor;
        try (RootAllocator a = new RootAllocator(Long.MAX_VALUE);
             FlightServer server = FlightServer.builder((BufferAllocator)a, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)new NoOpFlightProducer()).build().start();){
            Assertions.assertNotNull((Object)server.grpcExecutor);
            executor = server.grpcExecutor;
        }
        Assertions.assertTrue((boolean)executor.isShutdown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void suppliedExecutorNotClosed() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            try (RootAllocator a = new RootAllocator(Long.MAX_VALUE);
                 FlightServer server = FlightServer.builder((BufferAllocator)a, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)new NoOpFlightProducer()).executor(executor).build().start();){
                Assertions.assertNull((Object)server.grpcExecutor);
            }
            Assertions.assertFalse((boolean)executor.isShutdown());
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    public void domainSocket() throws Exception {
        Assumptions.assumeTrue((boolean)FlightTestUtil.isNativeTransportAvailable(), (String)"We have a native transport available");
        File domainSocket = File.createTempFile("flight-unit-test-", ".sock");
        Assertions.assertTrue((boolean)domainSocket.delete());
        Assumptions.assumeTrue((domainSocket.getAbsolutePath().length() < 100 ? 1 : 0) != 0, (String)"The domain socket path is not too long");
        Location location = Location.forGrpcDomainSocket((String)domainSocket.getAbsolutePath());
        try (RootAllocator a = new RootAllocator(Long.MAX_VALUE);
             TestBasicOperation.Producer producer = new TestBasicOperation.Producer((BufferAllocator)a);
             FlightServer s = FlightServer.builder((BufferAllocator)a, (Location)location, (FlightProducer)producer).build().start();
             FlightClient c = FlightClient.builder((BufferAllocator)a, (Location)location).build();
             FlightStream stream = c.getStream(new Ticket(new byte[0]), new CallOption[0]);){
            VectorSchemaRoot root = stream.getRoot();
            IntVector iv = (IntVector)root.getVector("c1");
            int value = 0;
            while (stream.next()) {
                for (int i = 0; i < root.getRowCount(); ++i) {
                    Assertions.assertEquals((int)value, (int)iv.get(i));
                    ++value;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void checkReflectionMetadata() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);){
            FlightBindingService service = new FlightBindingService((BufferAllocator)allocator, (FlightProducer)new NoOpFlightProducer(), ServerAuthHandler.NO_OP, executorService);
            ServerServiceDefinition definition = service.bindService();
            Assertions.assertEquals((Object)FlightServiceGrpc.getServiceDescriptor().getSchemaDescriptor(), (Object)definition.getServiceDescriptor().getSchemaDescriptor());
            HashMap definedMethods = new HashMap();
            HashMap serviceMethods = new HashMap();
            definition.getMethods().forEach(method -> definedMethods.put(method.getMethodDescriptor().getFullMethodName(), method.getMethodDescriptor()));
            definition.getServiceDescriptor().getMethods().forEach(method -> serviceMethods.put(method.getFullMethodName(), method));
            for (MethodDescriptor descriptor : FlightServiceGrpc.getServiceDescriptor().getMethods()) {
                String methodName = descriptor.getFullMethodName();
                Assertions.assertTrue((boolean)definedMethods.containsKey(methodName), (String)("Method is missing from ServerServiceDefinition: " + methodName));
                Assertions.assertTrue((boolean)definedMethods.containsKey(methodName), (String)("Method is missing from ServiceDescriptor: " + methodName));
                Assertions.assertEquals((Object)descriptor.getSchemaDescriptor(), (Object)((MethodDescriptor)definedMethods.get(methodName)).getSchemaDescriptor());
                Assertions.assertEquals((Object)descriptor.getSchemaDescriptor(), (Object)((MethodDescriptor)serviceMethods.get(methodName)).getSchemaDescriptor());
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    @Test
    public void addHealthCheckService() throws Exception {
        HealthStatusManager statusManager = new HealthStatusManager();
        Consumer<NettyServerBuilder> consumer = builder -> builder.addService(statusManager.getHealthService());
        Location location = Location.forGrpcInsecure((String)"localhost", (int)5555);
        try (RootAllocator a = new RootAllocator(Long.MAX_VALUE);
             TestBasicOperation.Producer producer = new TestBasicOperation.Producer((BufferAllocator)a);
             FlightServer s = FlightServer.builder((BufferAllocator)a, (Location)location, (FlightProducer)producer).transportHint("grpc.builderConsumer", consumer).build().start();){
            ManagedChannel channel = NettyChannelBuilder.forAddress((SocketAddress)location.toSocketAddress()).usePlaintext().build();
            HealthCheckResponse response = HealthGrpc.newBlockingStub((Channel)channel).check(HealthCheckRequest.getDefaultInstance());
            Assertions.assertEquals((Object)response.getStatus(), (Object)HealthCheckResponse.ServingStatus.SERVING);
        }
    }
}

