/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.flight.SchemaResult;
import org.apache.arrow.flight.SyncPutListener;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.types.MetadataVersion;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestMetadataVersion {
    private static BufferAllocator allocator;
    private static Schema schema;
    private static IpcOption optionV4;
    private static IpcOption optionV5;
    private static Schema unionSchema;

    @BeforeAll
    public static void setUpClass() {
        allocator = new RootAllocator(Integer.MAX_VALUE);
        schema = new Schema(Collections.singletonList(Field.nullable((String)"foo", (ArrowType)new ArrowType.Int(32, true))));
        unionSchema = new Schema(Collections.singletonList(Field.nullable((String)"union", (ArrowType)new ArrowType.Union(UnionMode.Dense, new int[]{0}))));
        optionV4 = new IpcOption(false, MetadataVersion.V4);
        optionV5 = IpcOption.DEFAULT;
    }

    @AfterAll
    public static void tearDownClass() {
        allocator.close();
    }

    @Test
    public void testGetFlightInfoV4() throws Exception {
        try (FlightServer server = this.startServer(optionV4);
             FlightClient client = this.connect(server);){
            FlightInfo result = client.getInfo(FlightDescriptor.command((byte[])new byte[0]), new CallOption[0]);
            Assertions.assertEquals(Optional.of(schema), (Object)result.getSchemaOptional());
        }
    }

    @Test
    public void testGetSchemaV4() throws Exception {
        try (FlightServer server = this.startServer(optionV4);
             FlightClient client = this.connect(server);){
            SchemaResult result = client.getSchema(FlightDescriptor.command((byte[])new byte[0]), new CallOption[0]);
            Assertions.assertEquals((Object)schema, (Object)result.getSchema());
        }
    }

    @Test
    public void testUnionCheck() throws Exception {
        FlightClient client;
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SchemaResult(unionSchema, optionV4));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new FlightInfo(unionSchema, FlightDescriptor.command((byte[])new byte[0]), Collections.emptyList(), -1L, -1L, optionV4));
        try (FlightServer server = this.startServer(optionV4);){
            client = this.connect(server);
            try (FlightStream stream = client.getStream(new Ticket("union".getBytes(StandardCharsets.UTF_8)), new CallOption[0]);){
                FlightRuntimeException err = (FlightRuntimeException)Assertions.assertThrows(FlightRuntimeException.class, () -> ((FlightStream)stream).next());
                Assertions.assertTrue((boolean)err.getMessage().contains("Cannot write union with V4 metadata"), (String)err.getMessage());
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        server = this.startServer(optionV4);
        try {
            client = this.connect(server);
            try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)unionSchema, (BufferAllocator)allocator);){
                FlightDescriptor descriptor = FlightDescriptor.command((byte[])new byte[0]);
                SyncPutListener reader = new SyncPutListener();
                FlightClient.ClientStreamListener listener = client.startPut(descriptor, (FlightClient.PutListener)reader, new CallOption[0]);
                IllegalArgumentException err = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> listener.start(root, null, optionV4));
                Assertions.assertTrue((boolean)err.getMessage().contains("Cannot write union with V4 metadata"), (String)err.getMessage());
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        finally {
            if (server != null) {
                server.close();
            }
        }
    }

    @Test
    public void testPutV4() throws Exception {
        try (FlightServer server = this.startServer(optionV4);
             FlightClient client = this.connect(server);
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);){
            TestMetadataVersion.generateData(root);
            FlightDescriptor descriptor = FlightDescriptor.command((byte[])new byte[0]);
            SyncPutListener reader = new SyncPutListener();
            FlightClient.ClientStreamListener listener = client.startPut(descriptor, (FlightClient.PutListener)reader, new CallOption[0]);
            listener.start(root, null, optionV4);
            listener.putNext();
            listener.completed();
            listener.getResult();
        }
    }

    @Test
    public void testGetV4() throws Exception {
        try (FlightServer server = this.startServer(optionV4);
             FlightClient client = this.connect(server);
             FlightStream stream = client.getStream(new Ticket(new byte[0]), new CallOption[0]);){
            Assertions.assertTrue((boolean)stream.next());
            Assertions.assertEquals((Object)TestMetadataVersion.optionV4.metadataVersion, (Object)stream.metadataVersion);
            TestMetadataVersion.validateRoot(stream.getRoot());
            Assertions.assertFalse((boolean)stream.next());
        }
    }

    @Test
    public void testExchangeV4ToV5() throws Exception {
        try (FlightServer server = this.startServer(optionV5);
             FlightClient client = this.connect(server);
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);
             FlightClient.ExchangeReaderWriter stream = client.doExchange(FlightDescriptor.command((byte[])new byte[0]), new CallOption[0]);){
            stream.getWriter().start(root, null, optionV4);
            TestMetadataVersion.generateData(root);
            stream.getWriter().putNext();
            stream.getWriter().completed();
            Assertions.assertTrue((boolean)stream.getReader().next());
            Assertions.assertEquals((Object)TestMetadataVersion.optionV5.metadataVersion, (Object)stream.getReader().metadataVersion);
            TestMetadataVersion.validateRoot(stream.getReader().getRoot());
            Assertions.assertFalse((boolean)stream.getReader().next());
        }
    }

    @Test
    public void testExchangeV5ToV4() throws Exception {
        try (FlightServer server = this.startServer(optionV4);
             FlightClient client = this.connect(server);
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);
             FlightClient.ExchangeReaderWriter stream = client.doExchange(FlightDescriptor.command((byte[])new byte[0]), new CallOption[0]);){
            stream.getWriter().start(root, null, optionV5);
            TestMetadataVersion.generateData(root);
            stream.getWriter().putNext();
            stream.getWriter().completed();
            Assertions.assertTrue((boolean)stream.getReader().next());
            Assertions.assertEquals((Object)TestMetadataVersion.optionV4.metadataVersion, (Object)stream.getReader().metadataVersion);
            TestMetadataVersion.validateRoot(stream.getReader().getRoot());
            Assertions.assertFalse((boolean)stream.getReader().next());
        }
    }

    @Test
    public void testExchangeV4ToV4() throws Exception {
        try (FlightServer server = this.startServer(optionV4);
             FlightClient client = this.connect(server);
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);
             FlightClient.ExchangeReaderWriter stream = client.doExchange(FlightDescriptor.command((byte[])new byte[0]), new CallOption[0]);){
            stream.getWriter().start(root, null, optionV4);
            TestMetadataVersion.generateData(root);
            stream.getWriter().putNext();
            stream.getWriter().completed();
            Assertions.assertTrue((boolean)stream.getReader().next());
            Assertions.assertEquals((Object)TestMetadataVersion.optionV4.metadataVersion, (Object)stream.getReader().metadataVersion);
            TestMetadataVersion.validateRoot(stream.getReader().getRoot());
            Assertions.assertFalse((boolean)stream.getReader().next());
        }
    }

    private static void generateData(VectorSchemaRoot root) {
        Assertions.assertEquals((Object)schema, (Object)root.getSchema());
        IntVector vector = (IntVector)root.getVector("foo");
        vector.setSafe(0, 0);
        vector.setSafe(1, 1);
        vector.setSafe(2, 4);
        root.setRowCount(3);
    }

    private static void validateRoot(VectorSchemaRoot root) {
        Assertions.assertEquals((Object)schema, (Object)root.getSchema());
        Assertions.assertEquals((int)3, (int)root.getRowCount());
        IntVector vector = (IntVector)root.getVector("foo");
        Assertions.assertEquals((int)0, (int)vector.get(0));
        Assertions.assertEquals((int)1, (int)vector.get(1));
        Assertions.assertEquals((int)4, (int)vector.get(2));
    }

    FlightServer startServer(IpcOption option) throws Exception {
        Location location = Location.forGrpcInsecure((String)"localhost", (int)0);
        VersionFlightProducer producer = new VersionFlightProducer(allocator, option);
        FlightServer server = FlightServer.builder((BufferAllocator)allocator, (Location)location, (FlightProducer)producer).build();
        server.start();
        return server;
    }

    FlightClient connect(FlightServer server) {
        Location location = Location.forGrpcInsecure((String)"localhost", (int)server.getPort());
        return FlightClient.builder((BufferAllocator)allocator, (Location)location).build();
    }

    static final class VersionFlightProducer
    extends NoOpFlightProducer {
        private final BufferAllocator allocator;
        private final IpcOption option;

        VersionFlightProducer(BufferAllocator allocator, IpcOption option) {
            this.allocator = allocator;
            this.option = option;
        }

        public FlightInfo getFlightInfo(FlightProducer.CallContext context, FlightDescriptor descriptor) {
            return new FlightInfo(schema, descriptor, Collections.emptyList(), -1L, -1L, this.option);
        }

        public SchemaResult getSchema(FlightProducer.CallContext context, FlightDescriptor descriptor) {
            return new SchemaResult(schema, this.option);
        }

        public void getStream(FlightProducer.CallContext context, Ticket ticket, FlightProducer.ServerStreamListener listener) {
            if (Arrays.equals("union".getBytes(StandardCharsets.UTF_8), ticket.getBytes())) {
                try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)unionSchema, (BufferAllocator)this.allocator);){
                    listener.start(root, null, this.option);
                }
                catch (IllegalArgumentException e) {
                    listener.error((Throwable)CallStatus.INTERNAL.withCause((Throwable)e).withDescription(e.getMessage()).toRuntimeException());
                    return;
                }
                listener.error((Throwable)CallStatus.INTERNAL.withDescription("Expected exception not raised").toRuntimeException());
                return;
            }
            try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
                listener.start(root, null, this.option);
                TestMetadataVersion.generateData(root);
                listener.putNext();
                listener.completed();
            }
        }

        public Runnable acceptPut(FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
            return () -> {
                try {
                    Assertions.assertTrue((boolean)flightStream.next());
                    Assertions.assertEquals((Object)this.option.metadataVersion, (Object)flightStream.metadataVersion);
                    TestMetadataVersion.validateRoot(flightStream.getRoot());
                }
                catch (AssertionError err) {
                    ((Throwable)((Object)err)).printStackTrace();
                    ackStream.onError((Throwable)CallStatus.INVALID_ARGUMENT.withCause((Throwable)((Object)err)).withDescription("Server assertion failed: " + String.valueOf(err)).toRuntimeException());
                    return;
                }
                catch (RuntimeException err) {
                    err.printStackTrace();
                    ackStream.onError((Throwable)CallStatus.INTERNAL.withCause((Throwable)err).withDescription("Server assertion failed: " + String.valueOf(err)).toRuntimeException());
                    return;
                }
                ackStream.onCompleted();
            };
        }

        /*
         * Loose catch block
         */
        public void doExchange(FlightProducer.CallContext context, FlightStream reader, FlightProducer.ServerStreamListener writer) {
            block13: {
                Throwable throwable2222;
                VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);
                try {
                    try {
                        Assertions.assertTrue((boolean)reader.next());
                        TestMetadataVersion.validateRoot(reader.getRoot());
                        Assertions.assertFalse((boolean)reader.next());
                    }
                    catch (AssertionError err) {
                        ((Throwable)((Object)err)).printStackTrace();
                        writer.error((Throwable)CallStatus.INVALID_ARGUMENT.withCause((Throwable)((Object)err)).withDescription("Server assertion failed: " + String.valueOf(err)).toRuntimeException());
                        if (root != null) {
                            root.close();
                        }
                        return;
                    }
                    catch (RuntimeException err) {
                        block12: {
                            err.printStackTrace();
                            writer.error((Throwable)CallStatus.INTERNAL.withCause((Throwable)err).withDescription("Server assertion failed: " + String.valueOf(err)).toRuntimeException());
                            if (root == null) break block12;
                            root.close();
                        }
                        return;
                    }
                    writer.start(root, null, this.option);
                    TestMetadataVersion.generateData(root);
                    writer.putNext();
                    writer.completed();
                    break block13;
                    {
                        catch (Throwable throwable2222) {
                            throw throwable2222;
                        }
                    }
                }
                finally {
                    if (root != null) {
                        try {
                            root.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2222.addSuppressed(throwable3);
                        }
                    }
                }
            }
        }
    }
}

