/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import org.apache.arrow.flight.ArrowMessage;
import org.apache.arrow.flight.CallHeaders;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightCallHeaders;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightConstants;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightService;
import org.apache.arrow.flight.HeaderCallOption;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.ServerHeaderMiddleware;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFlightService {
    private BufferAllocator allocator;

    @BeforeEach
    public void setup() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @AfterEach
    public void cleanup() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.allocator});
    }

    @Test
    public void testFlightServiceWithNoAuthHandlerOrInterceptors() {
        NoOpFlightProducer producer = new NoOpFlightProducer(){

            public void getStream(FlightProducer.CallContext context, Ticket ticket, FlightProducer.ServerStreamListener listener) {
                listener.completed();
            }
        };
        ServerCallStreamObserver<ArrowMessage> observer = new ServerCallStreamObserver<ArrowMessage>(){

            public boolean isCancelled() {
                return false;
            }

            public void setOnCancelHandler(Runnable runnable) {
            }

            public void setCompression(String s) {
            }

            public boolean isReady() {
                return false;
            }

            public void setOnReadyHandler(Runnable runnable) {
            }

            public void disableAutoInboundFlowControl() {
            }

            public void request(int i) {
            }

            public void setMessageCompression(boolean b) {
            }

            public void onNext(ArrowMessage arrowMessage) {
            }

            public void onError(Throwable throwable) {
                Assertions.fail((Throwable)throwable);
            }

            public void onCompleted() {
            }
        };
        FlightService flightService = new FlightService(this.allocator, (FlightProducer)producer, null, null);
        flightService.doGetCustom(Flight.Ticket.newBuilder().build(), (StreamObserver)observer);
    }

    @Test
    public void supportsNullSchemas() throws Exception {
        NoOpFlightProducer producer = new NoOpFlightProducer(){

            public FlightInfo getFlightInfo(FlightProducer.CallContext context, FlightDescriptor descriptor) {
                return new FlightInfo(null, descriptor, Collections.emptyList(), 0L, 0L, false, IpcOption.DEFAULT, "foo".getBytes(StandardCharsets.UTF_8));
            }
        };
        try (FlightServer s = FlightServer.builder((BufferAllocator)this.allocator, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)producer).build().start();
             FlightClient client = FlightClient.builder((BufferAllocator)this.allocator, (Location)s.getLocation()).build();){
            FlightInfo flightInfo = client.getInfo(FlightDescriptor.path((String[])new String[]{"test"}), new CallOption[0]);
            Assertions.assertEquals(Optional.empty(), (Object)flightInfo.getSchemaOptional());
            Assertions.assertEquals((Object)new Schema(Collections.emptyList()), (Object)flightInfo.getSchema());
            Assertions.assertArrayEquals((byte[])flightInfo.getAppMetadata(), (byte[])"foo".getBytes(StandardCharsets.UTF_8));
            Exception e = (Exception)Assertions.assertThrows(FlightRuntimeException.class, () -> client.getSchema(FlightDescriptor.path((String[])new String[]{"test"}), new CallOption[0]));
            Assertions.assertEquals((Object)"No schema is present in FlightInfo", (Object)e.getMessage());
        }
    }

    @Test
    public void testHeaderSizeExchangeInService() throws Exception {
        FlightInfo flightInfo;
        FlightClient client;
        NoOpFlightProducer producer = new NoOpFlightProducer(){

            public FlightInfo getFlightInfo(FlightProducer.CallContext context, FlightDescriptor descriptor) {
                String longHeader = ((ServerHeaderMiddleware)context.getMiddleware(FlightConstants.HEADER_KEY)).headers().get("long-header");
                return new FlightInfo(null, descriptor, Collections.emptyList(), 0L, 0L, false, IpcOption.DEFAULT, longHeader.getBytes(StandardCharsets.UTF_8));
            }
        };
        String headerVal = TestFlightService.generateRandom(10240);
        FlightCallHeaders callHeaders = new FlightCallHeaders();
        callHeaders.insert("long-header", headerVal);
        try (FlightServer s = FlightServer.builder((BufferAllocator)this.allocator, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)producer).build().start();){
            client = FlightClient.builder((BufferAllocator)this.allocator, (Location)s.getLocation()).build();
            try {
                flightInfo = client.getInfo(FlightDescriptor.path((String[])new String[]{"test"}), new CallOption[]{new HeaderCallOption((CallHeaders)callHeaders)});
                Assertions.assertEquals(Optional.empty(), (Object)flightInfo.getSchemaOptional());
                Assertions.assertEquals((Object)new Schema(Collections.emptyList()), (Object)flightInfo.getSchema());
                Assertions.assertArrayEquals((byte[])flightInfo.getAppMetadata(), (byte[])headerVal.getBytes(StandardCharsets.UTF_8));
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        s = FlightServer.builder((BufferAllocator)this.allocator, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)producer).setMaxHeaderListSize(15360).build().start();
        try {
            client = FlightClient.builder((BufferAllocator)this.allocator, (Location)s.getLocation()).build();
            try {
                flightInfo = client.getInfo(FlightDescriptor.path((String[])new String[]{"test"}), new CallOption[]{new HeaderCallOption((CallHeaders)callHeaders)});
                Assertions.assertEquals(Optional.empty(), (Object)flightInfo.getSchemaOptional());
                Assertions.assertEquals((Object)new Schema(Collections.emptyList()), (Object)flightInfo.getSchema());
                Assertions.assertArrayEquals((byte[])flightInfo.getAppMetadata(), (byte[])headerVal.getBytes(StandardCharsets.UTF_8));
                callHeaders.insert("another-header", headerVal + headerVal);
                FlightRuntimeException e = (FlightRuntimeException)Assertions.assertThrows(FlightRuntimeException.class, () -> client.getInfo(FlightDescriptor.path((String[])new String[]{"test"}), new CallOption[]{new HeaderCallOption((CallHeaders)callHeaders)}));
                Assertions.assertEquals((Object)"http2 exception", (Object)e.getMessage());
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    private static String generateRandom(int size) {
        String aToZ = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        Random random = new Random();
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            int randIndex = random.nextInt(aToZ.length());
            res.append(aToZ.charAt(randIndex));
        }
        return res.toString();
    }
}

