/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.protobuf.Empty;
import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightGrpcUtils;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.TestServiceGrpc;
import org.apache.arrow.flight.auth.ServerAuthHandler;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFlightGrpcUtils {
    private Server server;
    private BufferAllocator allocator;
    private String serverName;

    @BeforeEach
    public void setup() throws IOException {
        this.allocator = new RootAllocator(Integer.MAX_VALUE);
        NoOpFlightProducer producer = new NoOpFlightProducer();
        ServerAuthHandler authHandler = ServerAuthHandler.NO_OP;
        ExecutorService exec = Executors.newCachedThreadPool();
        BindableService flightBindingService = FlightGrpcUtils.createFlightService((BufferAllocator)this.allocator, (FlightProducer)producer, (ServerAuthHandler)authHandler, (ExecutorService)exec);
        this.serverName = InProcessServerBuilder.generateName();
        this.server = ((InProcessServerBuilder)((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)this.serverName).directExecutor()).addService(flightBindingService)).addService((BindableService)new TestServiceAdapter())).build();
        this.server.start();
    }

    @AfterEach
    public void cleanup() {
        this.server.shutdownNow();
    }

    @Test
    public void testMultipleGrpcServices() throws IOException {
        ManagedChannel managedChannel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.serverName).directExecutor()).build();
        FlightClient flightClient = FlightGrpcUtils.createFlightClient((BufferAllocator)this.allocator, (ManagedChannel)managedChannel);
        Iterable actionTypes = flightClient.listActions(new CallOption[0]);
        Assertions.assertThrows(FlightRuntimeException.class, () -> actionTypes.forEach(actionType -> System.out.println(actionType.toString())));
        TestServiceGrpc.TestServiceBlockingStub blockingStub = TestServiceGrpc.newBlockingStub((Channel)managedChannel);
        Assertions.assertEquals((Object)Empty.newBuilder().build(), (Object)blockingStub.test(Empty.newBuilder().build()));
    }

    @Test
    public void testShutdown() throws IOException, InterruptedException {
        ManagedChannel managedChannel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.serverName).directExecutor()).build();
        FlightClient flightClient = FlightGrpcUtils.createFlightClientWithSharedChannel((BufferAllocator)this.allocator, (ManagedChannel)managedChannel);
        flightClient.close();
        Assertions.assertFalse((boolean)managedChannel.isShutdown());
        Assertions.assertFalse((boolean)managedChannel.isTerminated());
        Assertions.assertEquals((Object)ConnectivityState.IDLE, (Object)managedChannel.getState(false));
        managedChannel.shutdownNow();
    }

    @Test
    public void testProxyChannel() throws IOException, InterruptedException {
        ManagedChannel managedChannel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.serverName).directExecutor()).build();
        FlightGrpcUtils.NonClosingProxyManagedChannel proxyChannel = new FlightGrpcUtils.NonClosingProxyManagedChannel(managedChannel);
        Assertions.assertFalse((boolean)proxyChannel.isShutdown());
        Assertions.assertFalse((boolean)proxyChannel.isTerminated());
        proxyChannel.shutdown();
        Assertions.assertTrue((boolean)proxyChannel.isShutdown());
        Assertions.assertTrue((boolean)proxyChannel.isTerminated());
        Assertions.assertEquals((Object)ConnectivityState.SHUTDOWN, (Object)proxyChannel.getState(false));
        try {
            proxyChannel.newCall(null, null);
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)managedChannel.isShutdown());
        Assertions.assertFalse((boolean)managedChannel.isTerminated());
        Assertions.assertEquals((Object)ConnectivityState.IDLE, (Object)managedChannel.getState(false));
        managedChannel.shutdownNow();
    }

    @Test
    public void testProxyChannelWithClosedChannel() throws IOException, InterruptedException {
        ManagedChannel managedChannel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.serverName).directExecutor()).build();
        FlightGrpcUtils.NonClosingProxyManagedChannel proxyChannel = new FlightGrpcUtils.NonClosingProxyManagedChannel(managedChannel);
        Assertions.assertFalse((boolean)proxyChannel.isShutdown());
        Assertions.assertFalse((boolean)proxyChannel.isTerminated());
        managedChannel.shutdownNow();
        Assertions.assertTrue((boolean)proxyChannel.isShutdown());
        Assertions.assertTrue((boolean)proxyChannel.isTerminated());
        Assertions.assertEquals((Object)ConnectivityState.SHUTDOWN, (Object)proxyChannel.getState(false));
        try {
            proxyChannel.newCall(null, null);
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)managedChannel.isShutdown());
        Assertions.assertTrue((boolean)managedChannel.isTerminated());
        Assertions.assertEquals((Object)ConnectivityState.SHUTDOWN, (Object)managedChannel.getState(false));
    }

    private static class TestServiceAdapter
    extends TestServiceGrpc.TestServiceImplBase {
        private TestServiceAdapter() {
        }

        @Override
        public void test(Empty request, StreamObserver<Empty> responseObserver) {
            responseObserver.onNext((Object)Empty.newBuilder().build());
            responseObserver.onCompleted();
        }
    }
}

