/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.flight.AsyncPutListener;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.DictionaryUtils;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.TestBasicOperation;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryEncoder;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestFlightClient {
    @Test
    public void independentShutdown() throws Exception {
        try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
             FlightServer server = FlightServer.builder((BufferAllocator)allocator, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)new TestBasicOperation.Producer((BufferAllocator)allocator)).build().start();){
            Schema schema = new Schema(Collections.singletonList(Field.nullable((String)"a", (ArrowType)new ArrowType.Int(32, true))));
            try (FlightClient client1 = FlightClient.builder((BufferAllocator)allocator, (Location)server.getLocation()).build();
                 VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);){
                FlightClient.ClientStreamListener listener = client1.startPut(FlightDescriptor.path((String[])new String[]{"test"}), root, (FlightClient.PutListener)new AsyncPutListener(), new CallOption[0]);
                try (FlightClient client2 = FlightClient.builder((BufferAllocator)allocator, (Location)server.getLocation()).build();){
                    client2.listActions(new CallOption[0]).forEach(actionType -> Assertions.assertNotNull((Object)actionType.getType()));
                }
                listener.completed();
                listener.getResult();
            }
        }
    }

    @Disabled
    @Test
    public void freeDictionaries() throws Exception {
        Schema expectedSchema = new Schema(Collections.singletonList(new Field("encoded", new FieldType(true, (ArrowType)new ArrowType.Int(32, true), new DictionaryEncoding(1L, false, null)), null)));
        try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
             BufferAllocator serverAllocator = allocator.newChildAllocator("flight-server", 0L, Integer.MAX_VALUE);
             FlightServer server = FlightServer.builder((BufferAllocator)serverAllocator, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)new DictionaryProducer(serverAllocator)).build().start();
             FlightClient client = FlightClient.builder((BufferAllocator)allocator, (Location)server.getLocation()).build();
             FlightStream stream = client.getStream(new Ticket(new byte[0]), new CallOption[0]);){
            Assertions.assertTrue((boolean)stream.next());
            Assertions.assertNotNull((Object)stream.getDictionaryProvider().lookup(1L));
            VectorSchemaRoot root = stream.getRoot();
            Assertions.assertEquals((Object)expectedSchema, (Object)root.getSchema());
            Assertions.assertEquals((int)6, (int)root.getVector("encoded").getValueCount());
            try (ValueVector decoded = DictionaryEncoder.decode((ValueVector)root.getVector("encoded"), (Dictionary)stream.getDictionaryProvider().lookup(1L));){
                Assertions.assertFalse((boolean)decoded.isNull(1));
                Assertions.assertTrue((boolean)(decoded instanceof VarCharVector));
                Assertions.assertArrayEquals((byte[])"one".getBytes(StandardCharsets.UTF_8), (byte[])((VarCharVector)decoded).get(1));
            }
            Assertions.assertFalse((boolean)stream.next());
        }
    }

    @Disabled
    @Test
    public void ownDictionaries() throws Exception {
        try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
             BufferAllocator serverAllocator = allocator.newChildAllocator("flight-server", 0L, Integer.MAX_VALUE);
             FlightServer server = FlightServer.builder((BufferAllocator)serverAllocator, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)new DictionaryProducer(serverAllocator)).build().start();
             FlightClient client = FlightClient.builder((BufferAllocator)allocator, (Location)server.getLocation()).build();
             FlightStream stream = client.getStream(new Ticket(new byte[0]), new CallOption[0]);){
            Assertions.assertTrue((boolean)stream.next());
            Assertions.assertFalse((boolean)stream.next());
            DictionaryProvider provider = stream.takeDictionaryOwnership();
            Assertions.assertThrows(IllegalStateException.class, () -> ((FlightStream)stream).takeDictionaryOwnership());
            Assertions.assertThrows(IllegalStateException.class, () -> ((FlightStream)stream).getDictionaryProvider());
            DictionaryUtils.closeDictionaries((Schema)stream.getSchema(), (DictionaryProvider)provider);
        }
    }

    @Disabled
    @Test
    public void useDictionariesAfterClose() throws Exception {
        try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
             BufferAllocator serverAllocator = allocator.newChildAllocator("flight-server", 0L, Integer.MAX_VALUE);
             FlightServer server = FlightServer.builder((BufferAllocator)serverAllocator, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)new DictionaryProducer(serverAllocator)).build().start();
             FlightClient client = FlightClient.builder((BufferAllocator)allocator, (Location)server.getLocation()).build();){
            DictionaryProvider provider;
            VectorSchemaRoot root;
            try (FlightStream stream = client.getStream(new Ticket(new byte[0]), new CallOption[0]);){
                VectorUnloader unloader = new VectorUnloader(stream.getRoot());
                root = VectorSchemaRoot.create((Schema)stream.getSchema(), (BufferAllocator)allocator);
                VectorLoader loader = new VectorLoader(root);
                while (stream.next()) {
                    ArrowRecordBatch arb = unloader.getRecordBatch();
                    try {
                        loader.load(arb);
                    }
                    finally {
                        if (arb == null) continue;
                        arb.close();
                    }
                }
                provider = stream.takeDictionaryOwnership();
            }
            try (ValueVector decoded = DictionaryEncoder.decode((ValueVector)root.getVector("encoded"), (Dictionary)provider.lookup(1L));){
                Assertions.assertFalse((boolean)decoded.isNull(1));
                Assertions.assertTrue((boolean)(decoded instanceof VarCharVector));
                Assertions.assertArrayEquals((byte[])"one".getBytes(StandardCharsets.UTF_8), (byte[])((VarCharVector)decoded).get(1));
            }
            root.close();
            DictionaryUtils.closeDictionaries((Schema)root.getSchema(), (DictionaryProvider)provider);
        }
    }

    static class DictionaryProducer
    extends NoOpFlightProducer {
        private final BufferAllocator allocator;

        public DictionaryProducer(BufferAllocator allocator) {
            this.allocator = allocator;
        }

        public void getStream(FlightProducer.CallContext context, Ticket ticket, FlightProducer.ServerStreamListener listener) {
            byte[] zero = "zero".getBytes(StandardCharsets.UTF_8);
            byte[] one = "one".getBytes(StandardCharsets.UTF_8);
            byte[] two = "two".getBytes(StandardCharsets.UTF_8);
            try (VarCharVector dictionaryVector = DictionaryProducer.newVarCharVector("dictionary", this.allocator);){
                FieldVector encodedVector;
                DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
                dictionaryVector.allocateNew(512L, 3);
                dictionaryVector.setSafe(0, zero, 0, zero.length);
                dictionaryVector.setSafe(1, one, 0, one.length);
                dictionaryVector.setSafe(2, two, 0, two.length);
                dictionaryVector.setValueCount(3);
                Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
                provider.put(dictionary);
                try (VarCharVector unencoded = DictionaryProducer.newVarCharVector("encoded", this.allocator);){
                    unencoded.allocateNewSafe();
                    unencoded.set(1, one);
                    unencoded.set(2, two);
                    unencoded.set(3, zero);
                    unencoded.set(4, two);
                    unencoded.setValueCount(6);
                    encodedVector = (FieldVector)DictionaryEncoder.encode((ValueVector)unencoded, (Dictionary)dictionary);
                }
                List<Field> fields = Collections.singletonList(encodedVector.getField());
                List<FieldVector> vectors = Collections.singletonList(encodedVector);
                try (VectorSchemaRoot root = new VectorSchemaRoot(fields, vectors, encodedVector.getValueCount());){
                    listener.start(root, (DictionaryProvider)provider);
                    listener.putNext();
                    listener.completed();
                }
            }
        }

        private static VarCharVector newVarCharVector(String name, BufferAllocator allocator) {
            return (VarCharVector)FieldType.nullable((ArrowType)new ArrowType.Utf8()).createNewSingleVector(name, allocator, null);
        }
    }
}

