/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.rpc.Status;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.protobuf.StatusProto;
import java.nio.charset.StandardCharsets;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.ErrorFlightMetadata;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStatusCode;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.FlightTestUtil;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.perf.impl.PerfOuterClass;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestErrorMetadata {
    private static final Metadata.BinaryMarshaller<Status> marshaller = ProtoUtils.metadataMarshaller((Message)Status.getDefaultInstance());

    @Test
    public void testGrpcMetadata() throws Exception {
        PerfOuterClass.Perf perf = PerfOuterClass.Perf.newBuilder().setStreamCount(12).setRecordsPerBatch(1000).setRecordsPerStream(1000000L).build();
        StatusRuntimeExceptionProducer producer = new StatusRuntimeExceptionProducer(perf);
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
             FlightServer s = FlightServer.builder((BufferAllocator)allocator, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)producer).build().start();
             FlightClient client = FlightClient.builder((BufferAllocator)allocator, (Location)s.getLocation()).build();){
            CallStatus flightStatus = FlightTestUtil.assertCode(FlightStatusCode.CANCELLED, () -> {
                FlightStream stream = client.getStream(new Ticket("abs".getBytes(StandardCharsets.UTF_8)), new CallOption[0]);
                stream.next();
            });
            PerfOuterClass.Perf newPerf = null;
            ErrorFlightMetadata metadata = flightStatus.metadata();
            Assertions.assertNotNull((Object)metadata);
            Assertions.assertEquals((int)2, (int)metadata.keys().size());
            Assertions.assertTrue((boolean)metadata.containsKey("grpc-status-details-bin"));
            Status status = (Status)marshaller.parseBytes(metadata.getByte("grpc-status-details-bin"));
            for (Any details : status.getDetailsList()) {
                if (!details.is(PerfOuterClass.Perf.class)) continue;
                try {
                    newPerf = (PerfOuterClass.Perf)details.unpack(PerfOuterClass.Perf.class);
                }
                catch (InvalidProtocolBufferException e) {
                    Assertions.fail();
                }
            }
            Assertions.assertNotNull(newPerf);
            Assertions.assertEquals((Object)perf, newPerf);
        }
    }

    @Test
    public void testFlightMetadata() throws Exception {
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
             FlightServer s = FlightServer.builder((BufferAllocator)allocator, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)new CallStatusProducer()).build().start();
             FlightClient client = FlightClient.builder((BufferAllocator)allocator, (Location)s.getLocation()).build();){
            CallStatus flightStatus = FlightTestUtil.assertCode(FlightStatusCode.INVALID_ARGUMENT, () -> {
                FlightStream stream = client.getStream(new Ticket(new byte[0]), new CallOption[0]);
                stream.next();
            });
            ErrorFlightMetadata metadata = flightStatus.metadata();
            Assertions.assertNotNull((Object)metadata);
            Assertions.assertEquals((Object)"foo", (Object)metadata.get("x-foo"));
            Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])metadata.getByte("x-bar-bin"));
            flightStatus = FlightTestUtil.assertCode(FlightStatusCode.INVALID_ARGUMENT, () -> client.getInfo(FlightDescriptor.command((byte[])new byte[0]), new CallOption[0]));
            metadata = flightStatus.metadata();
            Assertions.assertNotNull((Object)metadata);
            Assertions.assertEquals((Object)"foo", (Object)metadata.get("x-foo"));
            Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])metadata.getByte("x-bar-bin"));
        }
    }

    private static class StatusRuntimeExceptionProducer
    extends NoOpFlightProducer {
        private final PerfOuterClass.Perf perf;

        private StatusRuntimeExceptionProducer(PerfOuterClass.Perf perf) {
            this.perf = perf;
        }

        public void getStream(FlightProducer.CallContext context, Ticket ticket, FlightProducer.ServerStreamListener listener) {
            StatusRuntimeException sre = StatusProto.toStatusRuntimeException((Status)Status.newBuilder().setCode(1).setMessage("Testing 1 2 3").addDetails(Any.pack((Message)this.perf, (String)"arrow/meta/types")).build());
            listener.error((Throwable)sre);
        }
    }

    private static class CallStatusProducer
    extends NoOpFlightProducer {
        ErrorFlightMetadata metadata = new ErrorFlightMetadata();

        CallStatusProducer() {
            this.metadata.insert("x-foo", "foo");
            this.metadata.insert("x-bar-bin", new byte[]{1});
        }

        public void getStream(FlightProducer.CallContext context, Ticket ticket, FlightProducer.ServerStreamListener listener) {
            listener.error((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Failed").withMetadata(this.metadata).toRuntimeException());
        }

        public FlightInfo getFlightInfo(FlightProducer.CallContext context, FlightDescriptor descriptor) {
            throw CallStatus.INVALID_ARGUMENT.withDescription("Failed").withMetadata(this.metadata).toRuntimeException();
        }
    }
}

