/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.collect.ImmutableList;
import java.util.TreeSet;
import org.apache.arrow.flight.DictionaryUtils;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDictionaryUtils {
    @Test
    public void testReuseSchema() {
        FieldType varcharType = new FieldType(true, (ArrowType)new ArrowType.Utf8(), null);
        FieldType intType = new FieldType(true, (ArrowType)new ArrowType.Int(32, true), null);
        ImmutableList build = ImmutableList.of((Object)new Field("stringCol", varcharType, null), (Object)new Field("intCol", intType, null));
        Schema schema = new Schema((Iterable)build);
        Schema newSchema = DictionaryUtils.generateSchema((Schema)schema, null, new TreeSet());
        Assertions.assertSame((Object)schema, (Object)newSchema);
    }

    @Test
    public void testCreateSchema() {
        try (RootAllocator allocator = new RootAllocator(1024L);){
            DictionaryEncoding dictionaryEncoding = new DictionaryEncoding(0L, true, new ArrowType.Int(8, true));
            VarCharVector dictVec = new VarCharVector("dict vector", (BufferAllocator)allocator);
            Dictionary dictionary = new Dictionary((FieldVector)dictVec, dictionaryEncoding);
            DictionaryProvider.MapDictionaryProvider dictProvider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[]{dictionary});
            TreeSet dictionaryUsed = new TreeSet();
            FieldType encodedVarcharType = new FieldType(true, (ArrowType)new ArrowType.Int(8, true), dictionaryEncoding);
            FieldType intType = new FieldType(true, (ArrowType)new ArrowType.Int(32, true), null);
            ImmutableList build = ImmutableList.of((Object)new Field("stringCol", encodedVarcharType, null), (Object)new Field("intCol", intType, null));
            Schema schema = new Schema((Iterable)build);
            Schema newSchema = DictionaryUtils.generateSchema((Schema)schema, (DictionaryProvider)dictProvider, dictionaryUsed);
            Assertions.assertNotSame((Object)schema, (Object)newSchema);
            ArrowType newColType = ((Field)newSchema.getFields().get(0)).getType();
            Assertions.assertEquals((Object)new ArrowType.Utf8(), (Object)newColType);
            Assertions.assertEquals((int)1, (int)dictionaryUsed.size());
            Assertions.assertEquals((long)0L, (Long)((Long)dictionaryUsed.first()));
        }
    }
}

