/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.arrow.flight.Action;
import org.apache.arrow.flight.CallHeaders;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallOptions;
import org.apache.arrow.flight.FlightCallHeaders;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightConstants;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.HeaderCallOption;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.Result;
import org.apache.arrow.flight.ServerHeaderMiddleware;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestCallOptions {
    @Test
    @Disabled
    public void timeoutFires() {
        this.test(client -> {
            Instant start = Instant.now();
            Iterator results = client.doAction(new Action("hang"), new CallOption[]{CallOptions.timeout((long)1L, (TimeUnit)TimeUnit.SECONDS)});
            try {
                results.next();
                Assertions.fail((String)"Call should have failed");
            }
            catch (RuntimeException e) {
                Assertions.assertTrue((boolean)e.getMessage().contains("deadline exceeded"), (String)e.getMessage());
            }
            Instant end = Instant.now();
            Assertions.assertTrue((Duration.between(start, end).toMillis() < 1500L ? 1 : 0) != 0, (String)"Call took over 1500 ms despite timeout");
        });
    }

    @Test
    @Disabled
    public void underTimeout() {
        this.test(client -> {
            Instant start = Instant.now();
            Iterator results = client.doAction(new Action("fast"), new CallOption[]{CallOptions.timeout((long)2L, (TimeUnit)TimeUnit.SECONDS)});
            Assertions.assertArrayEquals((byte[])new byte[]{42, 42}, (byte[])((Result)results.next()).getBody());
            Instant end = Instant.now();
            Assertions.assertTrue((Duration.between(start, end).toMillis() < 2500L ? 1 : 0) != 0, (String)"Call took over 2500 ms despite timeout");
        });
    }

    @Test
    public void singleProperty() {
        FlightCallHeaders headers = new FlightCallHeaders();
        headers.insert("key", "value");
        this.testHeaders((CallHeaders)headers);
    }

    @Test
    public void multipleProperties() {
        FlightCallHeaders headers = new FlightCallHeaders();
        headers.insert("key", "value");
        headers.insert("key2", "value2");
        this.testHeaders((CallHeaders)headers);
    }

    @Test
    public void binaryProperties() {
        FlightCallHeaders headers = new FlightCallHeaders();
        headers.insert("key-bin", "value".getBytes(StandardCharsets.UTF_8));
        headers.insert("key3-bin", "\u00ebf\u00df\u00e6".getBytes(StandardCharsets.UTF_8));
        this.testHeaders((CallHeaders)headers);
    }

    @Test
    public void mixedProperties() {
        FlightCallHeaders headers = new FlightCallHeaders();
        headers.insert("key", "value");
        headers.insert("key3-bin", "\u00ebf\u00df\u00e6".getBytes(StandardCharsets.UTF_8));
        this.testHeaders((CallHeaders)headers);
    }

    private void testHeaders(CallHeaders headers) {
        try (RootAllocator a = new RootAllocator(Long.MAX_VALUE);
             HeaderProducer producer = new HeaderProducer();
             FlightServer s = FlightServer.builder((BufferAllocator)a, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)producer).build().start();
             FlightClient client = FlightClient.builder((BufferAllocator)a, (Location)s.getLocation()).build();){
            Assertions.assertFalse((boolean)client.doAction(new Action(""), new CallOption[]{new HeaderCallOption(headers)}).hasNext());
            CallHeaders incomingHeaders = producer.headers();
            for (String key : headers.keys()) {
                if (key.endsWith("-bin")) {
                    Assertions.assertArrayEquals((byte[])headers.getByte(key), (byte[])incomingHeaders.getByte(key));
                    continue;
                }
                Assertions.assertEquals((Object)headers.get(key), (Object)incomingHeaders.get(key));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    void test(Consumer<FlightClient> testFn) {
        try (RootAllocator a = new RootAllocator(Long.MAX_VALUE);
             Producer producer = new Producer();
             FlightServer s = FlightServer.builder((BufferAllocator)a, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)producer).build().start();
             FlightClient client = FlightClient.builder((BufferAllocator)a, (Location)s.getLocation()).build();){
            testFn.accept(client);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static class HeaderProducer
    extends NoOpFlightProducer
    implements AutoCloseable {
        CallHeaders headers;

        HeaderProducer() {
        }

        @Override
        public void close() {
        }

        public CallHeaders headers() {
            return this.headers;
        }

        public void doAction(FlightProducer.CallContext context, Action action, FlightProducer.StreamListener<Result> listener) {
            this.headers = ((ServerHeaderMiddleware)context.getMiddleware(FlightConstants.HEADER_KEY)).headers();
            listener.onCompleted();
        }
    }

    static class Producer
    extends NoOpFlightProducer
    implements AutoCloseable {
        Producer() {
        }

        @Override
        public void close() {
        }

        public void doAction(FlightProducer.CallContext context, Action action, FlightProducer.StreamListener<Result> listener) {
            switch (action.getType()) {
                case "hang": {
                    try {
                        Thread.sleep(25000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    listener.onNext((Object)new Result(new byte[0]));
                    listener.onCompleted();
                    return;
                }
                case "fast": {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    listener.onNext((Object)new Result(new byte[]{42, 42}));
                    listener.onCompleted();
                    return;
                }
            }
            throw new UnsupportedOperationException(action.getType());
        }
    }
}

