/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import java.util.Iterator;
import java.util.Optional;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.auth.ClientAuthHandler;
import org.apache.arrow.flight.auth.ServerAuthHandler;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAuth {
    @Test
    public void noMessages() throws Exception {
        Assertions.assertThrows(RuntimeException.class, () -> {
            try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
                 FlightServer s = FlightServer.builder((BufferAllocator)allocator, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)new NoOpFlightProducer()).authHandler((ServerAuthHandler)new OneshotAuthHandler()).build().start();
                 FlightClient client = FlightClient.builder((BufferAllocator)allocator, (Location)s.getLocation()).build();){
                client.authenticate(new ClientAuthHandler(){

                    public void authenticate(ClientAuthHandler.ClientAuthSender outgoing, Iterator<byte[]> incoming) {
                    }

                    public byte[] getCallToken() {
                        return new byte[0];
                    }
                }, new CallOption[0]);
            }
        });
    }

    @Test
    public void clientError() throws Exception {
        Assertions.assertThrows(RuntimeException.class, () -> {
            try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
                 FlightServer s = FlightServer.builder((BufferAllocator)allocator, (Location)Location.forGrpcInsecure((String)"localhost", (int)0), (FlightProducer)new NoOpFlightProducer()).authHandler((ServerAuthHandler)new OneshotAuthHandler()).build().start();
                 FlightClient client = FlightClient.builder((BufferAllocator)allocator, (Location)s.getLocation()).build();){
                client.authenticate(new ClientAuthHandler(){

                    public void authenticate(ClientAuthHandler.ClientAuthSender outgoing, Iterator<byte[]> incoming) {
                        outgoing.send(new byte[0]);
                        incoming.next();
                        outgoing.onError((Throwable)new RuntimeException("test"));
                    }

                    public byte[] getCallToken() {
                        return new byte[0];
                    }
                }, new CallOption[0]);
            }
        });
    }

    private static class OneshotAuthHandler
    implements ServerAuthHandler {
        private OneshotAuthHandler() {
        }

        public Optional<String> isValid(byte[] token) {
            return Optional.of("test");
        }

        public boolean authenticate(ServerAuthHandler.ServerAuthSender outgoing, Iterator<byte[]> incoming) {
            incoming.next();
            outgoing.send(new byte[0]);
            return false;
        }
    }
}

