/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.FlightStatusCode;
import org.apache.arrow.vector.test.util.ArrowTestDataUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;

public class FlightTestUtil {
    public static final String LOCALHOST = "localhost";

    static Path getFlightTestDataRoot() {
        return ArrowTestDataUtil.getTestDataRoot().resolve("flight");
    }

    static Path exampleTlsRootCert() {
        return FlightTestUtil.getFlightTestDataRoot().resolve("root-ca.pem");
    }

    static List<CertKeyPair> exampleTlsCerts() {
        Path root = FlightTestUtil.getFlightTestDataRoot();
        Path cert0Pem = root.resolve("cert0.pem");
        if (!Files.exists(cert0Pem, new LinkOption[0])) {
            throw new RuntimeException(String.valueOf(cert0Pem) + " doesn't exist. Make sure submodules are initialized (see https://arrow.apache.org/docs/dev/developers/java/building.html#building)");
        }
        return Arrays.asList(new CertKeyPair(cert0Pem.toFile(), root.resolve("cert0.pkcs1").toFile()), new CertKeyPair(root.resolve("cert1.pem").toFile(), root.resolve("cert1.pkcs1").toFile()));
    }

    static boolean isEpollAvailable() {
        try {
            Class<?> epoll = Class.forName("io.netty.channel.epoll.Epoll");
            return (Boolean)epoll.getMethod("isAvailable", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    static boolean isKqueueAvailable() {
        try {
            Class<?> kqueue = Class.forName("io.netty.channel.kqueue.KQueue");
            return (Boolean)kqueue.getMethod("isAvailable", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    static boolean isNativeTransportAvailable() {
        return FlightTestUtil.isEpollAvailable() || FlightTestUtil.isKqueueAvailable();
    }

    public static CallStatus assertCode(FlightStatusCode code, Executable r) {
        FlightRuntimeException ex = (FlightRuntimeException)Assertions.assertThrows(FlightRuntimeException.class, (Executable)r);
        Assertions.assertEquals((Object)code, (Object)ex.status().code());
        return ex.status();
    }

    private FlightTestUtil() {
    }

    public static class CertKeyPair {
        public final File cert;
        public final File key;

        public CertKeyPair(File cert, File key) {
            this.cert = cert;
            this.key = key;
        }
    }
}

