/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.OutOfMemoryException;
import org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.BufferBacked;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueIterableVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.compare.VectorVisitor;
import org.apache.arrow.vector.complex.impl.NullReader;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.CallBack;
import org.apache.arrow.vector.util.TransferPair;

public class NullVector
implements FieldVector,
ValueIterableVector<Object> {
    private int valueCount;
    protected Field field;

    public NullVector(String name) {
        this(name, FieldType.nullable(Types.MinorType.NULL.getType()));
    }

    public NullVector(String name, int valueCount) {
        this(new Field(name, FieldType.nullable(Types.MinorType.NULL.getType()), null), valueCount);
    }

    public NullVector(String name, FieldType fieldType) {
        this(new Field(name, fieldType, null));
    }

    public NullVector(Field field) {
        this(field, 0);
    }

    public NullVector(Field field, int valueCount) {
        this.field = field;
        this.valueCount = valueCount;
    }

    @Deprecated
    public NullVector() {
        this(new Field("$data$", FieldType.nullable(new ArrowType.Null()), null));
    }

    @Override
    public void close() {
    }

    @Override
    public void clear() {
    }

    @Override
    public void reset() {
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.NULL;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return this.getTransferPair(this.getName(), allocator);
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public int getBufferSize() {
        return 0;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        return 0;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        return new ArrowBuf[0];
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        this.allocateNewSafe();
    }

    @Override
    public boolean allocateNewSafe() {
        return true;
    }

    @Override
    public void reAlloc() {
    }

    @Override
    public BufferAllocator getAllocator() {
        return null;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
    }

    @Override
    public int getValueCapacity() {
        return this.valueCount;
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field.getName());
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return this.getTransferPair(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator, CallBack callBack) {
        return this.getTransferPair(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return new TransferImpl((NullVector)target);
    }

    @Override
    public FieldReader getReader() {
        return NullReader.INSTANCE;
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        if (!children.isEmpty()) {
            throw new IllegalArgumentException("Null vector has no children");
        }
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return Collections.emptyList();
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        Preconditions.checkArgument(ownBuffers.isEmpty(), "Null vector has no buffers");
        this.valueCount = fieldNode.getLength();
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        return Collections.emptyList();
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        return Collections.emptyList();
    }

    @Override
    public long getValidityBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getDataBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getOffsetBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getDataBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
    }

    @Override
    public Object getObject(int index) {
        return null;
    }

    @Override
    public int getNullCount() {
        return this.valueCount;
    }

    @Override
    public void setNull(int index) {
    }

    @Override
    public boolean isNull(int index) {
        return true;
    }

    @Override
    public int hashCode(int index) {
        return 31;
    }

    @Override
    public int hashCode(int index, ArrowBufHasher hasher) {
        return 31;
    }

    @Override
    public <OUT, IN> OUT accept(VectorVisitor<OUT, IN> visitor, IN value) {
        return visitor.visit(this, value);
    }

    @Override
    public void copyFrom(int fromIndex, int thisIndex, ValueVector from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyFromSafe(int fromIndex, int thisIndex, ValueVector from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.getField().getName();
    }

    private class TransferImpl
    implements TransferPair {
        NullVector to;

        public TransferImpl(String ref) {
            this.to = new NullVector(ref);
        }

        @Deprecated
        public TransferImpl() {
            this.to = new NullVector();
        }

        public TransferImpl(NullVector to) {
            this.to = to;
        }

        @Override
        public NullVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            this.to.valueCount = NullVector.this.valueCount;
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            this.to.valueCount = length;
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            if (toIndex > this.to.valueCount) {
                this.to.valueCount = toIndex;
            }
        }
    }
}

