/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;

public class FileToStream {
    private FileToStream() {
    }

    public static void convert(FileInputStream in, OutputStream out) throws IOException {
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        try (ArrowFileReader reader = new ArrowFileReader(in.getChannel(), (BufferAllocator)allocator);){
            VectorSchemaRoot root = reader.getVectorSchemaRoot();
            boolean writeBatches = reader.loadNextBatch();
            try (ArrowStreamWriter writer = new ArrowStreamWriter(root, (DictionaryProvider)reader, out);){
                writer.start();
                while (writeBatches) {
                    writer.writeBatch();
                    if (reader.loadNextBatch()) continue;
                }
                writer.end();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1 && args.length != 2) {
            System.err.println("Usage: FileToStream <input file> [output file]");
            System.exit(1);
        }
        FileInputStream in = new FileInputStream(new File(args[0]));
        OutputStream out = args.length == 1 ? System.out : new FileOutputStream(new File(args[1]));
        FileToStream.convert(in, out);
    }
}

