/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.unsafe;

import org.apache.arrow.memory.AllocationManager;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.BufferLedger;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.unsafe.UnsafeAllocationManager;
import org.junit.Assert;
import org.junit.Test;

public class TestUnsafeAllocationManager {
    private BufferAllocator createUnsafeAllocator() {
        return new RootAllocator((BaseAllocator.Config)RootAllocator.configBuilder().allocationManagerFactory(UnsafeAllocationManager.FACTORY).build());
    }

    private void readWriteArrowBuf(ArrowBuf buffer) {
        long i;
        for (i = 0L; i < buffer.capacity() / 8L; ++i) {
            buffer.setLong(i * 8L, i);
        }
        for (i = 0L; i < buffer.capacity() / 8L; ++i) {
            long val = buffer.getLong(i * 8L);
            Assert.assertEquals((long)i, (long)val);
        }
    }

    @Test
    public void testBufferAllocation() {
        long bufSize = 4096L;
        try (BufferAllocator allocator = this.createUnsafeAllocator();
             ArrowBuf buffer = allocator.buffer(4096L);){
            Assert.assertTrue((boolean)(buffer.getReferenceManager() instanceof BufferLedger));
            BufferLedger bufferLedger = (BufferLedger)buffer.getReferenceManager();
            AllocationManager allocMgr = bufferLedger.getAllocationManager();
            Assert.assertTrue((boolean)(allocMgr instanceof UnsafeAllocationManager));
            UnsafeAllocationManager unsafeMgr = (UnsafeAllocationManager)allocMgr;
            Assert.assertEquals((long)4096L, (long)unsafeMgr.getSize());
            this.readWriteArrowBuf(buffer);
        }
    }
}

