/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.h2;

import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.apache.arrow.adapter.jdbc.AbstractJdbcToArrowTest;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowTestHelper;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adapter.jdbc.Table;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JdbcToArrowTimeZoneTest
extends AbstractJdbcToArrowTest {
    private static final String EST_DATE = "est_date";
    private static final String EST_TIME = "est_time";
    private static final String EST_TIMESTAMP = "est_timestamp";
    private static final String GMT_DATE = "gmt_date";
    private static final String GMT_TIME = "gmt_time";
    private static final String GMT_TIMESTAMP = "gmt_timestamp";
    private static final String PST_DATE = "pst_date";
    private static final String PST_TIME = "pst_time";
    private static final String PST_TIMESTAMP = "pst_timestamp";
    private static final String[] testFiles = new String[]{"h2/test1_est_date_h2.yml", "h2/test1_est_time_h2.yml", "h2/test1_est_timestamp_h2.yml", "h2/test1_gmt_date_h2.yml", "h2/test1_gmt_time_h2.yml", "h2/test1_gmt_timestamp_h2.yml", "h2/test1_pst_date_h2.yml", "h2/test1_pst_time_h2.yml", "h2/test1_pst_timestamp_h2.yml"};

    public static Stream<Arguments> getTestData() throws SQLException, ClassNotFoundException, IOException {
        return Arrays.stream(JdbcToArrowTimeZoneTest.prepareTestData(testFiles, JdbcToArrowTimeZoneTest.class)).map(Arguments::of);
    }

    @Override
    @ParameterizedTest
    @MethodSource(value={"getTestData"})
    public void testJdbcToArrowValues(Table table) throws SQLException, IOException, ClassNotFoundException {
        this.initializeDatabase(table);
        this.testDataSets(this.sqlToArrow(this.conn, table.getQuery(), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance(TimeZone.getTimeZone(table.getTimezone()))), false);
        this.testDataSets(JdbcToArrowTimeZoneTest.sqlToArrow(this.conn.createStatement().executeQuery(table.getQuery()), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance(TimeZone.getTimeZone(table.getTimezone()))), false);
        this.testDataSets(JdbcToArrowTimeZoneTest.sqlToArrow(this.conn.createStatement().executeQuery(table.getQuery()), Calendar.getInstance(TimeZone.getTimeZone(table.getTimezone()))), false);
        this.testDataSets(JdbcToArrowTimeZoneTest.sqlToArrow(this.conn.createStatement().executeQuery(table.getQuery()), new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance(TimeZone.getTimeZone(table.getTimezone()))).build()), false);
        this.testDataSets(JdbcToArrowTimeZoneTest.sqlToArrow(this.conn, table.getQuery(), new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance(TimeZone.getTimeZone(table.getTimezone()))).build()), false);
    }

    @ParameterizedTest
    @MethodSource(value={"getTestData"})
    public void testJdbcSchemaMetadata(Table table) throws SQLException, ClassNotFoundException {
        this.initializeDatabase(table);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(table.getTimezone()));
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(0L), calendar, true).build();
        ResultSetMetaData rsmd = this.conn.createStatement().executeQuery(table.getQuery()).getMetaData();
        Schema schema = JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)rsmd, (JdbcToArrowConfig)config);
        JdbcToArrowTestHelper.assertFieldMetadataMatchesResultSetMetadata(rsmd, schema);
    }

    @Override
    public void testDataSets(VectorSchemaRoot root, boolean isIncludeMapVector) {
        JdbcToArrowTestHelper.assertFieldMetadataIsEmpty(root);
        switch (this.table.getType()) {
            case "est_date": 
            case "gmt_date": 
            case "pst_date": {
                JdbcToArrowTestHelper.assertDateVectorValues((DateDayVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getIntValues());
                break;
            }
            case "est_time": 
            case "gmt_time": 
            case "pst_time": {
                JdbcToArrowTestHelper.assertTimeVectorValues((TimeMilliVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getLongValues());
                break;
            }
            case "est_timestamp": 
            case "gmt_timestamp": 
            case "pst_timestamp": {
                JdbcToArrowTestHelper.assertTimeStampVectorValues((TimeStampVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getLongValues());
                break;
            }
        }
    }
}

