/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.h2;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.arrow.adapter.jdbc.AbstractJdbcToArrowTest;
import org.apache.arrow.adapter.jdbc.JdbcToArrowTestHelper;
import org.apache.arrow.adapter.jdbc.Table;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Field;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JdbcToArrowOptionalColumnsTest
extends AbstractJdbcToArrowTest {
    private static final String[] testFiles = new String[]{"h2/test1_null_and_notnull.yml"};

    public static Stream<Arguments> getTestData() throws SQLException, ClassNotFoundException, IOException {
        return Arrays.stream(JdbcToArrowOptionalColumnsTest.prepareTestData(testFiles, JdbcToArrowOptionalColumnsTest.class)).map(Arguments::of);
    }

    @Override
    @ParameterizedTest
    @MethodSource(value={"getTestData"})
    public void testJdbcToArrowValues(Table table) throws SQLException, IOException, ClassNotFoundException {
        this.initializeDatabase(table);
        this.testDataSets(this.sqlToArrow(this.conn, table.getQuery(), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE)), false);
    }

    @Override
    public void testDataSets(VectorSchemaRoot root, boolean isIncludeMapVector) {
        JdbcToArrowTestHelper.assertFieldMetadataIsEmpty(root);
        Assertions.assertTrue((boolean)((Field)root.getSchema().getFields().get(0)).isNullable());
        Assertions.assertFalse((boolean)((Field)root.getSchema().getFields().get(1)).isNullable());
    }
}

