/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.h2;

import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.stream.Stream;
import org.apache.arrow.adapter.jdbc.AbstractJdbcToArrowTest;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowTestHelper;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adapter.jdbc.Table;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseValueVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JdbcToArrowNullTest
extends AbstractJdbcToArrowTest {
    private static final String NULL = "null";
    private static final String SELECTED_NULL_ROW = "selected_null_row";
    private static final String SELECTED_NULL_COLUMN = "selected_null_column";
    private static final String[] testFiles = new String[]{"h2/test1_all_datatypes_null_h2.yml", "h2/test1_selected_datatypes_null_h2.yml", "h2/test1_all_datatypes_selected_null_rows_h2.yml"};

    public static Stream<Arguments> getTestData() throws SQLException, ClassNotFoundException, IOException {
        return Arrays.stream(JdbcToArrowNullTest.prepareTestData(testFiles, JdbcToArrowNullTest.class)).map(Arguments::of);
    }

    @Override
    @ParameterizedTest
    @MethodSource(value={"getTestData"})
    public void testJdbcToArrowValues(Table table) throws SQLException, IOException, ClassNotFoundException {
        this.initializeDatabase(table);
        this.testDataSets(this.sqlToArrow(this.conn, table.getQuery(), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()), false);
        this.testDataSets(this.sqlToArrow(this.conn, table.getQuery(), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE)), false);
        this.testDataSets(JdbcToArrowNullTest.sqlToArrow(this.conn.createStatement().executeQuery(table.getQuery()), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()), false);
        this.testDataSets(JdbcToArrowNullTest.sqlToArrow(this.conn.createStatement().executeQuery(table.getQuery())), false);
        this.testDataSets(JdbcToArrowNullTest.sqlToArrow(this.conn.createStatement().executeQuery(table.getQuery()), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE)), false);
        this.testDataSets(JdbcToArrowNullTest.sqlToArrow(this.conn.createStatement().executeQuery(table.getQuery()), Calendar.getInstance()), false);
        Calendar calendar = Calendar.getInstance();
        ResultSetMetaData rsmd = this.getQueryMetaData(table.getQuery());
        this.testDataSets(JdbcToArrowNullTest.sqlToArrow(this.conn.createStatement().executeQuery(table.getQuery()), new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).setJdbcToArrowTypeConverter(this.jdbcToArrowTypeConverter(calendar, rsmd)).build()), true);
        this.testDataSets(JdbcToArrowNullTest.sqlToArrow(this.conn, table.getQuery(), new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).setJdbcToArrowTypeConverter(this.jdbcToArrowTypeConverter(calendar, rsmd)).build()), true);
    }

    @ParameterizedTest
    @MethodSource(value={"getTestData"})
    public void testJdbcSchemaMetadata(Table table) throws SQLException, ClassNotFoundException {
        this.initializeDatabase(table);
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(0L), Calendar.getInstance(), true).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build();
        ResultSetMetaData rsmd = this.conn.createStatement().executeQuery(table.getQuery()).getMetaData();
        Schema schema = JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)rsmd, (JdbcToArrowConfig)config);
        JdbcToArrowTestHelper.assertFieldMetadataMatchesResultSetMetadata(rsmd, schema);
    }

    @Override
    public void testDataSets(VectorSchemaRoot root, boolean isIncludeMapVector) {
        JdbcToArrowTestHelper.assertFieldMetadataIsEmpty(root);
        switch (this.table.getType()) {
            case "null": {
                this.sqlToArrowTestNullValues(this.table.getVectors(), root, this.table.getRowCount());
                break;
            }
            case "selected_null_column": {
                this.sqlToArrowTestSelectedNullColumnsValues(this.table.getVectors(), root, this.table.getRowCount(), isIncludeMapVector);
                break;
            }
            case "selected_null_row": {
                this.testAllVectorValues(root, isIncludeMapVector);
                break;
            }
        }
    }

    private void testAllVectorValues(VectorSchemaRoot root, boolean isIncludeMapVector) {
        JdbcToArrowTestHelper.assertFieldMetadataIsEmpty(root);
        JdbcToArrowTestHelper.assertBigIntVectorValues((BigIntVector)root.getVector("BIGINT_FIELD5"), this.table.getRowCount(), JdbcToArrowTestHelper.getLongValues(this.table.getValues(), "BIGINT_FIELD5"));
        JdbcToArrowTestHelper.assertTinyIntVectorValues((TinyIntVector)root.getVector("TINYINT_FIELD3"), this.table.getRowCount(), JdbcToArrowTestHelper.getIntValues(this.table.getValues(), "TINYINT_FIELD3"));
        JdbcToArrowTestHelper.assertSmallIntVectorValues((SmallIntVector)root.getVector("SMALLINT_FIELD4"), this.table.getRowCount(), JdbcToArrowTestHelper.getIntValues(this.table.getValues(), "SMALLINT_FIELD4"));
        JdbcToArrowTestHelper.assertVarBinaryVectorValues((VarBinaryVector)root.getVector("BINARY_FIELD12"), this.table.getRowCount(), JdbcToArrowTestHelper.getBinaryValues(this.table.getValues(), "BINARY_FIELD12"));
        JdbcToArrowTestHelper.assertVarBinaryVectorValues((VarBinaryVector)root.getVector("BLOB_FIELD14"), this.table.getRowCount(), JdbcToArrowTestHelper.getBinaryValues(this.table.getValues(), "BLOB_FIELD14"));
        JdbcToArrowTestHelper.assertVarcharVectorValues((VarCharVector)root.getVector("CLOB_FIELD15"), this.table.getRowCount(), JdbcToArrowTestHelper.getCharArray(this.table.getValues(), "CLOB_FIELD15"));
        JdbcToArrowTestHelper.assertVarcharVectorValues((VarCharVector)root.getVector("VARCHAR_FIELD13"), this.table.getRowCount(), JdbcToArrowTestHelper.getCharArray(this.table.getValues(), "VARCHAR_FIELD13"));
        JdbcToArrowTestHelper.assertVarcharVectorValues((VarCharVector)root.getVector("CHAR_FIELD16"), this.table.getRowCount(), JdbcToArrowTestHelper.getCharArray(this.table.getValues(), "CHAR_FIELD16"));
        JdbcToArrowTestHelper.assertIntVectorValues((IntVector)root.getVector("INT_FIELD1"), this.table.getRowCount(), JdbcToArrowTestHelper.getIntValues(this.table.getValues(), "INT_FIELD1"));
        JdbcToArrowTestHelper.assertBitVectorValues((BitVector)root.getVector("BIT_FIELD17"), this.table.getRowCount(), JdbcToArrowTestHelper.getIntValues(this.table.getValues(), "BIT_FIELD17"));
        JdbcToArrowTestHelper.assertBooleanVectorValues((BitVector)root.getVector("BOOL_FIELD2"), this.table.getRowCount(), JdbcToArrowTestHelper.getBooleanValues(this.table.getValues(), "BOOL_FIELD2"));
        JdbcToArrowTestHelper.assertDateVectorValues((DateDayVector)root.getVector("DATE_FIELD10"), this.table.getRowCount(), JdbcToArrowTestHelper.getIntValues(this.table.getValues(), "DATE_FIELD10"));
        JdbcToArrowTestHelper.assertTimeVectorValues((TimeMilliVector)root.getVector("TIME_FIELD9"), this.table.getRowCount(), JdbcToArrowTestHelper.getLongValues(this.table.getValues(), "TIME_FIELD9"));
        JdbcToArrowTestHelper.assertTimeStampVectorValues((TimeStampVector)root.getVector("TIMESTAMP_FIELD11"), this.table.getRowCount(), JdbcToArrowTestHelper.getLongValues(this.table.getValues(), "TIMESTAMP_FIELD11"));
        JdbcToArrowTestHelper.assertDecimalVectorValues((DecimalVector)root.getVector("DECIMAL_FIELD6"), this.table.getRowCount(), JdbcToArrowTestHelper.getDecimalValues(this.table.getValues(), "DECIMAL_FIELD6"));
        JdbcToArrowTestHelper.assertFloat8VectorValues((Float8Vector)root.getVector("DOUBLE_FIELD7"), this.table.getRowCount(), JdbcToArrowTestHelper.getDoubleValues(this.table.getValues(), "DOUBLE_FIELD7"));
        JdbcToArrowTestHelper.assertFloat4VectorValues((Float4Vector)root.getVector("REAL_FIELD8"), this.table.getRowCount(), JdbcToArrowTestHelper.getFloatValues(this.table.getValues(), "REAL_FIELD8"));
        JdbcToArrowTestHelper.assertListVectorValues((ListVector)root.getVector("LIST_FIELD19"), this.table.getRowCount(), JdbcToArrowTestHelper.getListValues(this.table.getValues(), "LIST_FIELD19"));
        if (isIncludeMapVector) {
            JdbcToArrowTestHelper.assertMapVectorValues((MapVector)root.getVector("MAP_FIELD20"), this.table.getRowCount(), JdbcToArrowTestHelper.getMapValues(this.table.getValues(), "MAP_FIELD20"));
        }
    }

    public void sqlToArrowTestNullValues(String[] vectors, VectorSchemaRoot root, int rowCount) {
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((IntVector)root.getVector(vectors[0])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((BitVector)root.getVector(vectors[1])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((TinyIntVector)root.getVector(vectors[2])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((SmallIntVector)root.getVector(vectors[3])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((BigIntVector)root.getVector(vectors[4])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((DecimalVector)root.getVector(vectors[5])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((Float8Vector)root.getVector(vectors[6])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((Float4Vector)root.getVector(vectors[7])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((TimeMilliVector)root.getVector(vectors[8])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((DateDayVector)root.getVector(vectors[9])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((TimeStampVector)root.getVector(vectors[10])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((VarBinaryVector)root.getVector(vectors[11])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((VarCharVector)root.getVector(vectors[12])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((VarBinaryVector)root.getVector(vectors[13])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((VarCharVector)root.getVector(vectors[14])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((VarCharVector)root.getVector(vectors[15])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((BitVector)root.getVector(vectors[16])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((ListVector)root.getVector(vectors[17])), rowCount);
    }

    public void sqlToArrowTestSelectedNullColumnsValues(String[] vectors, VectorSchemaRoot root, int rowCount, boolean isIncludeMapVector) {
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((BigIntVector)root.getVector(vectors[0])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((DecimalVector)root.getVector(vectors[1])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((Float8Vector)root.getVector(vectors[2])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((Float4Vector)root.getVector(vectors[3])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((TimeMilliVector)root.getVector(vectors[4])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((DateDayVector)root.getVector(vectors[5])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((TimeStampVector)root.getVector(vectors[6])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((VarBinaryVector)root.getVector(vectors[7])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((VarCharVector)root.getVector(vectors[8])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((VarBinaryVector)root.getVector(vectors[9])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((VarCharVector)root.getVector(vectors[10])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((VarCharVector)root.getVector(vectors[11])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((BitVector)root.getVector(vectors[12])), rowCount);
        JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((ListVector)root.getVector(vectors[13])), rowCount);
        if (isIncludeMapVector) {
            JdbcToArrowTestHelper.assertNullValues((BaseValueVector)((MapVector)root.getVector(vectors[14])), rowCount);
        }
    }
}

