/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.h2;

import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.stream.Stream;
import org.apache.arrow.adapter.jdbc.AbstractJdbcToArrowTest;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowTestHelper;
import org.apache.arrow.adapter.jdbc.Table;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.MapVector;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JdbcToArrowMapDataTypeTest
extends AbstractJdbcToArrowTest {
    public static Stream<Arguments> getTestData() throws IOException {
        return Stream.of(Arguments.of((Object[])new Object[]{JdbcToArrowMapDataTypeTest.getTable("h2/test1_map_h2.yml", JdbcToArrowMapDataTypeTest.class)}));
    }

    @Override
    @ParameterizedTest
    @MethodSource(value={"getTestData"})
    public void testJdbcToArrowValues(Table table) throws SQLException, IOException, ClassNotFoundException {
        this.initializeDatabase(table);
        Calendar calendar = Calendar.getInstance();
        ResultSetMetaData rsmd = this.getQueryMetaData(table.getQuery());
        this.testDataSets(JdbcToArrowMapDataTypeTest.sqlToArrow(this.conn.createStatement().executeQuery(table.getQuery()), new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).setJdbcToArrowTypeConverter(this.jdbcToArrowTypeConverter(calendar, rsmd)).build()), true);
        this.testDataSets(JdbcToArrowMapDataTypeTest.sqlToArrow(this.conn, table.getQuery(), new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).setJdbcToArrowTypeConverter(this.jdbcToArrowTypeConverter(calendar, rsmd)).build()), true);
    }

    @Override
    public void testDataSets(VectorSchemaRoot root, boolean isIncludeMapVector) {
        JdbcToArrowTestHelper.assertMapVectorValues((MapVector)root.getVector("MAP_FIELD20"), this.table.getRowCount(), JdbcToArrowTestHelper.getMapValues(this.table.getValues(), "MAP_FIELD20"));
    }
}

