/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.h2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.arrow.adapter.jdbc.AbstractJdbcToArrowTest;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JdbcAliasToArrowTest {
    private Connection conn = null;
    private static final String CREATE_STATEMENT = "CREATE TABLE example_table (id INTEGER);";
    private static final String INSERT_STATEMENT = "INSERT INTO example_table (id) VALUES (?);";
    private static final String QUERY = "SELECT id as a, id as b FROM example_table;";
    private static final String DROP_STATEMENT = "DROP TABLE example_table;";
    private static final String ORIGINAL_COLUMN_NAME = "ID";
    private static final String COLUMN_A = "A";
    private static final String COLUMN_B = "B";

    @BeforeEach
    public void setUp() throws Exception {
        String url = "jdbc:h2:mem:JdbcAliasToArrowTest";
        String driver = "org.h2.Driver";
        Class.forName(driver);
        this.conn = DriverManager.getConnection(url);
        try (Statement stmt = this.conn.createStatement();){
            stmt.executeUpdate(CREATE_STATEMENT);
        }
    }

    @Test
    public void testReadH2Alias() throws Exception {
        int rowCount = 4;
        this.insertRows(rowCount);
        try (ResultSet resultSet = this.conn.createStatement().executeQuery(QUERY);){
            ResultSetMetaData rsmd = resultSet.getMetaData();
            Assertions.assertEquals((int)2, (int)rsmd.getColumnCount());
            Assertions.assertEquals((Object)ORIGINAL_COLUMN_NAME, (Object)rsmd.getColumnName(1));
            Assertions.assertEquals((Object)COLUMN_A, (Object)rsmd.getColumnLabel(1));
            Assertions.assertEquals((Object)ORIGINAL_COLUMN_NAME, (Object)rsmd.getColumnName(2));
            Assertions.assertEquals((Object)COLUMN_B, (Object)rsmd.getColumnLabel(2));
            int rowNum = 0;
            while (resultSet.next()) {
                Assertions.assertEquals((int)rowNum, (int)resultSet.getInt(COLUMN_A));
                Assertions.assertEquals((int)rowNum, (int)resultSet.getInt(COLUMN_B));
                ++rowNum;
            }
            Assertions.assertEquals((int)rowCount, (int)rowNum);
        }
    }

    @Test
    public void testJdbcAliasToArrow() throws Exception {
        int rowCount = 4;
        this.insertRows(rowCount);
        try (ResultSet resultSet = this.conn.createStatement().executeQuery(QUERY);){
            VectorSchemaRoot vector = AbstractJdbcToArrowTest.sqlToArrow(resultSet, (BufferAllocator)new RootAllocator(Integer.MAX_VALUE));
            Assertions.assertEquals((int)rowCount, (int)vector.getRowCount());
            Schema vectorSchema = vector.getSchema();
            List vectorFields = vectorSchema.getFields();
            Assertions.assertEquals((Object)COLUMN_A, (Object)((Field)vectorFields.get(0)).getName());
            Assertions.assertEquals((Object)COLUMN_B, (Object)((Field)vectorFields.get(1)).getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterEach
    public void tearDown() throws SQLException {
        try (Statement stmt = this.conn.createStatement();){
            stmt.executeUpdate(DROP_STATEMENT);
        }
        finally {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
    }

    private void insertRows(int numRows) throws SQLException {
        try (PreparedStatement stmt = this.conn.prepareStatement(INSERT_STATEMENT);){
            for (int i = 0; i < numRows; ++i) {
                stmt.setInt(1, i);
                stmt.executeUpdate();
            }
        }
    }
}

